/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.type;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.type.ApplicationType;
import com.sun.tools.visualvm.application.type.MainClassApplicationTypeFactory;
import com.sun.tools.visualvm.application.type.NetBeans3xApplicationType;
import com.sun.tools.visualvm.application.type.NetBeansApplicationType;
import com.sun.tools.visualvm.application.type.NetBeansBasedApplicationType;
import com.sun.tools.visualvm.application.type.VisualVMApplicationType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetBeansApplicationTypeFactory
extends MainClassApplicationTypeFactory {
    private static final String NETBEANS_DIRS = "-Dnetbeans.dirs=";
    private static final String NB_PLATFORM_HOME = "-Dnetbeans.home=";
    private static final String BRANDING_ID = "--branding ";
    private static final String VISUALVM_ID = "visualvm";
    private static final String MAIN_CLASS = "org.netbeans.Main";
    private static final Pattern NBCLUSTER_PATTERN = Pattern.compile("nb[0-9]+\\.[0-9]+");
    static final String NB_CLUSTER = "nb";

    private boolean isNetBeans(Jvm jvm, String mainClass) {
        String args;
        if (MAIN_CLASS.equals(mainClass)) {
            return true;
        }
        return (mainClass == null || mainClass.length() == 0) && (args = jvm.getJvmArgs()) != null && args.contains(NB_PLATFORM_HOME);
    }

    protected Set<String> computeClusters(Jvm jvm) {
        String args = jvm.getJvmArgs();
        int clusterIndex = args.indexOf(NETBEANS_DIRS);
        String pathSeparator = jvm.getJavaHome().contains("\\") ? ";" : ":";
        String separator = pathSeparator.equals(":") ? "/" : "\\";
        HashSet<String> clusters = new HashSet<String>();
        if (clusterIndex > -1) {
            String clustersString = args.substring(clusterIndex);
            int endIndex = clustersString.indexOf(" -");
            if (endIndex > -1) {
                clustersString = clustersString.substring(0, endIndex);
            }
            Scanner clusterScanner = new Scanner(clustersString).useDelimiter(pathSeparator);
            while (clusterScanner.hasNext()) {
                String clusterPath = clusterScanner.next();
                int pathIndex = clusterPath.lastIndexOf(separator);
                if (pathIndex <= -1) continue;
                clusters.add(clusterPath.substring(pathIndex + 1));
            }
        }
        return Collections.unmodifiableSet(clusters);
    }

    protected String getBranding(Jvm jvm) {
        int brandingOffset;
        String args = jvm.getMainArgs();
        if (args != null && (brandingOffset = args.indexOf(BRANDING_ID)) > -1) {
            Scanner sc = new Scanner(args.substring(brandingOffset));
            sc.next();
            if (sc.hasNext()) {
                return sc.next();
            }
        }
        return null;
    }

    @Override
    public ApplicationType createApplicationTypeFor(Application app, Jvm jvm, String mainClass) {
        if (this.isNetBeans(jvm, mainClass)) {
            String branding = this.getBranding(jvm);
            if (VISUALVM_ID.equals(branding)) {
                return new VisualVMApplicationType(app);
            }
            Set<String> clusters = this.computeClusters(jvm);
            for (String cluster : clusters) {
                if (NBCLUSTER_PATTERN.matcher(cluster).matches()) {
                    return new NetBeansApplicationType(app, jvm, clusters);
                }
                if (NB_CLUSTER.equals(cluster)) {
                    return new NetBeansApplicationType(app, jvm, clusters);
                }
                if (!VISUALVM_ID.equals(cluster)) continue;
                return new VisualVMApplicationType(app);
            }
            if (clusters.isEmpty() && branding == null) {
                return new NetBeans3xApplicationType(app, jvm);
            }
            return new NetBeansBasedApplicationType(app, jvm, clusters, branding);
        }
        return null;
    }
}

