/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.type.ApplicationType;
import com.sun.tools.visualvm.application.type.ApplicationTypeFactory;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptor
extends DataSourceDescriptor<Application> {
    private String name = super.getName();

    protected ApplicationDescriptor(Application application) {
        this(application, ApplicationTypeFactory.getApplicationTypeFor(application), 0x7FFFFFFE);
    }

    protected ApplicationDescriptor(Application application, int preferredPosition) {
        this(application, ApplicationTypeFactory.getApplicationTypeFor(application), preferredPosition);
    }

    private ApplicationDescriptor(final Application application, final ApplicationType type, int preferredPosition) {
        super((DataSource)application, ApplicationDescriptor.resolveApplicationName(application, type), type.getDescription(), type.getIcon(), preferredPosition, 1);
        type.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("name".equals(propertyName)) {
                    if (ApplicationDescriptor.resolveName((DataSource)application, (String)null) != null) {
                        return;
                    }
                    if (ApplicationDescriptor.this.supportsRename()) {
                        ApplicationDescriptor.this.setName((String)evt.getNewValue());
                        ApplicationDescriptor.this.name = ApplicationDescriptor.super.getName();
                    } else {
                        String oldName = ApplicationDescriptor.this.name;
                        ApplicationDescriptor.this.name = ApplicationDescriptor.createGenericName(application, type.getName());
                        PropertyChangeSupport pcs = ApplicationDescriptor.this.getChangeSupport();
                        pcs.firePropertyChange("prop_name", oldName, ApplicationDescriptor.this.name);
                    }
                } else if ("icon".equals(propertyName)) {
                    ApplicationDescriptor.this.setIcon((Image)evt.getNewValue());
                } else if ("description".equals(propertyName)) {
                    ApplicationDescriptor.this.setDescription((String)evt.getNewValue());
                } else if ("version".equals(propertyName)) {
                    // empty if block
                }
            }
        });
    }

    public String getName() {
        if (this.supportsRename()) {
            return super.getName();
        }
        return this.name;
    }

    public boolean providesProperties() {
        return true;
    }

    protected static String resolveApplicationName(Application application, ApplicationType type) {
        String persistedName = ApplicationDescriptor.resolveName((DataSource)application, null);
        if (persistedName != null) {
            return persistedName;
        }
        return ApplicationDescriptor.createGenericName(application, type.getName());
    }

    private static String createGenericName(Application application, String nameBase) {
        int pid = application.getPid();
        String id = Application.CURRENT_APPLICATION.getPid() == pid || pid == -1 ? "" : " (pid " + pid + ")";
        return nameBase + id;
    }
}

