/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtil {
    public static Document parse(InputSource inputSource, boolean bl, boolean bl2, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(bl);
        documentBuilderFactory.setNamespaceAware(bl2);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
        if (errorHandler != null) {
            documentBuilder.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        assert (inputSource != null) : "InputSource cannot be null";
        return documentBuilder.parse(inputSource);
    }

    public static Document createDocument(String string) throws DOMException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            return documentBuilderFactory.newDocumentBuilder().getDOMImplementation().createDocument(null, string, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw (DOMException)new DOMException(9, "Cannot create parser").initCause(parserConfigurationException);
        }
    }

    public static void write(Document document, OutputStream outputStream) throws IOException {
        try {
            Object object;
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DocumentType documentType = document.getDoctype();
            if (documentType != null) {
                object = documentType.getPublicId();
                if (object != null) {
                    transformer.setOutputProperty("doctype-public", (String)object);
                }
                transformer.setOutputProperty("doctype-system", documentType.getSystemId());
            }
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            object = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform((Source)object, streamResult);
        }
        catch (Exception exception) {
            throw (IOException)new IOException(exception.toString()).initCause(exception);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw (IOException)new IOException(transformerFactoryConfigurationError.toString()).initCause(transformerFactoryConfigurationError);
        }
    }

    public static EntityResolver createAUResolver() {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
                if ("-//NetBeans//DTD Autoupdate Catalog 1.0//EN".equals(string)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-1_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 1.0//EN".equals(string)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-info-1_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.0//EN".equals(string)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-2_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.0//EN".equals(string)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-info-2_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.2//EN".equals(string)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-2_2.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.2//EN".equals(string)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-info-2_2.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.3//EN".equals(string)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-2_3.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.3//EN".equals(string)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-info-2_3.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.4//EN".equals(string)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-2_4.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.4//EN".equals(string)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-info-2_4.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.5//EN".equals(string)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-2_5.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.5//EN".equals(string)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-info-2_5.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.6//EN".equals(string)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-2_6.dtd").toString());
                }
                return null;
            }
        };
    }
}

