/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.netbeans.lib.profiler.wireprotocol.Command;

public class EventBufferDumpedCommand
extends Command {
    private int bufSize;
    private byte[] buffer;
    private int startPos;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EventBufferDumpedCommand(int n, byte[] byArray, int n2) {
        super(26);
        this.bufSize = n;
        this.buffer = byArray;
        this.startPos = n2;
    }

    EventBufferDumpedCommand() {
        super(26);
    }

    public int getBufSize() {
        return this.bufSize;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public String toString() {
        return super.toString() + ", bufSize: " + this.bufSize;
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bufSize = objectInputStream.readInt();
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            int n = objectInputStream.readInt();
            byte[] byArray = new byte[n];
            Inflater inflater = new Inflater();
            this.buffer = new byte[this.bufSize];
            objectInputStream.readFully(byArray);
            inflater.setInput(byArray);
            try {
                int n2 = inflater.inflate(this.buffer);
                if (!$assertionsDisabled && n2 != this.bufSize) {
                    throw new AssertionError();
                }
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException(dataFormatException.getMessage());
            }
            finally {
                inflater.end();
            }
        }
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.bufSize);
        objectOutputStream.writeBoolean(this.buffer != null);
        if (this.buffer != null) {
            Deflater deflater = new Deflater();
            byte[] byArray = new byte[this.bufSize + 32];
            deflater.setInput(this.buffer, this.startPos, this.bufSize);
            deflater.finish();
            int n = deflater.deflate(byArray);
            objectOutputStream.writeInt(n);
            objectOutputStream.write(byArray, 0, n);
        }
    }

    static {
        $assertionsDisabled = !EventBufferDumpedCommand.class.desiredAssertionStatus();
    }
}

