/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateLicenseImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogProvider;
import org.netbeans.modules.autoupdate.updateprovider.ModuleItem;
import org.netbeans.modules.autoupdate.updateprovider.UpdateItemImpl;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateLicense;
import org.netbeans.updater.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AutoupdateCatalogParser
extends DefaultHandler {
    private final Map<String, UpdateItem> items;
    private final AutoupdateCatalogProvider provider;
    private final EntityResolver entityResolver;
    private final URI baseUri;
    private static final Logger ERR = Logger.getLogger(AutoupdateCatalogParser.class.getName());
    private static final String MODULE_UPDATES_ATTR_TIMESTAMP = "timestamp";
    private static final String MODULE_GROUP_ATTR_NAME = "name";
    private static final String NOTIFICATION_ATTR_URL = "url";
    private static final String LICENSE_ATTR_NAME = "name";
    private static final String MODULE_ATTR_CODE_NAME_BASE = "codenamebase";
    private static final String MODULE_ATTR_HOMEPAGE = "homepage";
    private static final String MODULE_ATTR_DISTRIBUTION = "distribution";
    private static final String MODULE_ATTR_DOWNLOAD_SIZE = "downloadsize";
    private static final String MODULE_ATTR_NEEDS_RESTART = "needsrestart";
    private static final String MODULE_ATTR_MODULE_AUTHOR = "moduleauthor";
    private static final String MODULE_ATTR_RELEASE_DATE = "releasedate";
    private static final String MODULE_ATTR_IS_GLOBAL = "global";
    private static final String MODULE_ATTR_TARGET_CLUSTER = "targetcluster";
    private static final String MODULE_ATTR_EAGER = "eager";
    private static final String MODULE_ATTR_AUTOLOAD = "autoload";
    private static final String MODULE_ATTR_LICENSE = "license";
    private static final String LICENSE_ATTR_URL = "url";
    private static final String MANIFEST_ATTR_SPECIFICATION_VERSION = "OpenIDE-Module-Specification-Version";
    private static final String TIME_STAMP_FORMAT = "ss/mm/hh/dd/MM/yyyy";
    private static final String L10N_ATTR_LOCALE = "langcode";
    private static final String L10N_ATTR_BRANDING = "brandingcode";
    private static final String L10N_ATTR_MODULE_SPECIFICATION = "module_spec_version";
    private static final String L10N_ATTR_MODULE_MAJOR_VERSION = "module_major_version";
    private static final String L10N_ATTR_LOCALIZED_MODULE_NAME = "OpenIDE-Module-Name";
    private static final String L10N_ATTR_LOCALIZED_MODULE_DESCRIPTION = "OpenIDE-Module-Long-Description";
    private static String GZIP_EXTENSION = ".gz";
    private Stack<String> currentGroup = new Stack();
    private String catalogDate;
    private Stack<ModuleDescriptor> currentModule = new Stack();
    private Stack<Map<String, String>> currentLicense = new Stack();
    private Stack<String> currentNotificationUrl = new Stack();
    private Map<String, UpdateLicenseImpl> name2license = new HashMap<String, UpdateLicenseImpl>();
    private List<String> lines = new ArrayList<String>();
    private int bufferInitSize = 0;

    private AutoupdateCatalogParser(Map<String, UpdateItem> map, AutoupdateCatalogProvider autoupdateCatalogProvider, URI uRI) {
        this.items = map;
        this.provider = autoupdateCatalogProvider;
        this.entityResolver = this.newEntityResolver();
        this.baseUri = uRI;
    }

    private EntityResolver newEntityResolver() {
        try {
            Class.forName("org.netbeans.updater.XMLUtil");
        }
        catch (ClassNotFoundException classNotFoundException) {
            File file = new File(System.getProperty("netbeans.home"));
            File file2 = new File(System.getProperty("netbeans.user"));
            File file3 = new File(file, "modules/ext/updater.jar");
            File file4 = new File(file2, "modules/ext/updater.jar");
            File file5 = new File(file, "update/new_updater/updater.jar");
            File file6 = new File(file2, "update/new_updater/updater.jar");
            String string = "    org.netbeans.updater.XMLUtil is not accessible\n    platform dir = " + file.getAbsolutePath() + "\n" + "    userdir  dir = " + file2.getAbsolutePath() + "\n" + "    updater in platform exist = " + file3.exists() + (file3.exists() ? ", length = " + file3.length() + " bytes" : "") + "\n" + "    updater in userdir  exist = " + file4.exists() + (file4.exists() ? ", length = " + file4.length() + " bytes" : "") + "\n" + "    new updater in platform exist = " + file5.exists() + (file5.exists() ? ", length = " + file5.length() + " bytes" : "") + "\n" + "    new updater in userdir  exist = " + file6.exists() + (file6.exists() ? ", length = " + file6.length() + " bytes" : "") + "\n";
            ERR.log(Level.WARNING, string);
        }
        return XMLUtil.createAUResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Map<String, UpdateItem> getUpdateItems(URL uRL, AutoupdateCatalogProvider autoupdateCatalogProvider) {
        HashMap<String, UpdateItem> hashMap = new HashMap<String, UpdateItem>();
        try {
            URI uRI = autoupdateCatalogProvider != null ? autoupdateCatalogProvider.getUpdateCenterURL().toURI() : uRL.toURI();
            InputSource inputSource = null;
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(true);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                inputSource = AutoupdateCatalogParser.getInputSource(uRL, autoupdateCatalogProvider, uRI);
                sAXParser.parse(inputSource, (DefaultHandler)new AutoupdateCatalogParser(hashMap, autoupdateCatalogProvider, uRI));
            }
            catch (Exception exception) {
                ERR.log(Level.INFO, "Failed to parse " + uRI, exception);
            }
            finally {
                if (inputSource != null && inputSource.getByteStream() != null) {
                    try {
                        inputSource.getByteStream().close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            ERR.log(Level.INFO, null, uRISyntaxException);
        }
        return hashMap;
    }

    private static boolean isGzip(AutoupdateCatalogProvider autoupdateCatalogProvider) {
        boolean bl = false;
        if (autoupdateCatalogProvider != null) {
            URL uRL = autoupdateCatalogProvider.getUpdateCenterURL();
            if (uRL != null) {
                bl = uRL.getPath().toLowerCase().endsWith(GZIP_EXTENSION);
                ERR.log(Level.FINER, "Is GZIP " + uRL + " ? " + bl);
            } else {
                ERR.log(Level.WARNING, "AutoupdateCatalogProvider has not URL.");
            }
        }
        return bl;
    }

    private static InputSource getInputSource(URL uRL, AutoupdateCatalogProvider autoupdateCatalogProvider, URI uRI) {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            if (AutoupdateCatalogParser.isGzip(autoupdateCatalogProvider)) {
                try {
                    inputStream = new GZIPInputStream(inputStream);
                }
                catch (IOException iOException) {
                    ERR.log(Level.INFO, "The file at " + uRL + ", corresponding to the catalog at " + autoupdateCatalogProvider.getUpdateCenterURL() + ", does not look like the gzip file, trying to parse it as the pure xml", iOException);
                    inputStream.close();
                    inputStream = null;
                    inputStream = uRL.openStream();
                }
            }
            InputSource inputSource = new InputSource(new BufferedInputStream(inputStream));
            inputSource.setSystemId(uRI.toString());
            return inputSource;
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            ERR.log(Level.SEVERE, "Cannot estabilish input stream for " + uRL, iOException);
            return new InputSource();
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.lines.add(new String(cArray, n, n2));
        this.bufferInitSize += n2;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        switch (ELEMENTS.valueOf(string3)) {
            case module_updates: {
                break;
            }
            case module_group: {
                assert (!this.currentGroup.empty()) : "Premature end of module_group " + string3;
                this.currentGroup.pop();
                break;
            }
            case module: {
                assert (!this.currentModule.empty()) : "Premature end of module " + string3;
                this.currentModule.pop();
                break;
            }
            case l10n: {
                break;
            }
            case manifest: {
                break;
            }
            case description: {
                ERR.info("Not supported yet.");
                break;
            }
            case notification: {
                if (this.provider != null && !this.lines.isEmpty()) {
                    String string42;
                    StringBuffer stringBuffer = new StringBuffer(this.bufferInitSize);
                    for (String string42 : this.lines) {
                        stringBuffer.append(string42);
                    }
                    Object object = stringBuffer.toString();
                    string42 = this.currentNotificationUrl.peek();
                    object = string42 != null && string42.length() > 0 ? (String)object + (((String)object).length() > 0 ? "<br>" : "") + "<a name=\"autoupdate_catalog_parser\" href=\"" + string42 + "\">" + string42 + "</a>" : (String)object + (((String)object).length() > 0 ? "<br>" : "") + "<a name=\"autoupdate_catalog_parser\"/>";
                    this.provider.setNotification((String)object);
                }
                this.currentNotificationUrl.pop();
                break;
            }
            case module_notification: {
                if (this.lines.isEmpty()) break;
                ModuleDescriptor moduleDescriptor = this.currentModule.peek();
                assert (moduleDescriptor != null) : "ModuleDescriptor found for " + this.provider;
                StringBuffer stringBuffer = new StringBuffer(this.bufferInitSize);
                for (String string5 : this.lines) {
                    stringBuffer.append(string5);
                }
                moduleDescriptor.appendNotification(stringBuffer.toString());
                break;
            }
            case external_package: {
                ERR.info("Not supported yet.");
                break;
            }
            case license: {
                assert (!this.currentLicense.empty()) : "Premature end of license " + string3;
                Map<String, String> map = this.currentLicense.peek();
                String string6 = map.keySet().iterator().next();
                Collection<String> collection = map.values();
                String string7 = collection.size() > 0 ? collection.iterator().next() : null;
                UpdateLicenseImpl updateLicenseImpl = this.name2license.get(string6);
                if (updateLicenseImpl == null) {
                    ERR.info("Unpaired license " + string6 + " without any module.");
                } else if (!this.lines.isEmpty()) {
                    StringBuffer stringBuffer = new StringBuffer(this.bufferInitSize);
                    for (String string8 : this.lines) {
                        stringBuffer.append(string8);
                    }
                    updateLicenseImpl.setAgreement(stringBuffer.toString());
                } else if (string7 != null) {
                    updateLicenseImpl.setUrl(AutoupdateCatalogParser.getDistribution(string7, this.baseUri));
                }
                this.currentLicense.pop();
                break;
            }
            default: {
                ERR.warning("Unknown element " + string3);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        ERR.fine("End parsing " + (this.provider == null ? "" : this.provider.getUpdateCenterURL()) + " at " + System.currentTimeMillis());
    }

    @Override
    public void startDocument() throws SAXException {
        ERR.fine("Start parsing " + (this.provider == null ? "" : this.provider.getUpdateCenterURL()) + " at " + System.currentTimeMillis());
    }

    @Override
    public void startElement(String string, String string2, String string3, org.xml.sax.Attributes attributes) throws SAXException {
        this.lines.clear();
        this.bufferInitSize = 0;
        switch (ELEMENTS.valueOf(string3)) {
            case module_updates: {
                try {
                    this.catalogDate = "";
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_STAMP_FORMAT);
                    String string4 = attributes.getValue(MODULE_UPDATES_ATTR_TIMESTAMP);
                    if (string4 == null) {
                        ERR.info("No timestamp is presented in " + (this.provider == null ? "" : this.provider.getUpdateCenterURL()));
                        break;
                    }
                    this.catalogDate = Utilities.formatDate(simpleDateFormat.parse(string4));
                    ERR.finer("Successfully read time " + string4);
                }
                catch (ParseException parseException) {
                    ERR.log(Level.INFO, null, parseException);
                }
                break;
            }
            case module_group: {
                this.currentGroup.push(attributes.getValue("name"));
                break;
            }
            case module: {
                ModuleDescriptor moduleDescriptor = ModuleDescriptor.getModuleDescriptor(this.currentGroup.size() > 0 ? this.currentGroup.peek() : null, this.baseUri, this.catalogDate);
                moduleDescriptor.appendModuleAttributes(attributes);
                this.currentModule.push(moduleDescriptor);
                break;
            }
            case l10n: {
                break;
            }
            case manifest: {
                ModuleDescriptor moduleDescriptor = this.currentModule.peek();
                moduleDescriptor.appendManifest(attributes);
                UpdateItem updateItem = moduleDescriptor.createUpdateItem();
                UpdateItemImpl updateItemImpl = Trampoline.SPI.impl(updateItem);
                String string5 = updateItemImpl.getUpdateLicenseImpl().getName();
                if (this.name2license.keySet().contains(string5)) {
                    updateItemImpl.setUpdateLicenseImpl(this.name2license.get(string5));
                } else {
                    this.name2license.put(updateItemImpl.getUpdateLicenseImpl().getName(), updateItemImpl.getUpdateLicenseImpl());
                }
                this.items.put(moduleDescriptor.getId(), updateItem);
                break;
            }
            case description: {
                ERR.info("Not supported yet.");
                break;
            }
            case module_notification: {
                break;
            }
            case notification: {
                this.currentNotificationUrl.push(attributes.getValue("url"));
                break;
            }
            case external_package: {
                ERR.info("Not supported yet.");
                break;
            }
            case license: {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(attributes.getValue("name"), attributes.getValue("url"));
                this.currentLicense.push(hashMap);
                break;
            }
            default: {
                ERR.warning("Unknown element " + string3);
            }
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.parseError(sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.parseError(sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.parseError(sAXParseException);
    }

    private void parseError(SAXParseException sAXParseException) {
        ERR.warning(sAXParseException.getSystemId() + ":" + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber() + ": " + sAXParseException.getLocalizedMessage());
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        return this.entityResolver.resolveEntity(string, string2);
    }

    private static URL getDistribution(String string, URI uRI) {
        URL uRL = null;
        if (string != null && string.length() > 0) {
            try {
                URI uRI2 = new URI(string);
                if (!uRI2.isAbsolute() && uRI != null) {
                    uRI2 = uRI.resolve(uRI2);
                }
                uRL = uRI2.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                ERR.log(Level.INFO, null, malformedURLException);
            }
            catch (URISyntaxException uRISyntaxException) {
                ERR.log(Level.INFO, null, uRISyntaxException);
            }
        }
        return uRL;
    }

    private static Manifest getManifest(org.xml.sax.Attributes attributes) {
        Manifest manifest = new Manifest();
        Attributes attributes2 = manifest.getMainAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            attributes2.put(new Attributes.Name(attributes.getQName(i)), attributes.getValue(i));
        }
        return manifest;
    }

    private static class ModuleDescriptor {
        private String moduleCodeName;
        private URL distributionURL;
        private String targetcluster;
        private String homepage;
        private String downloadSize;
        private String author;
        private String publishDate;
        private String notification;
        private Boolean needsRestart;
        private Boolean isGlobal;
        private Boolean isEager;
        private Boolean isAutoload;
        private String specVersion;
        private Manifest mf;
        private String id;
        private UpdateLicense lic;
        private String group;
        private URI base;
        private String catalogDate;
        private static ModuleDescriptor md = null;

        private ModuleDescriptor() {
        }

        public static ModuleDescriptor getModuleDescriptor(String string, URI uRI, String string2) {
            if (md == null) {
                md = new ModuleDescriptor();
            }
            ModuleDescriptor.md.group = string;
            ModuleDescriptor.md.base = uRI;
            ModuleDescriptor.md.catalogDate = string2;
            return md;
        }

        public void appendModuleAttributes(org.xml.sax.Attributes attributes) {
            this.moduleCodeName = attributes.getValue(AutoupdateCatalogParser.MODULE_ATTR_CODE_NAME_BASE);
            this.distributionURL = AutoupdateCatalogParser.getDistribution(attributes.getValue(AutoupdateCatalogParser.MODULE_ATTR_DISTRIBUTION), this.base);
            this.targetcluster = attributes.getValue(AutoupdateCatalogParser.MODULE_ATTR_TARGET_CLUSTER);
            this.homepage = attributes.getValue(AutoupdateCatalogParser.MODULE_ATTR_HOMEPAGE);
            this.downloadSize = attributes.getValue(AutoupdateCatalogParser.MODULE_ATTR_DOWNLOAD_SIZE);
            this.author = attributes.getValue(AutoupdateCatalogParser.MODULE_ATTR_MODULE_AUTHOR);
            this.publishDate = attributes.getValue(AutoupdateCatalogParser.MODULE_ATTR_RELEASE_DATE);
            if (this.publishDate == null || this.publishDate.length() == 0) {
                this.publishDate = this.catalogDate;
            }
            String string = attributes.getValue(AutoupdateCatalogParser.MODULE_ATTR_NEEDS_RESTART);
            String string2 = attributes.getValue(AutoupdateCatalogParser.MODULE_ATTR_IS_GLOBAL);
            String string3 = attributes.getValue(AutoupdateCatalogParser.MODULE_ATTR_EAGER);
            String string4 = attributes.getValue(AutoupdateCatalogParser.MODULE_ATTR_AUTOLOAD);
            this.needsRestart = string == null || string.trim().length() == 0 ? null : Boolean.valueOf(string);
            this.isGlobal = string2 == null || string2.trim().length() == 0 ? null : Boolean.valueOf(string2);
            this.isEager = Boolean.parseBoolean(string3);
            this.isAutoload = Boolean.parseBoolean(string4);
            String string5 = attributes.getValue(AutoupdateCatalogParser.MODULE_ATTR_LICENSE);
            this.lic = UpdateLicense.createUpdateLicense(string5, null);
        }

        public void appendManifest(org.xml.sax.Attributes attributes) {
            this.specVersion = attributes.getValue(AutoupdateCatalogParser.MANIFEST_ATTR_SPECIFICATION_VERSION);
            this.mf = AutoupdateCatalogParser.getManifest(attributes);
            this.id = this.moduleCodeName + '_' + this.specVersion;
        }

        public void appendNotification(String string) {
            this.notification = string;
        }

        public String getId() {
            return this.id;
        }

        public UpdateItem createUpdateItem() {
            UpdateItem updateItem = UpdateItem.createModule(this.moduleCodeName, this.specVersion, this.distributionURL, this.author, this.downloadSize, this.homepage, this.publishDate, this.group, this.mf, this.isEager, this.isAutoload, this.needsRestart, this.isGlobal, this.targetcluster, this.lic);
            UpdateItemImpl updateItemImpl = Trampoline.SPI.impl(updateItem);
            ((ModuleItem)updateItemImpl).setModuleNotification(this.notification);
            this.cleanUp();
            return updateItem;
        }

        private void cleanUp() {
            this.specVersion = null;
            this.mf = null;
            this.notification = null;
        }
    }

    private static enum ELEMENTS {
        module_updates,
        module_group,
        notification,
        module,
        description,
        module_notification,
        external_package,
        manifest,
        l10n,
        license;

    }
}

