/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.naming;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.FolderName;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;

public final class NamingFactory {
    private static final Map nameMap = new WeakHashMap();

    public static synchronized FileNaming fromFile(File file) {
        LinkedList<File> linkedList = new LinkedList<File>();
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            linkedList.addFirst(file2);
        }
        FileNaming fileNaming = null;
        for (int i = 0; i < linkedList.size(); ++i) {
            File file3 = (File)linkedList.get(i);
            if ("\\\\".equals(file3.getPath())) {
                ++i;
                continue;
            }
            FileType fileType = i == linkedList.size() - 1 ? FileType.unknown : FileType.directory;
            fileNaming = NamingFactory.registerInstanceOfFileNaming(fileNaming, file3, fileType);
        }
        return fileNaming;
    }

    public static synchronized int getSize() {
        return nameMap.size();
    }

    public static synchronized FileNaming fromFile(FileNaming fileNaming, File file, boolean bl) {
        return NamingFactory.registerInstanceOfFileNaming(fileNaming, file, null, bl, FileType.unknown);
    }

    public static synchronized FileNaming checkCaseSensitivity(FileNaming fileNaming, File file) throws IOException {
        if (!fileNaming.getFile().getName().equals(file.getName())) {
            boolean bl;
            boolean bl2 = bl = !new File(file, "a").equals(new File(file, "A"));
            if (!bl) {
                FileName fileName = (FileName)fileNaming;
                fileName.updateCase(file.getName());
            }
        }
        return fileNaming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileNaming[] rename(FileNaming fileNaming, String string, ProvidedExtensions.IOHandler iOHandler) throws IOException {
        ArrayList<FileNaming> arrayList = new ArrayList<FileNaming>();
        FileNaming fileNaming2 = fileNaming.rename(string, iOHandler);
        boolean bl = fileNaming2 != fileNaming;
        Class<NamingFactory> clazz = NamingFactory.class;
        synchronized (NamingFactory.class) {
            arrayList.add(fileNaming2);
            NamingFactory.renameChildren(fileNaming, arrayList);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return bl ? arrayList.toArray(new FileNaming[arrayList.size()]) : null;
        }
    }

    private static void renameChildren(FileNaming fileNaming, List<FileNaming> list) {
        assert (Thread.holdsLock(NamingFactory.class));
        for (Map.Entry entry : nameMap.entrySet()) {
            Object v = entry.getValue();
            List<Object> list2 = v instanceof Reference ? Collections.singletonList((Reference)v) : (v instanceof List ? (List<Object>)v : Collections.emptyList());
            block1: for (int i = 0; i < list2.size(); ++i) {
                FileNaming fileNaming2;
                for (FileNaming fileNaming3 = fileNaming2 = (FileNaming)((Reference)list2.get(i)).get(); fileNaming3 != null; fileNaming3 = fileNaming3.getParent()) {
                    if (!fileNaming.equals(fileNaming3)) continue;
                    list.add(fileNaming2);
                    continue block1;
                }
            }
        }
    }

    public static Integer createID(File file) {
        return new Integer(file.hashCode());
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming fileNaming, File file, FileType fileType) {
        return NamingFactory.registerInstanceOfFileNaming(fileNaming, file, null, false, fileType);
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming fileNaming, File file, FileNaming fileNaming2, boolean bl, FileType fileType) {
        FileNaming fileNaming3;
        FileNaming fileNaming4;
        assert (Thread.holdsLock(NamingFactory.class));
        Object v = nameMap.get(new Integer(file.hashCode()));
        Reference reference = (Reference)(v instanceof Reference ? v : null);
        reference = reference == null && v instanceof List ? NamingFactory.getReference((List)v, file) : reference;
        FileNaming fileNaming5 = fileNaming4 = reference != null ? (FileNaming)reference.get() : null;
        if (bl && fileNaming4 != null && (fileNaming4.isDirectory() != file.isDirectory() || !fileNaming4.getName().equals(file.getName()))) {
            fileNaming4 = null;
        }
        if (fileNaming4 != null && fileNaming4.getFile().compareTo(file) == 0) {
            fileNaming3 = fileNaming4;
        } else {
            fileNaming3 = fileNaming2 == null ? NamingFactory.createFileNaming(file, fileNaming, fileType) : fileNaming2;
            WeakReference<FileNaming> weakReference = new WeakReference<FileNaming>(fileNaming3);
            boolean bl2 = v instanceof List;
            if (fileNaming4 != null || bl2) {
                if (bl2) {
                    ((List)v).add(weakReference);
                } else {
                    ArrayList<WeakReference<FileNaming>> arrayList = new ArrayList<WeakReference<FileNaming>>();
                    arrayList.add(weakReference);
                    nameMap.put(fileNaming3.getId(), arrayList);
                }
            } else {
                Reference reference2 = nameMap.put(fileNaming3.getId(), weakReference);
            }
        }
        assert (fileNaming3 != null);
        return fileNaming3;
    }

    private static Reference getReference(List list, File file) {
        Reference reference = null;
        for (int i = 0; reference == null && i < list.size(); ++i) {
            FileNaming fileNaming;
            Reference reference2 = (Reference)list.get(i);
            FileNaming fileNaming2 = fileNaming = reference2 != null ? (FileNaming)reference2.get() : null;
            if (fileNaming == null || fileNaming.getFile().compareTo(file) != 0) continue;
            reference = reference2;
        }
        return reference;
    }

    private static FileNaming createFileNaming(File file, FileNaming fileNaming, FileType fileType) {
        FileName fileName = null;
        if (fileType.equals((Object)FileType.unknown)) {
            fileType = file.isDirectory() ? FileType.directory : FileType.file;
        }
        switch (fileType) {
            case file: {
                fileName = new FileName(fileNaming, file);
                break;
            }
            case directory: {
                fileName = new FolderName(fileNaming, file);
            }
        }
        return fileName;
    }

    static enum FileType {
        file,
        directory,
        unknown;

    }
}

