/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public final class PositionRef
implements Serializable {
    static final long serialVersionUID = -4931337398907426948L;
    private transient Manager.Kind kind;
    private Manager manager;
    private boolean insertAfter;

    PositionRef(Manager manager, int n, Position.Bias bias) {
        this(manager, new Manager.OffsetKind(n, manager), bias);
    }

    PositionRef(Manager manager, int n, int n2, Position.Bias bias) {
        this(manager, new Manager.LineKind(n, n2, manager), bias);
    }

    private PositionRef(Manager manager, Manager.Kind kind, Position.Bias bias) {
        this.manager = manager;
        this.kind = kind;
        this.insertAfter = bias == Position.Bias.Backward;
        this.init();
    }

    private void init() {
        this.kind = this.manager.addPosition(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.insertAfter);
        objectOutputStream.writeObject(this.manager);
        this.kind.write(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.insertAfter = objectInputStream.readBoolean();
        this.manager = (Manager)objectInputStream.readObject();
        this.kind = this.manager.readKind(objectInputStream);
        this.init();
    }

    public CloneableEditorSupport getCloneableEditorSupport() {
        return this.manager.getCloneableEditorSupport();
    }

    public Position.Bias getPositionBias() {
        return this.insertAfter ? Position.Bias.Backward : Position.Bias.Forward;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position getPosition() throws IOException {
        if (this.manager.getCloneableEditorSupport().getDocument() == null) {
            this.manager.getCloneableEditorSupport().openDocument();
        }
        Object object = this.manager.getLock();
        synchronized (object) {
            Manager.PositionKind positionKind = this.kind.toMemory(this.insertAfter);
            return positionKind.pos;
        }
    }

    public int getOffset() {
        return this.kind.getOffset();
    }

    public int getLine() throws IOException {
        return this.kind.getLine();
    }

    public int getColumn() throws IOException {
        return this.kind.getColumn();
    }

    public String toString() {
        return "Pos[" + this.getOffset() + "]" + ", kind=" + this.kind;
    }

    static final class Manager
    implements Runnable,
    Serializable {
        private static ThreadLocal<Object> DOCUMENT = new ThreadLocal();
        static final long serialVersionUID = -4374030124265110801L;
        private transient ChainItem head;
        private transient ReferenceQueue<PositionRef> queue;
        private transient int counter;
        private transient RequestProcessor.Task sweepTask;
        private transient CloneableEditorSupport support;
        private transient Reference<StyledDocument> doc;

        public Manager(CloneableEditorSupport cloneableEditorSupport) {
            this.support = cloneableEditorSupport;
            this.init();
        }

        protected void init() {
            this.queue = new ReferenceQueue();
            this.head = new ChainItem(null, this.queue, null);
        }

        private Object getLock() {
            return this.support.getLock();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            Object object = objectInputStream.readObject();
            CloneableEditorSupport.Env env = (CloneableEditorSupport.Env)object;
            this.support = (CloneableEditorSupport)env.findCloneableOpenSupport();
            if (this.support == null) {
                throw new IOException();
            }
        }

        final Object readResolve() {
            return this.support.getPositionManager();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.support.cesEnv());
        }

        public CloneableEditorSupport getCloneableEditorSupport() {
            return this.support;
        }

        void documentOpened(Reference<StyledDocument> reference) {
            this.doc = reference;
            this.processPositions(true);
        }

        void documentClosed() {
            this.processPositions(false);
            this.doc = null;
        }

        private StyledDocument getDoc() {
            Object object = DOCUMENT.get();
            if (object instanceof StyledDocument) {
                return (StyledDocument)object;
            }
            if (object == this) {
                return null;
            }
            Reference<StyledDocument> reference = this.doc;
            StyledDocument styledDocument = reference == null ? null : reference.get();
            return styledDocument;
        }

        private void processPositions(boolean bl) {
            while (this.queue.poll() != null) {
            }
            this.counter = 0;
            new DocumentRenderer(this, 9, bl).render();
        }

        private void checkQueue() {
            while (this.queue.poll() != null) {
                ++this.counter;
            }
            if (this.counter > 100) {
                this.counter = 0;
                if (this.sweepTask == null) {
                    this.sweepTask = RequestProcessor.getDefault().post((Runnable)this);
                } else if (this.sweepTask.isFinished()) {
                    this.sweepTask.schedule(0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            Object object = this.getLock();
            synchronized (object) {
                ChainItem chainItem = this.head;
                ChainItem chainItem2 = chainItem.next;
                while (chainItem2 != null) {
                    if (chainItem2.get() == null) {
                        chainItem.next = chainItem2.next;
                    } else {
                        chainItem = chainItem2;
                    }
                    chainItem2 = chainItem2.next;
                }
            }
        }

        Kind addPosition(PositionRef positionRef) {
            Kind kind = (Kind)new DocumentRenderer(this, 10, positionRef).renderToObject();
            this.checkQueue();
            return kind;
        }

        Kind readKind(DataInput dataInput) throws IOException {
            int n = dataInput.readInt();
            int n2 = dataInput.readInt();
            int n3 = dataInput.readInt();
            if (n == -1) {
                return new LineKind(n2, n3, this);
            }
            if (n2 == -1 || n3 == -1) {
                return new OffsetKind(n, this);
            }
            return new OutKind(n, n2, n3, this);
        }

        private static final class DocumentRenderer
        implements Runnable {
            private static final int KIND_TO_MEMORY = 0;
            private static final int POSITION_KIND_GET_LINE = 1;
            private static final int POSITION_KIND_GET_COLUMN = 2;
            private static final int POSITION_KIND_WRITE = 3;
            private static final int OUT_KIND_CONSTRUCTOR = 4;
            private static final int OFFSET_KIND_GET_LINE = 5;
            private static final int OFFSET_KIND_GET_COLUMN = 6;
            private static final int LINE_KIND_GET_OFFSET = 7;
            private static final int LINE_KIND_TO_MEMORY = 8;
            private static final int PROCESS_POSITIONS = 9;
            private static final int ADD_POSITION = 10;
            private final Manager mgr;
            private final int opCode;
            private Kind argKind;
            private boolean argInsertAfter;
            private boolean argToMemory;
            private int argInt;
            private Object retObject;
            private int retInt;
            private int argLine;
            private int argColumn;
            private PositionRef argPos;
            private StyledDocument argDoc;
            private IOException ioException;

            DocumentRenderer(Manager manager, int n, Kind kind) {
                this.mgr = manager;
                this.opCode = n;
                this.argKind = kind;
            }

            DocumentRenderer(Manager manager, int n, Kind kind, boolean bl) {
                this(manager, n, kind);
                this.argInsertAfter = bl;
            }

            DocumentRenderer(Manager manager, int n, Kind kind, int n2) {
                this(manager, n, kind);
                this.argInt = n2;
            }

            DocumentRenderer(Manager manager, int n, Kind kind, int n2, int n3) {
                this(manager, n, kind);
                this.argLine = n2;
                this.argColumn = n3;
            }

            DocumentRenderer(Manager manager, int n, Kind kind, int n2, int n3, StyledDocument styledDocument) {
                this(manager, n, kind, n2, n3);
                this.argDoc = styledDocument;
            }

            DocumentRenderer(Manager manager, int n, Kind kind, int n2, int n3, boolean bl) {
                this(manager, n, kind, n2, n3);
                this.argInsertAfter = bl;
            }

            DocumentRenderer(Manager manager, int n, boolean bl) {
                this.mgr = manager;
                this.opCode = n;
                this.argToMemory = bl;
            }

            DocumentRenderer(Manager manager, int n, PositionRef positionRef) {
                this.mgr = manager;
                this.opCode = n;
                this.argPos = positionRef;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void render() {
                StyledDocument styledDocument = this.mgr.getDoc();
                Object t = DOCUMENT.get();
                try {
                    if (styledDocument != null) {
                        DOCUMENT.set(styledDocument);
                        styledDocument.render(this);
                    } else {
                        DOCUMENT.set(this.mgr);
                        this.run();
                    }
                }
                finally {
                    DOCUMENT.set(t);
                }
            }

            Object renderToObjectIOE() throws IOException {
                Object object = this.renderToObject();
                if (this.ioException != null) {
                    throw this.ioException;
                }
                return object;
            }

            Object renderToObject() {
                this.render();
                return this.retObject;
            }

            int renderToIntIOE() throws IOException {
                int n = this.renderToInt();
                if (this.ioException != null) {
                    throw this.ioException;
                }
                return n;
            }

            int renderToInt() {
                this.render();
                return this.retInt;
            }

            int getLine() {
                return this.argLine;
            }

            int getColumn() {
                return this.argColumn;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    switch (this.opCode) {
                        case 0: {
                            Position position;
                            int n = this.argKind.getOffset();
                            if (this.argKind.getClass() == OutKind.class) {
                                try {
                                    int n2 = this.argKind.getLine();
                                    int n3 = this.argKind.getColumn();
                                    Element element = NbDocument.findLineRootElement(this.mgr.getDoc());
                                    if (n2 < element.getElementCount()) {
                                        Element element2 = element.getElement(n2);
                                        int n4 = element2.getStartOffset();
                                        int n5 = element2.getEndOffset() - n4;
                                        if (n5 >= 1) {
                                            n3 = Math.min(n3, n5 - 1);
                                            n = n4 + n3;
                                        }
                                    }
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            try {
                                position = NbDocument.createPosition(this.mgr.getDoc(), n, this.argInsertAfter ? Position.Bias.Backward : Position.Bias.Forward);
                            }
                            catch (BadLocationException badLocationException) {
                                position = this.mgr.getDoc().getEndPosition();
                            }
                            this.retObject = new PositionKind(position, this.mgr);
                            break;
                        }
                        case 1: {
                            this.retInt = NbDocument.findLineNumber(this.mgr.getDoc(), this.argKind.getOffset());
                            break;
                        }
                        case 2: {
                            this.retInt = NbDocument.findLineColumn(this.mgr.getDoc(), this.argKind.getOffset());
                            break;
                        }
                        case 3: 
                        case 4: {
                            this.retInt = this.argKind.getOffset();
                            this.argLine = this.argKind.getLine();
                            this.argColumn = this.argKind.getColumn();
                            break;
                        }
                        case 5: {
                            this.retInt = NbDocument.findLineNumber(this.mgr.getCloneableEditorSupport().openDocument(), this.argInt);
                            break;
                        }
                        case 6: {
                            this.retInt = NbDocument.findLineColumn(this.mgr.getCloneableEditorSupport().openDocument(), this.argInt);
                            break;
                        }
                        case 7: {
                            this.retInt = NbDocument.findLineOffset(this.argDoc, this.argLine) + this.argColumn;
                            break;
                        }
                        case 8: {
                            try {
                                this.retObject = NbDocument.createPosition(this.mgr.getDoc(), NbDocument.findLineOffset(this.mgr.getDoc(), this.argLine) + this.argColumn, this.argInsertAfter ? Position.Bias.Backward : Position.Bias.Forward);
                            }
                            catch (BadLocationException badLocationException) {
                                this.retObject = this.mgr.getDoc().getEndPosition();
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                this.retObject = this.mgr.getDoc().getEndPosition();
                            }
                            break;
                        }
                        case 9: {
                            Object object = this.mgr.getLock();
                            synchronized (object) {
                                ChainItem chainItem = this.mgr.head;
                                ChainItem chainItem2 = chainItem.next;
                                while (chainItem2 != null) {
                                    PositionRef positionRef = (PositionRef)chainItem2.get();
                                    if (positionRef == null) {
                                        chainItem.next = chainItem2.next;
                                    } else {
                                        if (this.argToMemory) {
                                            positionRef.kind = positionRef.kind.toMemory(positionRef.insertAfter);
                                        } else {
                                            positionRef.kind = positionRef.kind.fromMemory();
                                        }
                                        chainItem = chainItem2;
                                    }
                                    chainItem2 = chainItem2.next;
                                }
                                break;
                            }
                        }
                        case 10: {
                            this.mgr.support.howToReproduceDeadlock40766(true);
                            Object object = this.mgr.getLock();
                            synchronized (object) {
                                this.mgr.support.howToReproduceDeadlock40766(false);
                                ((Manager)this.mgr).head.next = new ChainItem(this.argPos, this.mgr.queue, ((Manager)this.mgr).head.next);
                                this.retObject = this.mgr.getDoc() == null ? this.argPos.kind : this.argPos.kind.toMemory(this.argPos.insertAfter);
                                break;
                            }
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                catch (IOException iOException) {
                    this.ioException = iOException;
                }
            }
        }

        private static final class LineKind
        extends Kind {
            private int line;
            private int column;

            public LineKind(int n, int n2, Manager manager) {
                super(manager);
                if (n < 0 || n2 < 0) {
                    throw new IndexOutOfBoundsException("Illegal LineKind[line=" + n + ",column=" + n2 + "] in " + manager.getDoc() + " used by " + (Object)((Object)manager.support) + ".");
                }
                this.line = n;
                this.column = n2;
            }

            @Override
            public int getOffset() {
                try {
                    StyledDocument styledDocument = this.mgr.getCloneableEditorSupport().getDocument();
                    if (styledDocument == null) {
                        styledDocument = this.mgr.getCloneableEditorSupport().openDocument();
                    }
                    int n = new DocumentRenderer(this.mgr, 7, (Kind)this, this.line, this.column, styledDocument).renderToInt();
                    return n;
                }
                catch (IOException iOException) {
                    return 0;
                }
            }

            @Override
            public int getLine() throws IOException {
                return this.line;
            }

            @Override
            public int getColumn() throws IOException {
                return this.column;
            }

            @Override
            public void write(DataOutput dataOutput) throws IOException {
                if (this.line < 0 || this.column < 0) {
                    throw new IOException("Illegal LineKind[line=" + this.line + ",column=" + this.column + "] in " + this.mgr.getDoc() + " used by " + (Object)((Object)this.mgr.support) + ".");
                }
                dataOutput.writeInt(-1);
                dataOutput.writeInt(this.line);
                dataOutput.writeInt(this.column);
            }

            @Override
            public PositionKind toMemory(boolean bl) {
                Position position = (Position)new DocumentRenderer(this.mgr, 8, (Kind)this, this.line, this.column, bl).renderToObject();
                return new PositionKind(position, this.mgr);
            }
        }

        private static final class OffsetKind
        extends Kind {
            private int offset;

            public OffsetKind(int n, Manager manager) {
                super(manager);
                if (n < 0) {
                    throw new IndexOutOfBoundsException("Illegal OffsetKind[offset=" + n + "] in " + manager.getDoc() + " used by " + (Object)((Object)manager.support) + ".");
                }
                this.offset = n;
            }

            @Override
            public int getOffset() {
                return this.offset;
            }

            @Override
            public int getLine() throws IOException {
                this.mgr.getCloneableEditorSupport().openDocument();
                return new DocumentRenderer(this.mgr, 5, (Kind)this, this.offset).renderToIntIOE();
            }

            @Override
            public int getColumn() throws IOException {
                this.mgr.getCloneableEditorSupport().openDocument();
                return new DocumentRenderer(this.mgr, 6, (Kind)this, this.offset).renderToIntIOE();
            }

            @Override
            public void write(DataOutput dataOutput) throws IOException {
                if (this.offset < 0) {
                    throw new IOException("Illegal OffsetKind[offset=" + this.offset + "] in " + this.mgr.getDoc() + " used by " + (Object)((Object)this.mgr.support) + ".");
                }
                dataOutput.writeInt(this.offset);
                dataOutput.writeInt(-1);
                dataOutput.writeInt(-1);
            }
        }

        private static final class OutKind
        extends Kind {
            private int offset;
            private int line;
            private int column;

            public OutKind(PositionKind positionKind, Manager manager) {
                super(manager);
                DocumentRenderer documentRenderer = new DocumentRenderer(manager, 4, positionKind);
                int n = documentRenderer.renderToInt();
                int n2 = documentRenderer.getLine();
                int n3 = documentRenderer.getColumn();
                if (n < 0 || n2 < 0 || n3 < 0) {
                    throw new IndexOutOfBoundsException("Illegal OutKind[offset=" + n + ",line=" + n2 + ",column=" + n3 + "] in " + manager.getDoc() + " used by " + (Object)((Object)manager.support) + ".");
                }
                this.offset = n;
                this.line = n2;
                this.column = n3;
            }

            OutKind(int n, int n2, int n3, Manager manager) {
                super(manager);
                this.offset = n;
                this.line = n2;
                this.column = n3;
            }

            @Override
            public int getOffset() {
                return this.offset;
            }

            @Override
            public int getLine() {
                return this.line;
            }

            @Override
            public int getColumn() {
                return this.column;
            }

            @Override
            public void write(DataOutput dataOutput) throws IOException {
                if (this.offset < 0 || this.line < 0 || this.column < 0) {
                    throw new IOException("Illegal OutKind[offset=" + this.offset + ",line=" + this.line + ",column=" + this.column + "] in " + this.mgr.getDoc() + " used by " + (Object)((Object)this.mgr.support) + ".");
                }
                dataOutput.writeInt(this.offset);
                dataOutput.writeInt(this.line);
                dataOutput.writeInt(this.column);
            }
        }

        private static final class PositionKind
        extends Kind {
            private Position pos;

            public PositionKind(Position position, Manager manager) {
                super(manager);
                this.pos = position;
            }

            @Override
            public int getOffset() {
                return this.pos.getOffset();
            }

            @Override
            public int getLine() {
                return new DocumentRenderer(this.mgr, 1, this).renderToInt();
            }

            @Override
            public int getColumn() {
                return new DocumentRenderer(this.mgr, 2, this).renderToInt();
            }

            @Override
            public void write(DataOutput dataOutput) throws IOException {
                DocumentRenderer documentRenderer = new DocumentRenderer(this.mgr, 3, this);
                int n = documentRenderer.renderToIntIOE();
                int n2 = documentRenderer.getLine();
                int n3 = documentRenderer.getColumn();
                if (n < 0 || n2 < 0 || n3 < 0) {
                    throw new IOException("Illegal PositionKind: " + this.pos + "[offset=" + n + ",line=" + n2 + ",column=" + n3 + "] in " + this.mgr.getDoc() + " used by " + (Object)((Object)this.mgr.support) + ".");
                }
                dataOutput.writeInt(n);
                dataOutput.writeInt(n2);
                dataOutput.writeInt(n3);
            }

            @Override
            public PositionKind toMemory(boolean bl) {
                return this;
            }

            @Override
            public Kind fromMemory() {
                return new OutKind(this, this.mgr);
            }
        }

        private static abstract class Kind {
            protected final Manager mgr;

            Kind(Manager manager) {
                this.mgr = manager;
            }

            public abstract int getOffset();

            public abstract int getLine() throws IOException;

            public abstract int getColumn() throws IOException;

            public abstract void write(DataOutput var1) throws IOException;

            public PositionKind toMemory(boolean bl) {
                return (PositionKind)new DocumentRenderer(this.mgr, 0, this, bl).renderToObject();
            }

            public Kind fromMemory() {
                return this;
            }
        }

        private static class ChainItem
        extends WeakReference<PositionRef> {
            ChainItem next;

            public ChainItem(PositionRef positionRef, ReferenceQueue<PositionRef> referenceQueue, ChainItem chainItem) {
                super(positionRef, referenceQueue);
                this.next = chainItem;
            }
        }
    }
}

