/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.logging.Level;
import org.netbeans.lib.profiler.results.AbstractDataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;

public class CPUDataFrameProcessor
extends AbstractDataFrameProcessor {
    private volatile int currentThreadId = -1;

    @Override
    public void doProcessDataFrame(byte[] byArray) {
        boolean bl;
        int n = 0;
        boolean bl2 = bl = this.client != null ? this.client.getStatus().collectingTwoTimeStamps() : false;
        block28: while (n < byArray.length) {
            int n2;
            byte by;
            if (((by = byArray[n++]) & 0xFFFFFF80) != 0) {
                n2 = (by & 0xFF) << 8 | byArray[n++] & 0xFF;
                if ((byte)(by & 0xFFFFFFC0) == -64) {
                    this.fireMethodExitUnstamped(n2 & 0x3FFF, this.currentThreadId, 1);
                    continue;
                }
                this.fireMethodEntryUnstamped(n2 & 0x3FFF, this.currentThreadId, 1);
                continue;
            }
            if (by != 26 && by != 27 && by != 13 && by != 11 && by != 10) {
                n2 = -1;
                long l = 0L;
                long l2 = 0L;
                if (by != 5 && by != 20 && by != 21 && by != 22 && by != 23 && by != 24 && by != 25) {
                    n2 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                }
                if (by != 16 && by != 17 && by != 18 && by != 19) {
                    l = ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
                    if (by != 20 && by != 21 && by != 22 && by != 23 && by != 24 && by != 25 && bl) {
                        l2 = ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
                    }
                }
                switch (by) {
                    case 18: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Marker entry unstamped, tId=" + this.currentThreadId + ", mId=" + n2);
                        }
                        this.fireMethodEntryUnstamped(n2, this.currentThreadId, 3);
                        break;
                    }
                    case 16: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Method entry unstamped, tId=" + this.currentThreadId + ", mId=" + n2);
                        }
                        this.fireMethodEntryUnstamped(n2, this.currentThreadId, 1);
                        break;
                    }
                    case 19: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Marker exit unstamped, tId=" + this.currentThreadId + ", mId=" + n2);
                        }
                        this.fireMethodExitUnstamped(n2, this.currentThreadId, 3);
                        break;
                    }
                    case 17: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Method exit unstamped, tId=" + this.currentThreadId + ", mId=" + n2);
                        }
                        this.fireMethodExitUnstamped(n2, this.currentThreadId, 1);
                        break;
                    }
                    case 3: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Marker entry , tId=" + this.currentThreadId + ", mId=" + n2);
                        }
                        this.fireMethodEntry(n2, this.currentThreadId, 3, l, l2);
                        break;
                    }
                    case 1: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Root entry , tId=" + this.currentThreadId + ", mId=" + n2);
                        }
                        this.fireMethodEntry(n2, this.currentThreadId, 2, l, l2);
                        break;
                    }
                    case 6: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Method entry , tId=" + this.currentThreadId + ", mId=" + n2);
                        }
                        this.fireMethodEntry(n2, this.currentThreadId, 1, l, l2);
                        break;
                    }
                    case 4: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Marker exit , tId=" + this.currentThreadId + ", mId=" + n2);
                        }
                        this.fireMethodExit(n2, this.currentThreadId, 3, l, l2);
                        break;
                    }
                    case 2: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Root exit , tId=" + this.currentThreadId + ", mId=" + n2);
                        }
                        this.fireMethodExit(n2, this.currentThreadId, 2, l, l2);
                        break;
                    }
                    case 7: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Method exit , tId=" + this.currentThreadId + ", mId=" + n2);
                        }
                        this.fireMethodExit(n2, this.currentThreadId, 1, l, l2);
                        break;
                    }
                    case 5: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Adjust time , tId=" + this.currentThreadId);
                        }
                        this.fireAdjustTime(this.currentThreadId, l, l2);
                        break;
                    }
                    case 22: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Monitor entry , tId=" + this.currentThreadId);
                        }
                        this.fireMonitorEntry(this.currentThreadId, l, l2);
                        break;
                    }
                    case 23: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Monitor exit , tId=" + this.currentThreadId);
                        }
                        this.fireMonitorExit(this.currentThreadId, l, l2);
                        break;
                    }
                    case 24: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Sleep entry , tId=" + this.currentThreadId);
                        }
                        this.fireSleepEntry(this.currentThreadId, l, l2);
                        break;
                    }
                    case 25: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Sleep exit , tId=" + this.currentThreadId);
                        }
                        this.fireSleepExit(this.currentThreadId, l, l2);
                        break;
                    }
                    case 20: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Wait entry , tId=" + this.currentThreadId);
                        }
                        this.fireWaitEntry(this.currentThreadId, l, l2);
                        break;
                    }
                    case 21: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Wait exit , tId=" + this.currentThreadId);
                        }
                        this.fireWaitExit(this.currentThreadId, l, l2);
                        break;
                    }
                    case 8: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Threads suspend");
                        }
                        this.fireThreadsSuspend(l, l2);
                        break;
                    }
                    case 9: {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Threads resume");
                        }
                        this.fireThreadsResumed(l, l2);
                        break;
                    }
                    default: {
                        LOGGER.severe("*** Profiler Engine: internal error: got unknown event type in CPUDataFrameProcessor: " + by + " at " + n);
                        break;
                    }
                }
                continue;
            }
            switch (by) {
                case 26: {
                    n2 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    long l = ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
                    int n3 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    this.fireProfilingPoint(n3, n2, l);
                    continue block28;
                }
                case 13: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Change current thread , tId=" + this.currentThreadId);
                    }
                    this.currentThreadId = (char)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                    continue block28;
                }
                case 11: {
                    n2 = (char)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                    int n4 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    String string = new String(byArray, n, n4);
                    n += n4;
                    n4 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    String string2 = new String(byArray, n, n4);
                    n += n4;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Creating new thread , tId=" + n2);
                    }
                    this.fireNewThread(n2, string, string2);
                    this.currentThreadId = n2;
                    continue block28;
                }
                case 27: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Servlet track start , tId=" + this.currentThreadId);
                    }
                    n2 = byArray[n++];
                    int n5 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    String string = new String(byArray, n, n5);
                    n += n5;
                    int n6 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    this.fireServletRequest(this.currentThreadId, n2, string, n6);
                    continue block28;
                }
                case 10: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profiling data reset");
                    }
                    this.fireReset();
                    continue block28;
                }
            }
            LOGGER.severe("*** Profiler Engine: internal error: got unknown event type in CallGraphBuilder: " + by + " at " + n);
        }
    }

    private void fireAdjustTime(final int n, final long l, final long l2) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).timeAdjust(n, l, l2);
            }
        });
    }

    private void fireMethodEntry(final int n, final int n2, final int n3, final long l, final long l2) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).methodEntry(n, n2, n3, l, l2);
            }
        });
    }

    private void fireMethodEntryUnstamped(final int n, final int n2, final int n3) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).methodEntryUnstamped(n, n2, n3);
            }
        });
    }

    private void fireMethodExit(final int n, final int n2, final int n3, final long l, final long l2) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).methodExit(n, n2, n3, l, l2);
            }
        });
    }

    private void fireMethodExitUnstamped(final int n, final int n2, final int n3) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).methodExitUnstamped(n, n2, n3);
            }
        });
    }

    private void fireMonitorEntry(final int n, final long l, final long l2) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).monitorEntry(n, l, l2);
            }
        });
    }

    private void fireMonitorExit(final int n, final long l, final long l2) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).monitorExit(n, l, l2);
            }
        });
    }

    private void fireNewThread(final int n, final String string, final String string2) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).newThread(n, string, string2);
            }
        });
    }

    private void fireServletRequest(final int n, final int n2, final String string, final int n3) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).servletRequest(n, n2, string, n3);
            }
        });
    }

    private void fireSleepEntry(final int n, final long l, final long l2) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).sleepEntry(n, l, l2);
            }
        });
    }

    private void fireSleepExit(final int n, final long l, final long l2) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).sleepExit(n, l, l2);
            }
        });
    }

    private void fireThreadsResumed(final long l, final long l2) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).threadsSuspend(l, l2);
            }
        });
    }

    private void fireThreadsSuspend(final long l, final long l2) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).threadsSuspend(l, l2);
            }
        });
    }

    private void fireWaitEntry(final int n, final long l, final long l2) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).waitEntry(n, l, l2);
            }
        });
    }

    private void fireWaitExit(final int n, final long l, final long l2) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((CPUProfilingResultListener)profilingResultListener).waitExit(n, l, l2);
            }
        });
    }
}

