/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;

class HprofInstanceValue
extends HprofObject
implements FieldValue {
    HprofField field;
    InstanceDump instance;

    HprofInstanceValue(InstanceDump instanceDump, HprofField hprofField, long l) {
        super(l);
        this.instance = instanceDump;
        this.field = hprofField;
    }

    @Override
    public Instance getDefiningInstance() {
        return this.instance;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getValue() {
        return this.getTypeValue().toString();
    }

    Object getTypeValue() {
        byte by = this.field.getVauleType();
        HprofByteBuffer hprofByteBuffer = this.instance.dumpClass.getHprofBuffer();
        return HprofInstanceValue.getTypeValue(hprofByteBuffer, this.fileOffset, by);
    }

    static Object getTypeValue(HprofByteBuffer hprofByteBuffer, long l, byte by) {
        switch (by) {
            case 2: {
                long l2 = hprofByteBuffer.getID(l);
                return new Long(l2);
            }
            case 4: {
                byte by2 = hprofByteBuffer.get(l);
                return by2 != 0;
            }
            case 5: {
                char c = hprofByteBuffer.getChar(l);
                return Character.valueOf(c);
            }
            case 6: {
                float f = hprofByteBuffer.getFloat(l);
                return new Float(f);
            }
            case 7: {
                double d = hprofByteBuffer.getDouble(l);
                return new Double(d);
            }
            case 8: {
                byte by3 = hprofByteBuffer.get(l);
                return new Byte(by3);
            }
            case 9: {
                short s = hprofByteBuffer.getShort(l);
                return new Short(s);
            }
            case 10: {
                int n = hprofByteBuffer.getInt(l);
                return new Integer(n);
            }
            case 11: {
                long l3 = hprofByteBuffer.getLong(l);
                return new Long(l3);
            }
        }
        return "Invalid type " + by;
    }
}

