/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.TagBounds;

class ClassDumpSegment
extends TagBounds {
    HprofHeap hprofHeap;
    Map arrayMap;
    final int classIDOffset;
    final int classLoaderIDOffset;
    final int constantPoolSizeOffset;
    final int fieldNameIDOffset;
    final int fieldSize;
    final int fieldTypeOffset;
    final int fieldValueOffset;
    final int instanceSizeOffset;
    final int minimumInstanceSize;
    final int protectionDomainIDOffset;
    final int reserved1;
    final int reserver2;
    final int signersID;
    final int stackTraceSerialNumberOffset;
    final int superClassIDOffset;
    ClassDump java_lang_Class;
    Map fieldsCache;
    private List classes;
    private Map primitiveArrayMap;

    ClassDumpSegment(HprofHeap hprofHeap, long l, long l2) {
        super(32, l, l2);
        int n = hprofHeap.dumpBuffer.getIDSize();
        this.hprofHeap = hprofHeap;
        this.classIDOffset = 1;
        this.stackTraceSerialNumberOffset = this.classIDOffset + n;
        this.superClassIDOffset = this.stackTraceSerialNumberOffset + 4;
        this.classLoaderIDOffset = this.superClassIDOffset + n;
        this.signersID = this.classLoaderIDOffset + n;
        this.protectionDomainIDOffset = this.signersID + n;
        this.reserved1 = this.protectionDomainIDOffset + n;
        this.reserver2 = this.reserved1 + n;
        this.instanceSizeOffset = this.reserver2 + n;
        this.constantPoolSizeOffset = this.instanceSizeOffset + 4;
        this.fieldNameIDOffset = 0;
        this.fieldTypeOffset = this.fieldNameIDOffset + n;
        this.fieldValueOffset = this.fieldTypeOffset + 1;
        this.fieldSize = this.fieldTypeOffset + 1;
        this.minimumInstanceSize = 2 * n;
        this.fieldsCache = Collections.synchronizedMap(new FieldsCache());
    }

    ClassDump getClassDumpByID(long l) {
        if (l == 0L) {
            return null;
        }
        LongMap.Entry entry = this.hprofHeap.idToOffsetMap.get(l);
        if (entry != null) {
            try {
                return (ClassDump)this.createClassCollection().get(entry.getIndex() - 1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
        return null;
    }

    JavaClass getJavaClassByName(String string) {
        for (ClassDump classDump : this.createClassCollection()) {
            if (!string.equals(classDump.getName())) continue;
            return classDump;
        }
        return null;
    }

    Collection getJavaClassesByRegExp(String string) {
        Iterator iterator = this.createClassCollection().iterator();
        ArrayList<ClassDump> arrayList = new ArrayList<ClassDump>(256);
        Pattern pattern = Pattern.compile(string);
        while (iterator.hasNext()) {
            ClassDump classDump = (ClassDump)iterator.next();
            if (!pattern.matcher(classDump.getName()).matches()) continue;
            arrayList.add(classDump);
        }
        return arrayList;
    }

    int getMinimumInstanceSize() {
        return this.minimumInstanceSize;
    }

    ClassDump getPrimitiveArrayClass(byte by) {
        ClassDump classDump = (ClassDump)this.primitiveArrayMap.get(by);
        if (classDump == null) {
            throw new IllegalArgumentException("Invalid type " + by);
        }
        return classDump;
    }

    Map getClassIdToClassMap() {
        List list = this.createClassCollection();
        HashMap<Long, ClassDump> hashMap = new HashMap<Long, ClassDump>(list.size() * 4 / 3);
        for (ClassDump classDump : list) {
            hashMap.put(new Long(classDump.getJavaClassId()), classDump);
        }
        return hashMap;
    }

    void addInstanceSize(ClassDump classDump, int n, long l) {
        if (n == 34 || n == 35) {
            Long l2 = (Long)this.arrayMap.get(classDump);
            long l3 = 0L;
            HprofByteBuffer hprofByteBuffer = this.hprofHeap.dumpBuffer;
            int n2 = hprofByteBuffer.getIDSize();
            long l4 = l + 1L + (long)n2 + 4L;
            if (l2 != null) {
                l3 = l2.intValue();
            }
            int n3 = hprofByteBuffer.getInt(l4);
            int n4 = n == 35 ? this.hprofHeap.getValueSize(hprofByteBuffer.get(l4 + 4L)) : n2;
            this.arrayMap.put(classDump, l3 += (long)this.getMinimumInstanceSize() + (long)n3 * (long)n4);
        }
    }

    synchronized List createClassCollection() {
        if (this.classes != null) {
            return this.classes;
        }
        this.classes = new ArrayList(1000);
        long[] lArray = new long[]{this.startOffset};
        while (lArray[0] < this.endOffset) {
            long l = lArray[0];
            int n = this.hprofHeap.readDumpTag(lArray);
            if (n != 32) continue;
            ClassDump classDump = new ClassDump(this, l);
            long l2 = classDump.getJavaClassId();
            LongMap.Entry entry = this.hprofHeap.idToOffsetMap.put(l2, l);
            this.classes.add(classDump);
            entry.setIndex(this.classes.size());
        }
        this.hprofHeap.getLoadClassSegment().setLoadClassOffsets();
        this.arrayMap = new HashMap(this.classes.size() / 15);
        this.extractSpecialClasses();
        return this.classes;
    }

    private void extractSpecialClasses() {
        this.primitiveArrayMap = new HashMap();
        for (ClassDump classDump : this.classes) {
            String string = classDump.getLoadClass().getVMName();
            Integer n = null;
            if (string.equals("[Z")) {
                n = 4;
            } else if (string.equals("[C")) {
                n = 5;
            } else if (string.equals("[F")) {
                n = 6;
            } else if (string.equals("[D")) {
                n = 7;
            } else if (string.equals("[B")) {
                n = 8;
            } else if (string.equals("[S")) {
                n = 9;
            } else if (string.equals("[I")) {
                n = 10;
            } else if (string.equals("[J")) {
                n = 11;
            } else if (string.equals("java/lang/Class")) {
                this.java_lang_Class = classDump;
            } else if (string.equals("boolean[]")) {
                n = 4;
            } else if (string.equals("char[]")) {
                n = 5;
            } else if (string.equals("float[]")) {
                n = 6;
            } else if (string.equals("double[]")) {
                n = 7;
            } else if (string.equals("byte[]")) {
                n = 8;
            } else if (string.equals("short[]")) {
                n = 9;
            } else if (string.equals("int[]")) {
                n = 10;
            } else if (string.equals("long[]")) {
                n = 11;
            } else if (string.equals("java.lang.Class")) {
                this.java_lang_Class = classDump;
            }
            if (n == null) continue;
            this.primitiveArrayMap.put(n, classDump);
        }
    }

    private static class FieldsCache
    extends LinkedHashMap {
        private static final int SIZE = 500;

        FieldsCache() {
            super(500, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 500;
        }
    }
}

