/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.lib.profiler.utils.StringUtils;

public final class ProfilerEngineSettings
implements CommonConstants,
Cloneable {
    private InstrumentationFilter instrumentationFilter = InstrumentationFilter.getDefault();
    private Marker methodMarker = Marker.DEFAULT;
    private String jFluidRootDirName;
    private String jvmArgs;
    private String mainArgs;
    private String mainClassName;
    private String mainClassPath = "";
    private String remoteHost = "";
    private String targetJDKVersion = "jdk15";
    private String targetJVMExeFile;
    private String targetJVMStartupDirName;
    private String workingDir = System.getProperty("user.dir");
    private ClientUtils.SourceCodeSelection[] instrumentationRootMethods = new ClientUtils.SourceCodeSelection[0];
    private RuntimeProfilingPoint[] profilingPoints = new RuntimeProfilingPoint[0];
    private String[] vmClassPaths = new String[3];
    private boolean absoluteTimerOn = true;
    private boolean dontShowZeroLiveObjAllocPaths = true;
    private boolean excludeWaitTime = true;
    private boolean instrumentEmptyMethods = false;
    private boolean instrumentGetterSetterMethods = false;
    private boolean instrumentMethodInvoke = true;
    private boolean instrumentSpawnedThreads = false;
    private boolean runGCOnGetResultsInMemoryProfiling = false;
    private boolean separateConsole = true;
    private boolean sortResultsByThreadCPUTime = false;
    private boolean suspendTargetApp = false;
    private boolean targetWindowRemains = false;
    private boolean threadCPUTimerOn = false;
    private int allocStackTraceLimit = -5;
    private int allocTrackEvery = 10;
    private int architecture;
    private int codeRegionCPUResBufSize = 1000;
    private int cpuProfilingType = 0;
    private int instrScheme = 1;
    private int nProfiledThreadsLimit = 32;
    private int portNo = 5140;
    private int samplingInterval = 10;

    public void setAbsoluteTimerOn(boolean bl) {
        this.absoluteTimerOn = bl;
    }

    public boolean getAbsoluteTimerOn() {
        return this.absoluteTimerOn;
    }

    public void setAllocStackTraceLimit(int n) {
        this.allocStackTraceLimit = n;
    }

    public int getAllocStackTraceLimit() {
        return this.allocStackTraceLimit;
    }

    public void setAllocTrackEvery(int n) {
        if (n < 1) {
            n = 1;
        }
        this.allocTrackEvery = n;
    }

    public int getAllocTrackEvery() {
        return this.allocTrackEvery;
    }

    public void setCPUProfilingType(int n) {
        this.cpuProfilingType = n;
    }

    public int getCPUProfilingType() {
        return this.cpuProfilingType;
    }

    public void setCodeRegionCPUResBufSize(int n) {
        this.codeRegionCPUResBufSize = n;
    }

    public int getCodeRegionCPUResBufSize() {
        return this.codeRegionCPUResBufSize;
    }

    public void setDontShowZeroLiveObjAllocPaths(boolean bl) {
        this.dontShowZeroLiveObjAllocPaths = bl;
    }

    public boolean getDontShowZeroLiveObjAllocPaths() {
        return this.dontShowZeroLiveObjAllocPaths;
    }

    public void setExcludeWaitTime(boolean bl) {
        this.excludeWaitTime = bl;
    }

    public boolean getExcludeWaitTime() {
        return this.excludeWaitTime;
    }

    public void setInstrScheme(int n) {
        this.instrScheme = n;
    }

    public int getInstrScheme() {
        return this.instrScheme;
    }

    public void setInstrumentEmptyMethods(boolean bl) {
        this.instrumentEmptyMethods = bl;
    }

    public boolean getInstrumentEmptyMethods() {
        return this.instrumentEmptyMethods;
    }

    public void setInstrumentGetterSetterMethods(boolean bl) {
        this.instrumentGetterSetterMethods = bl;
    }

    public boolean getInstrumentGetterSetterMethods() {
        return this.instrumentGetterSetterMethods;
    }

    public void setInstrumentMethodInvoke(boolean bl) {
        this.instrumentMethodInvoke = bl;
    }

    public boolean getInstrumentMethodInvoke() {
        return this.instrumentMethodInvoke;
    }

    public void setInstrumentSpawnedThreads(boolean bl) {
        this.instrumentSpawnedThreads = bl;
    }

    public boolean getInstrumentSpawnedThreads() {
        return this.instrumentSpawnedThreads;
    }

    public void setInstrumentationFilter(InstrumentationFilter instrumentationFilter) {
        this.instrumentationFilter = instrumentationFilter;
    }

    public InstrumentationFilter getInstrumentationFilter() {
        return this.instrumentationFilter;
    }

    public void setInstrumentationRootMethods(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        this.instrumentationRootMethods = sourceCodeSelectionArray;
    }

    public ClientUtils.SourceCodeSelection[] getInstrumentationRootMethods() {
        return this.instrumentationRootMethods;
    }

    public String getJFluidRootDirName() {
        return this.jFluidRootDirName;
    }

    public void setJVMArgs(String string) {
        this.jvmArgs = string;
    }

    public String[] getJVMArgs() {
        return StringUtils.parseArgsString(this.jvmArgs);
    }

    public String getJVMArgsAsSingleString() {
        return this.jvmArgs;
    }

    public void setMainArgs(String string) {
        this.mainArgs = string;
    }

    public String[] getMainArgs() {
        return StringUtils.parseArgsString(this.mainArgs);
    }

    public String getMainArgsAsSingleString() {
        return this.mainArgs;
    }

    public void setMainClass(String string) {
        this.mainClassName = string;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public void setMainClassPath(String string) {
        this.mainClassPath = string;
    }

    public String getMainClassPath() {
        return this.mainClassPath;
    }

    public void setMethodMarker(Marker marker) {
        this.methodMarker = marker;
    }

    public Marker getMethodMarker() {
        return this.methodMarker;
    }

    public void setNProfiledThreadsLimit(int n) {
        this.nProfiledThreadsLimit = n;
    }

    public int getNProfiledThreadsLimit() {
        return this.nProfiledThreadsLimit;
    }

    public void setPortNo(int n) {
        this.portNo = n;
    }

    public int getPortNo() {
        return this.portNo;
    }

    public void setRemoteHost(String string) {
        this.remoteHost = string;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRunGCOnGetResultsInMemoryProfiling(boolean bl) {
        this.runGCOnGetResultsInMemoryProfiling = bl;
    }

    public boolean getRunGCOnGetResultsInMemoryProfiling() {
        return this.runGCOnGetResultsInMemoryProfiling;
    }

    public void setRuntimeProfilingPoints(RuntimeProfilingPoint[] runtimeProfilingPointArray) {
        this.profilingPoints = runtimeProfilingPointArray;
    }

    public RuntimeProfilingPoint[] getRuntimeProfilingPoints() {
        return this.profilingPoints;
    }

    public void setSamplingInterval(int n) {
        this.samplingInterval = n;
    }

    public int getSamplingInterval() {
        return this.samplingInterval;
    }

    public void setSeparateConsole(boolean bl) {
        this.separateConsole = bl;
    }

    public boolean getSeparateConsole() {
        return this.separateConsole;
    }

    public void setSortResultsByThreadCPUTime(boolean bl) {
        this.sortResultsByThreadCPUTime = bl;
    }

    public boolean getSortResultsByThreadCPUTime() {
        return this.sortResultsByThreadCPUTime;
    }

    public void setSuspendTargetApp(boolean bl) {
        this.suspendTargetApp = bl;
    }

    public boolean getSuspendTargetApp() {
        return this.suspendTargetApp;
    }

    public void setSystemArchitecture(int n) {
        this.architecture = n;
    }

    public int getSystemArchitecture() {
        return this.architecture;
    }

    public void setTargetJDKVersionString(String string) {
        this.targetJDKVersion = string;
    }

    public String getTargetJDKVersionString() {
        return this.targetJDKVersion;
    }

    public void setTargetJVMExeFile(String string) {
        this.targetJVMExeFile = string;
    }

    public String getTargetJVMExeFile() {
        return this.targetJVMExeFile;
    }

    public void setTargetJVMStartupDirName(String string) {
        this.targetJVMStartupDirName = string;
    }

    public String getTargetJVMStartupDirName() {
        return this.targetJVMStartupDirName;
    }

    public void setTargetWindowRemains(boolean bl) {
        this.targetWindowRemains = bl;
    }

    public boolean getTargetWindowRemains() {
        return this.targetWindowRemains;
    }

    public void setThreadCPUTimerOn(boolean bl) {
        this.threadCPUTimerOn = bl;
    }

    public boolean getThreadCPUTimerOn() {
        return this.threadCPUTimerOn;
    }

    public void setVMClassPaths(String string, String string2, String string3) {
        this.vmClassPaths[0] = MiscUtils.getLiveClassPathSubset(string, this.getWorkingDir());
        this.vmClassPaths[1] = string2;
        this.vmClassPaths[2] = string3;
        try {
            this.setMainClassPath(this.vmClassPaths[0]);
        }
        catch (Exception exception) {
            throw new InternalError("Should not happen");
        }
    }

    public String[] getVMClassPaths() {
        this.vmClassPaths[0] = this.getMainClassPath();
        return this.vmClassPaths;
    }

    public void setWorkingDir(String string) {
        this.workingDir = string;
        if (this.workingDir == null || "".equals(this.workingDir)) {
            this.workingDir = System.getProperty("user.dir");
        }
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public Object clone() {
        ProfilerEngineSettings profilerEngineSettings = null;
        try {
            profilerEngineSettings = (ProfilerEngineSettings)super.clone();
            profilerEngineSettings.instrumentationRootMethods = new ClientUtils.SourceCodeSelection[this.instrumentationRootMethods.length];
            for (int i = 0; i < this.instrumentationRootMethods.length; ++i) {
                profilerEngineSettings.instrumentationRootMethods[i] = (ClientUtils.SourceCodeSelection)this.instrumentationRootMethods[i].clone();
            }
            profilerEngineSettings.instrumentationFilter = (InstrumentationFilter)this.instrumentationFilter.clone();
            return profilerEngineSettings;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Should never happen: ProfilerEngineSettings.clone");
        }
    }

    public void initialize(String string) throws RuntimeException, IOException {
        String string2 = Platform.getAgentNativeLibFullName(string, false, null, -1);
        String string3 = string2.substring(0, string2.lastIndexOf(47));
        String string4 = "";
        try {
            string4 = string;
            File file = MiscUtils.checkDirForName(string4);
            string4 = string3;
            MiscUtils.checkDirForName(string4);
            string4 = string2;
            MiscUtils.checkFile(new File(string4), false);
            this.jFluidRootDirName = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new IOException("Problem with a required JFluid installation directory or file " + string4, iOException);
        }
    }
}

