/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.queries;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation;
import org.netbeans.spi.queries.VisibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class VisibilityQuery {
    private static final VisibilityQuery INSTANCE = new VisibilityQuery();
    private final ResultListener resultListener = new ResultListener();
    private final VqiChangedListener vqiListener = new VqiChangedListener();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Lookup.Result<VisibilityQueryImplementation> vqiResult = null;
    private List<VisibilityQueryImplementation> cachedVqiInstances = null;

    public static final VisibilityQuery getDefault() {
        return INSTANCE;
    }

    private VisibilityQuery() {
    }

    public boolean isVisible(FileObject fileObject) {
        for (VisibilityQueryImplementation visibilityQueryImplementation : this.getVqiInstances()) {
            if (visibilityQueryImplementation.isVisible(fileObject)) continue;
            return false;
        }
        return true;
    }

    public boolean isVisible(File file) {
        for (VisibilityQueryImplementation visibilityQueryImplementation : this.getVqiInstances()) {
            FileObject fileObject;
            if (!(visibilityQueryImplementation instanceof VisibilityQueryImplementation2 ? !((VisibilityQueryImplementation2)visibilityQueryImplementation).isVisible(file) : (fileObject = FileUtil.toFileObject((File)file)) != null && !visibilityQueryImplementation.isVisible(fileObject))) continue;
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private synchronized List<VisibilityQueryImplementation> getVqiInstances() {
        if (this.cachedVqiInstances == null) {
            this.vqiResult = Lookup.getDefault().lookupResult(VisibilityQueryImplementation.class);
            this.vqiResult.addLookupListener((LookupListener)this.resultListener);
            this.setupChangeListeners(null, new ArrayList<VisibilityQueryImplementation>(this.vqiResult.allInstances()));
        }
        return this.cachedVqiInstances;
    }

    private synchronized void setupChangeListeners(List<VisibilityQueryImplementation> list, List<VisibilityQueryImplementation> list2) {
        HashSet<VisibilityQueryImplementation> hashSet;
        if (list != null) {
            hashSet = new HashSet<VisibilityQueryImplementation>(list);
            hashSet.removeAll(list2);
            for (VisibilityQueryImplementation visibilityQueryImplementation : hashSet) {
                visibilityQueryImplementation.removeChangeListener(this.vqiListener);
            }
        }
        hashSet = new HashSet<VisibilityQueryImplementation>(list2);
        if (list != null) {
            hashSet.removeAll(list);
        }
        for (VisibilityQueryImplementation visibilityQueryImplementation : hashSet) {
            visibilityQueryImplementation.addChangeListener(this.vqiListener);
        }
        this.cachedVqiInstances = list2;
    }

    private class VqiChangedListener
    implements ChangeListener {
        private VqiChangedListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            VisibilityQuery.this.changeSupport.fireChange();
        }
    }

    private class ResultListener
    implements LookupListener {
        private ResultListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            VisibilityQuery.this.setupChangeListeners(VisibilityQuery.this.cachedVqiInstances, new ArrayList(VisibilityQuery.this.vqiResult.allInstances()));
            VisibilityQuery.this.changeSupport.fireChange();
        }
    }
}

