/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.netbeans.core.startup.AutomaticDependencies;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ManifestSection;
import org.netbeans.core.startup.ModuleList;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInstall;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.SharedClassObject;
import org.openide.util.lookup.InstanceContent;
import org.xml.sax.SAXException;

final class NbInstaller
extends ModuleInstaller {
    private static final Logger LOG = Logger.getLogger(NbInstaller.class.getName());
    private final Map<Module, Set<ManifestSection>> sections = new HashMap<Module, Set<ManifestSection>>(100);
    private final Map<Module, Class<? extends ModuleInstall>> installs = new HashMap<Module, Class<? extends ModuleInstall>>(100);
    private final Map<Module, String> layers = new HashMap<Module, String>(100);
    private boolean initializedFolderLookup = false;
    private final Events ev;
    private ModuleList moduleList;
    private ModuleManager mgr;
    private final Map<Module, Set<String>> kosherPackages = new HashMap<Module, Set<String>>(100);
    private final Map<Module, List<Module.PackageExport>> hiddenClasspathPackages = new HashMap<Module, List<Module.PackageExport>>();
    private final Map<Module.PackageExport, List<Module>> hiddenClasspathPackagesReverse = new HashMap<Module.PackageExport, List<Module>>();
    private final InstanceContent.Convertor<ManifestSection, Object> convertor = new Convertor();
    private static String cacheCnb;
    private static Set<Dependency> cacheDeps;
    private AutomaticDependencies autoDepsHandler = null;
    private static final String[] CLASSPATH_PACKAGES;
    private static final String[][] CLASSPATH_JARS;
    private static final Logger MANIFEST_LOG;
    private boolean usingManifestCache;
    private final Object MANIFEST_CACHE = new Object();
    private Map<File, DateAndManifest> manifestCache;
    CacheFlusher updater;

    public NbInstaller(Events events) {
        this.usingManifestCache = Boolean.valueOf(System.getProperty("netbeans.cache.manifests", "true"));
        if (!this.usingManifestCache) {
            MANIFEST_LOG.fine("Manifest cache disabled");
        }
        this.updater = new CacheFlusher();
        this.ev = events;
    }

    void registerList(ModuleList moduleList) {
        if (this.moduleList != null) {
            throw new IllegalStateException();
        }
        this.moduleList = moduleList;
    }

    void registerManager(ModuleManager moduleManager) {
        if (this.mgr != null) {
            throw new IllegalStateException();
        }
        this.mgr = moduleManager;
    }

    public void prepare(Module module) throws InvalidException {
        Object object;
        Object object2;
        Map.Entry<String, Attributes> entry2;
        this.ev.log("prepare", new Object[]{module});
        this.checkForHiddenPackages(module);
        HashSet<ManifestSection> hashSet = null;
        Class<?> clazz = null;
        for (Map.Entry<String, Attributes> entry2 : module.getManifest().getEntries().entrySet()) {
            object2 = ManifestSection.create(entry2.getKey(), entry2.getValue(), module);
            if (object2 == null) continue;
            if (hashSet == null) {
                hashSet = new HashSet<ManifestSection>(25);
            }
            hashSet.add((ManifestSection)object2);
        }
        String string = module.getManifest().getMainAttributes().getValue("OpenIDE-Module-Install");
        if (string != null) {
            try {
                entry2 = Util.createPackageName((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                InvalidException invalidException = new InvalidException(module, illegalArgumentException.toString());
                invalidException.initCause((Throwable)illegalArgumentException);
                throw invalidException;
            }
            if (string.endsWith(".ser")) {
                throw new InvalidException(module, "Serialized module installs not supported: " + (String)string);
            }
            try {
                clazz = Class.forName((String)((Object)entry2), false, module.getClassLoader());
                if (clazz.getClassLoader() != module.getClassLoader()) {
                    this.ev.log("wrongClassLoader", new Object[]{module, clazz, module.getClassLoader()});
                }
                for (object2 = clazz; object2 != ModuleInstall.class && object2 != Object.class; object2 = ((Class)object2).getSuperclass()) {
                    try {
                        ((Class)object2).getDeclaredMethod("validate", new Class[0]);
                        object = (ModuleInstall)SharedClassObject.findObject(clazz.asSubclass(ModuleInstall.class), (boolean)true);
                        object.validate();
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (object2 == Object.class) {
                    throw new ClassCastException("Should extend ModuleInstall: " + clazz.getName());
                }
            }
            catch (Exception exception) {
                InvalidException invalidException = new InvalidException(module, exception.toString());
                invalidException.initCause((Throwable)exception);
                throw invalidException;
            }
            catch (LinkageError linkageError) {
                InvalidException invalidException = new InvalidException(module, linkageError.toString());
                invalidException.initCause((Throwable)linkageError);
                throw invalidException;
            }
        }
        entry2 = module.getManifest().getMainAttributes().getValue("OpenIDE-Module-Layer");
        object2 = module.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
        if (entry2 != null && object2 == null && (object = module.getClassLoader().getResource((String)((Object)entry2))) == null) {
            throw new InvalidException(module, "Layer not found: " + (String)((Object)entry2));
        }
        object = module.getManifest().getMainAttributes().getValue("OpenIDE-Module-Description");
        if (object != null) {
            Util.err.warning("Use of OpenIDE-Module-Description in " + module.getCodeNameBase() + " is deprecated.");
            Util.err.warning("(Please install help using an XML layer instead.)");
        }
        if (hashSet != null) {
            this.sections.put(module, hashSet);
        }
        if (clazz != null) {
            this.installs.put(module, clazz.asSubclass(ModuleInstall.class));
        }
        if (entry2 != null) {
            this.layers.put(module, (String)((Object)entry2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForHiddenPackages(Module module) throws InvalidException {
        ArrayList<Module.PackageExport> arrayList = new ArrayList<Module.PackageExport>();
        LinkedList<Module> linkedList = new LinkedList<Module>();
        linkedList.add(module);
        for (Object object : module.getDependencies()) {
            if (object.getType() != 1) continue;
            Module string4 = this.mgr.get((String)Util.parseCodeName((String)object.getName())[0]);
            assert (string4 != null) : object;
            linkedList.add(string4);
        }
        for (Object object : linkedList) {
            String string = (String)object.getAttribute("OpenIDE-Module-Hide-Classpath-Packages");
            if (string == null) continue;
            for (String string2 : string.trim().split("[ ,]+")) {
                try {
                    String string3;
                    if (string2.endsWith(".*")) {
                        string3 = string2.substring(0, string2.length() - 2);
                        Dependency.create((int)1, (String)string3);
                        if (string3.lastIndexOf(47) != -1) {
                            throw new IllegalArgumentException("Illegal OpenIDE-Module-Hide-Classpath-Packages: " + string);
                        }
                        arrayList.add(new Module.PackageExport(string3.replace('.', '/') + '/', false));
                        continue;
                    }
                    if (string2.endsWith(".**")) {
                        string3 = string2.substring(0, string2.length() - 3);
                        Dependency.create((int)1, (String)string3);
                        if (string3.lastIndexOf(47) != -1) {
                            throw new IllegalArgumentException("Illegal OpenIDE-Module-Hide-Classpath-Packages: " + string);
                        }
                        arrayList.add(new Module.PackageExport(string3.replace('.', '/') + '/', true));
                        continue;
                    }
                    throw new IllegalArgumentException("Illegal OpenIDE-Module-Hide-Classpath-Packages: " + string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidException((Module)object, illegalArgumentException.getMessage());
                }
            }
        }
        if (!arrayList.isEmpty()) {
            Map<Module, List<Module.PackageExport>> map = this.hiddenClasspathPackages;
            synchronized (map) {
                this.hiddenClasspathPackages.put(module, arrayList);
                for (Module.PackageExport packageExport : arrayList) {
                    Object object = this.hiddenClasspathPackagesReverse.get(packageExport);
                    if (object == null) {
                        object = new LinkedList();
                        this.hiddenClasspathPackagesReverse.put(packageExport, (List<Module>)object);
                    }
                    object.add(module);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Module module) {
        Util.err.fine("dispose: " + module);
        Set<ManifestSection> set = this.sections.remove(module);
        if (set != null) {
            for (ManifestSection object : set) {
                object.dispose();
            }
        }
        this.installs.remove(module);
        this.layers.remove(module);
        this.kosherPackages.remove(module);
        Map<Module, List<Module.PackageExport>> map = this.hiddenClasspathPackages;
        synchronized (map) {
            this.hiddenClasspathPackages.remove(module);
            for (List<Module> list : this.hiddenClasspathPackagesReverse.values()) {
                list.remove(module);
            }
        }
    }

    protected void classLoaderUp(ClassLoader classLoader) {
        MainLookup.systemClassLoaderChanged(classLoader);
        this.ev.log("perfTick", new Object[]{"META-INF/services/ additions registered"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(List<Module> list) {
        this.ev.log("startLoad", new Object[]{list});
        this.checkForDeprecations(list);
        this.loadLayers(list, true);
        this.ev.log("perfTick", new Object[]{"layers loaded"});
        this.ev.log("perfStart", new Object[]{"NbInstaller.load - sections"});
        this.ev.log("loadSection", new Object[0]);
        CoreBridge.getDefault().loaderPoolTransaction(true);
        try {
            for (Module module : list) {
                try {
                    this.loadSections(module, true);
                }
                catch (Exception exception) {
                    Util.err.log(Level.SEVERE, null, exception);
                }
                catch (LinkageError linkageError) {
                    Util.err.log(Level.SEVERE, null, linkageError);
                }
                this.ev.log("perfTick", new Object[]{"sections for " + module.getCodeName() + " loaded"});
            }
        }
        finally {
            CoreBridge.getDefault().loaderPoolTransaction(false);
        }
        this.ev.log("perfEnd", new Object[]{"NbInstaller.load - sections"});
        if (!this.initializedFolderLookup) {
            Util.err.fine("modulesClassPathInitialized");
            MainLookup.modulesClassPathInitialized();
            this.initializedFolderLookup = true;
        }
        Main.initUICustomizations();
        this.ev.log("perfStart", new Object[]{"NbInstaller.load - ModuleInstalls"});
        for (Module module : list) {
            try {
                this.loadCode(module, true);
            }
            catch (Exception exception) {
                Util.err.log(Level.SEVERE, null, exception);
            }
            catch (LinkageError linkageError) {
                Util.err.log(Level.SEVERE, null, linkageError);
            }
            catch (AssertionError assertionError) {
                Util.err.log(Level.SEVERE, null, (Throwable)((Object)assertionError));
            }
            this.ev.log("perfTick", new Object[]{"ModuleInstall for " + module.getCodeName() + " called"});
        }
        this.ev.log("perfEnd", new Object[]{"NbInstaller.load - ModuleInstalls"});
        this.ev.log("finishLoad", new Object[]{list});
        if (Boolean.getBoolean("netbeans.preresolve.classes")) {
            this.preresolveClasses(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(List<Module> list) {
        this.ev.log("startUnload", new Object[]{list});
        for (Module module : list) {
            try {
                this.loadCode(module, false);
            }
            catch (Exception exception) {
                Util.err.log(Level.SEVERE, null, exception);
            }
            catch (LinkageError linkageError) {
                Util.err.log(Level.SEVERE, null, linkageError);
            }
        }
        CoreBridge.getDefault().loaderPoolTransaction(true);
        try {
            for (Module module : list) {
                try {
                    this.loadSections(module, false);
                }
                catch (Exception exception) {
                    Util.err.log(Level.SEVERE, null, exception);
                }
                catch (LinkageError linkageError) {
                    Util.err.log(Level.SEVERE, null, linkageError);
                }
            }
        }
        finally {
            try {
                CoreBridge.getDefault().loaderPoolTransaction(false);
            }
            catch (RuntimeException runtimeException) {
                Util.err.log(Level.SEVERE, null, runtimeException);
            }
        }
        this.loadLayers(list, false);
        this.ev.log("finishUnload", new Object[]{list});
    }

    private void loadCode(Module module, boolean bl) throws Exception {
        Class<? extends ModuleInstall> clazz = this.installs.get(module);
        if (clazz != null) {
            ModuleInstall moduleInstall = (ModuleInstall)SharedClassObject.findObject(clazz, (boolean)true);
            if (bl) {
                this.ev.log("restore", new Object[]{module});
                moduleInstall.restored();
            } else {
                this.ev.log("uninstall", new Object[]{module});
                moduleInstall.uninstalled();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSections(Module module, boolean bl) throws Exception {
        Set<ManifestSection> set = this.sections.get(module);
        if (set == null) {
            return;
        }
        boolean bl2 = false;
        try {
            this.ev.log("loadSection", new Object[0]);
            for (ManifestSection manifestSection : set) {
                if (manifestSection instanceof ManifestSection.ActionSection) {
                    if (!bl2) {
                        Object object = module.getLocalizedAttribute("OpenIDE-Module-Display-Category");
                        if (object == null) {
                            object = module.getCodeNameBase();
                        }
                        CoreBridge.getDefault().attachToCategory(object);
                        bl2 = true;
                    }
                    CoreBridge.getDefault().loadActionSection((ManifestSection.ActionSection)manifestSection, bl);
                    continue;
                }
                if (manifestSection instanceof ManifestSection.ClipboardConvertorSection) {
                    this.loadGenericSection(manifestSection, bl);
                    continue;
                }
                if (manifestSection instanceof ManifestSection.DebuggerSection) {
                    this.loadGenericSection(manifestSection, bl);
                    continue;
                }
                if (manifestSection instanceof ManifestSection.LoaderSection) {
                    CoreBridge.getDefault().loadLoaderSection((ManifestSection.LoaderSection)manifestSection, bl);
                    continue;
                }
                assert (false) : manifestSection;
            }
        }
        finally {
            if (bl2) {
                CoreBridge.getDefault().attachToCategory(null);
            }
        }
    }

    private void loadGenericSection(ManifestSection manifestSection, boolean bl) {
        CoreBridge.getDefault().loadDefaultSection(manifestSection, this.convertor, bl);
    }

    private void loadLayers(List<Module> list, boolean bl) {
        LinkedHashSet<URL> linkedHashSet;
        ModuleLayeredFileSystem moduleLayeredFileSystem;
        this.ev.log(bl ? "loadLayers" : "unloadLayers", new Object[]{list});
        list = new ArrayList<Module>(list);
        Collections.reverse(list);
        HashMap hashMap = new HashMap(5);
        ModuleLayeredFileSystem moduleLayeredFileSystem2 = ModuleLayeredFileSystem.getUserModuleLayer();
        ModuleLayeredFileSystem moduleLayeredFileSystem3 = ModuleLayeredFileSystem.getInstallationModuleLayer();
        hashMap.put(moduleLayeredFileSystem2, new LinkedHashSet(1000));
        hashMap.put(moduleLayeredFileSystem3, new LinkedHashSet(1000));
        for (Module object : list) {
            Object object2;
            Object object3;
            moduleLayeredFileSystem = object.isReloadable() ? moduleLayeredFileSystem2 : moduleLayeredFileSystem3;
            linkedHashSet = (LinkedHashSet<URL>)hashMap.get((Object)moduleLayeredFileSystem);
            if (linkedHashSet == null) {
                linkedHashSet = new LinkedHashSet<URL>(1000);
                hashMap.put(moduleLayeredFileSystem, linkedHashSet);
            }
            ClassLoader classLoader = object.getClassLoader();
            String string = this.layers.get(object);
            if (string != null) {
                Util.err.log(Level.FINE, "loadLayer: {0} load={1}", new Object[]{string, bl});
                int n = string.lastIndexOf(46);
                if (n == -1) {
                    object3 = string;
                    object2 = "";
                } else {
                    object3 = string.substring(0, n);
                    object2 = string.substring(n);
                }
                boolean bl2 = false;
                for (String string2 : NbCollections.iterable((Iterator)NbBundle.getLocalizingSuffixes())) {
                    String string3 = (String)object3 + string2 + (String)object2;
                    URL uRL = classLoader instanceof ProxyClassLoader ? ((ProxyClassLoader)classLoader).findResource(string3) : classLoader.getResource(string3);
                    if (uRL == null) continue;
                    linkedHashSet.add(uRL);
                    bl2 = true;
                }
                if (!bl2) {
                    Util.err.fine("Module layer not found: " + string);
                    continue;
                }
            }
            try {
                object3 = ClassLoader.class.getDeclaredMethod("findResources", String.class);
                ((Method)object3).setAccessible(true);
                object2 = (Enumeration)((Method)object3).invoke((Object)classLoader, "META-INF/generated-layer.xml");
                while (object2.hasMoreElements()) {
                    URL uRL = (URL)object2.nextElement();
                    linkedHashSet.add(uRL);
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            moduleLayeredFileSystem = (ModuleLayeredFileSystem)((Object)entry.getKey());
            linkedHashSet = (Collection)entry.getValue();
            Util.err.log(Level.FINE, "Adding/removing layer URLs: host={0} urls={1}", new Object[]{moduleLayeredFileSystem, linkedHashSet});
            try {
                if (bl) {
                    moduleLayeredFileSystem.addURLs(linkedHashSet);
                    continue;
                }
                moduleLayeredFileSystem2.removeURLs(linkedHashSet);
                moduleLayeredFileSystem3.removeURLs(linkedHashSet);
            }
            catch (Exception exception) {
                Util.err.log(Level.WARNING, null, exception);
            }
        }
    }

    private void checkForDeprecations(List<Module> list) {
        TreeSet<String> treeSet;
        String string;
        TreeMap<String, TreeSet<String>> treeMap = new TreeMap<String, TreeSet<String>>();
        for (Module object : list) {
            if (Boolean.parseBoolean((String)object.getAttribute("OpenIDE-Module-Deprecated"))) continue;
            for (Module module : object.getDependencies()) {
                if (module.getType() != 1) continue;
                string = (String)Util.parseCodeName((String)module.getName())[0];
                treeSet = (TreeSet<String>)treeMap.get(string);
                if (treeSet == null) {
                    treeSet = new TreeSet<String>();
                    treeMap.put(string, treeSet);
                }
                treeSet.add(object.getCodeNameBase());
            }
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            Module module;
            String string2 = (String)entry.getKey();
            module = this.mgr.get(string2);
            assert (module != null) : "No such module: " + (String)string2;
            if (!Boolean.parseBoolean((String)module.getAttribute("OpenIDE-Module-Deprecated"))) continue;
            string = (String)module.getLocalizedAttribute("OpenIDE-Module-Deprecation-Message");
            treeSet = (Set)entry.getValue();
            if (string != null) {
                Util.err.log(Level.WARNING, "the modules {0} use {1} which is deprecated: {2}", new Object[]{treeSet, string2, string});
                continue;
            }
            Util.err.log(Level.WARNING, "the modules {0} use {1} which is deprecated.", new Object[]{treeSet, string2});
        }
    }

    public boolean closing(List<Module> list) {
        Util.err.fine("closing: " + list);
        for (Module module : list) {
            Class<? extends ModuleInstall> clazz = this.installs.get(module);
            if (clazz == null) continue;
            try {
                ModuleInstall moduleInstall = (ModuleInstall)SharedClassObject.findObject(clazz, (boolean)true);
                if (moduleInstall.closing()) continue;
                Util.err.fine("Module " + module + " refused to close");
                return false;
            }
            catch (RuntimeException runtimeException) {
                Util.err.log(Level.SEVERE, null, runtimeException);
            }
            catch (LinkageError linkageError) {
                Util.err.log(Level.SEVERE, null, linkageError);
            }
        }
        return true;
    }

    public void close(List<Module> list) {
        Util.err.fine("close: " + list);
        this.ev.log("close", new Object[0]);
        this.moduleList.shutDown();
        for (Module module : list) {
            Class<? extends ModuleInstall> clazz = this.installs.get(module);
            if (clazz == null) continue;
            try {
                ModuleInstall moduleInstall = (ModuleInstall)SharedClassObject.findObject(clazz, (boolean)true);
                if (moduleInstall == null) {
                    throw new IllegalStateException("Inconsistent state: " + clazz);
                }
                moduleInstall.close();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Util.err.log(Level.SEVERE, null, throwable);
            }
        }
    }

    protected Set<Dependency> loadDependencies(String string) {
        return string.equals(cacheCnb) ? cacheDeps : null;
    }

    static void register(String string, Object object) {
        cacheCnb = string;
        cacheDeps = (Set)object;
    }

    public void refineDependencies(Module module, Set<Dependency> set) {
        Object object;
        if (Boolean.getBoolean("org.netbeans.core.modules.NbInstaller.noAutoDeps")) {
            return;
        }
        if (this.autoDepsHandler == null) {
            object = FileUtil.getConfigFile((String)"ModuleAutoDeps");
            if (object != null) {
                FileObject[] fileObjectArray = object.getChildren();
                ArrayList<URL> arrayList = new ArrayList<URL>(Math.max(fileObjectArray.length, 1));
                for (FileObject fileObject : fileObjectArray) {
                    if (!fileObject.hasExt("xml")) continue;
                    try {
                        arrayList.add(fileObject.getURL());
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        Util.err.log(Level.WARNING, null, fileStateInvalidException);
                    }
                }
                try {
                    this.autoDepsHandler = AutomaticDependencies.parse(arrayList.toArray(new URL[arrayList.size()]));
                }
                catch (IOException iOException) {
                    Util.err.log(Level.WARNING, null, iOException);
                }
                catch (SAXException sAXException) {
                    Util.err.log(Level.WARNING, null, sAXException);
                }
            }
            if (this.autoDepsHandler == null) {
                this.autoDepsHandler = AutomaticDependencies.empty();
            }
            if (Util.err.isLoggable(Level.FINE)) {
                Util.err.fine("Auto deps: " + this.autoDepsHandler);
            }
        }
        if (((AutomaticDependencies.Report)(object = this.autoDepsHandler.refineDependenciesAndReport(module.getCodeNameBase(), set))).isModified()) {
            Util.err.warning(((AutomaticDependencies.Report)object).toString());
        }
    }

    public String[] refineProvides(Module module) {
        if (module.getCodeNameBase().equals("org.openide.modules")) {
            ArrayList<String> arrayList = new ArrayList<String>(4);
            CoreBridge.defineOsTokens(arrayList);
            arrayList.add("org.openide.modules.ModuleFormat1");
            arrayList.add("org.openide.modules.ModuleFormat2");
            return arrayList.toArray(new String[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldDelegateResource(Module module, Module module2, String string) {
        if (module2 == null) {
            List<Module.PackageExport> list;
            for (String string2 : CLASSPATH_PACKAGES) {
                if (!string.startsWith(string2) || this.findKosher(module).contains(string2)) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Refusing to load classpath package " + string + " for " + module.getCodeNameBase() + " without a proper dependency");
                }
                return false;
            }
            Object object = this.hiddenClasspathPackages;
            synchronized (object) {
                list = this.hiddenClasspathPackages.get(module);
            }
            if (list != null) {
                object = list.iterator();
                while (object.hasNext()) {
                    Module.PackageExport packageExport = (Module.PackageExport)object.next();
                    if (!(packageExport.recursive ? string.startsWith(packageExport.pkg) : string.equals(packageExport.pkg))) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Refusing to load classpath package " + string + " for " + module.getCodeNameBase());
                    }
                    return false;
                }
            }
        }
        if (LOG.isLoggable(Level.FINER) && !string.equals("java/util/logging/")) {
            LOG.finer("Delegating resource " + string + " from " + module2 + " for " + module.getCodeNameBase());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldDelegateClasspathResource(String string) {
        Map<Module, List<Module.PackageExport>> map = this.hiddenClasspathPackages;
        synchronized (map) {
            for (Map.Entry<Module.PackageExport, List<Module>> entry : this.hiddenClasspathPackagesReverse.entrySet()) {
                Module.PackageExport packageExport = entry.getKey();
                if (!(packageExport.recursive ? string.startsWith(packageExport.pkg) : string.equals(packageExport.pkg))) continue;
                for (Module module : entry.getValue()) {
                    if (!module.isEnabled()) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Refusing to load classpath package " + string + " because of " + module.getCodeNameBase());
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private Set<String> findKosher(Module module) {
        Set<String> set = this.kosherPackages.get(module);
        if (set == null) {
            set = new HashSet<String>();
            Set set2 = module.getDependencies();
            SpecificationVersion specificationVersion = Util.getModuleDep((Set)set2, (String)"org.openide");
            boolean bl = specificationVersion == null || specificationVersion.compareTo((Object)new SpecificationVersion("1.3.12")) < 0;
            for (Dependency dependency : set2) {
                String string;
                String string2;
                if (dependency.getType() == 1 && dependency.getName().equals("org.netbeans.core.startup/1")) {
                    set.add("org/netbeans/core/startup/");
                    continue;
                }
                if (bl && dependency.getType() == 1) {
                    Module module2;
                    string2 = dependency.getName();
                    int n = string2.indexOf(47);
                    if (n != -1) {
                        string2 = string2.substring(0, n);
                    }
                    if ((module2 = this.mgr.get(string2)) == null) {
                        throw new IllegalStateException("Should have found dep " + dependency + " from " + module);
                    }
                    set.addAll(this.findKosher(module2));
                    continue;
                }
                if (dependency.getType() != 2) continue;
                string2 = dependency.getName();
                int n = string2.indexOf(91);
                if (n == -1) {
                    string = string2.replace('.', '/').concat("/");
                } else if (n == 0) {
                    int n2 = string2.lastIndexOf(46);
                    string = string2.substring(1, n2).replace('.', '/').concat("/");
                } else {
                    string = string2.substring(0, n).replace('.', '/').concat("/");
                }
                for (String string3 : CLASSPATH_PACKAGES) {
                    if (!string.startsWith(string3)) continue;
                    set.add(string3);
                }
            }
            if (set.isEmpty()) {
                set = Collections.emptySet();
            }
            this.kosherPackages.put(module, set);
        }
        return set;
    }

    String getEffectiveClasspath(Module module) {
        if (!module.isEnabled()) {
            return "";
        }
        ArrayList<String> arrayList = new ArrayList<String>(100);
        NbInstaller.createBootClassPath(arrayList);
        Set<String> set = module.isFixed() ? null : this.findKosher(module);
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path", ""), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(stringTokenizer.nextToken()), arrayList, set);
        }
        stringTokenizer = new StringTokenizer(System.getProperty("netbeans.dynamic.classpath", ""), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(stringTokenizer.nextToken()), arrayList, set);
        }
        HashSet<Module> hashSet = new HashSet<Module>(50);
        HashSet<String> hashSet2 = new HashSet<String>(10);
        for (Dependency dependency : module.getDependencies()) {
            if (dependency.getType() != 1 || dependency.getComparison() != 2) continue;
            hashSet2.add(dependency.getName());
        }
        SpecificationVersion specificationVersion = Util.getModuleDep((Set)module.getDependencies(), (String)"org.openide");
        boolean bl = specificationVersion == null || specificationVersion.compareTo((Object)new SpecificationVersion("1.3.12")) < 0;
        this.addModuleClasspathEntries(module, module, hashSet, hashSet2, arrayList, bl ? Integer.MAX_VALUE : 1);
        StringBuilder stringBuilder = new StringBuilder(arrayList.size() * 100 + 1);
        for (String string : arrayList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static void createBootClassPath(List<String> list) {
        Object object;
        String string = System.getProperty("sun.boot.class.path");
        if (string != null) {
            object = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object).hasMoreTokens()) {
                list.add(((StringTokenizer)object).nextToken());
            }
        }
        if ((object = System.getProperty("java.ext.dirs")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                for (File file2 : fileArray) {
                    String string2 = file2.getName().toLowerCase(Locale.US);
                    if (!string2.endsWith(".zip") && !string2.endsWith(".jar")) continue;
                    list.add(file2.getAbsolutePath());
                }
            }
        }
    }

    private static void addStartupClasspathEntry(File file, List<String> list, Set<String> set) {
        if (file.isDirectory()) {
            list.add(file.getAbsolutePath());
            return;
        }
        String string = file.getName();
        for (String[] stringArray : CLASSPATH_JARS) {
            if (set == null || !string.startsWith(stringArray[0])) continue;
            StringBuilder stringBuilder = null;
            for (int i = 1; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!set.contains(string2)) continue;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(100);
                    stringBuilder.append(file.getAbsolutePath());
                    stringBuilder.append('[');
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string2.replace('/', '.'));
                stringBuilder.append("**");
            }
            if (stringBuilder != null) {
                stringBuilder.append(']');
                list.add(stringBuilder.toString());
            }
            return;
        }
        list.add(file.getAbsolutePath());
    }

    private void addModuleClasspathEntries(Module module, Module module2, Set<Module> set, Set<String> set2, List<String> list, int n) {
        Object object;
        String string;
        Module.PackageExport[] packageExportArray2;
        if (!set.add(module)) {
            return;
        }
        for (Module.PackageExport[] packageExportArray2 : module.getDependencies()) {
            if (packageExportArray2.getType() != 1) continue;
            string = (String)Util.parseCodeName((String)packageExportArray2.getName())[0];
            object = this.mgr.get(string);
            if (object == null) {
                throw new IllegalStateException("No such module: " + string);
            }
            if (n <= 0) continue;
            this.addModuleClasspathEntries((Module)object, module2, set, set2, list, n - 1);
        }
        boolean bl = module == module2 || set2.contains(module.getCodeName());
        packageExportArray2 = bl ? null : module.getPublicPackages();
        string = "";
        if (packageExportArray2 != null) {
            if (packageExportArray2.length == 0) {
                return;
            }
            object = new StringBuilder(100);
            ((StringBuilder)object).append('[');
            for (int i = 0; i < packageExportArray2.length; ++i) {
                if (i > 0) {
                    ((StringBuilder)object).append(',');
                }
                ((StringBuilder)object).append(packageExportArray2[i].pkg.replace('/', '.'));
                ((StringBuilder)object).append(packageExportArray2[i].recursive ? "**" : "*");
            }
            ((StringBuilder)object).append(']');
            string = ((StringBuilder)object).toString();
        }
        for (File file : module.getAllJars()) {
            list.add(file.getAbsolutePath() + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest loadManifest(File file) throws IOException {
        Map<File, DateAndManifest> map;
        if (!this.usingManifestCache) {
            return super.loadManifest(file);
        }
        Object object = this.MANIFEST_CACHE;
        synchronized (object) {
            if (this.manifestCache == null) {
                this.manifestCache = Collections.synchronizedMap(this.loadManifestCache());
            }
            map = this.manifestCache;
        }
        object = map.get(file);
        if (object != null) {
            MANIFEST_LOG.fine("Found manifest for " + file + " in cache");
            return ((DateAndManifest)object).manifest;
        }
        MANIFEST_LOG.fine("No entry for " + file + " in manifest cache");
        Manifest manifest = super.loadManifest(file);
        map.put(file, new DateAndManifest(file.lastModified(), manifest));
        this.saveManifestCache();
        return manifest;
    }

    private void saveManifestCache() throws IOException {
        MANIFEST_LOG.fine("Schedule saving manifest cache");
        Stamps.getModulesJARs().scheduleSave((Stamps.Updater)this.updater, "all-manifest.dat", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<File, DateAndManifest> loadManifestCache() {
        this.ev.log("perfStart", new Object[]{"NbInstaller - loadManifestCache"});
        ByteBuffer byteBuffer = Stamps.getModulesJARs().asByteBuffer("all-manifest.dat");
        HashMap<File, DateAndManifest> hashMap = new HashMap<File, DateAndManifest>(200);
        try {
            NbInstaller.readManifestCacheEntries(byteBuffer, hashMap);
        }
        catch (IOException iOException) {
            try {
                MANIFEST_LOG.log(Level.WARNING, "Cannot read cache", iOException);
            }
            catch (Throwable throwable) {
                this.ev.log("perfEnd", new Object[]{"NbInstaller - loadManifestCache"});
                throw throwable;
            }
            this.ev.log("perfEnd", new Object[]{"NbInstaller - loadManifestCache"});
        }
        this.ev.log("perfEnd", new Object[]{"NbInstaller - loadManifestCache"});
        return hashMap;
    }

    private static int findNullByte(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.limit();
        for (int i = n; i < n2; ++i) {
            if (byteBuffer.get(i) != 0) continue;
            return i;
        }
        return -1;
    }

    private static void readManifestCacheEntries(ByteBuffer byteBuffer, Map<File, DateAndManifest> map) throws IOException {
        if (byteBuffer == null) {
            return;
        }
        int n = 0;
        while (n != byteBuffer.limit()) {
            Manifest manifest;
            int n2 = NbInstaller.findNullByte(byteBuffer, n);
            if (n2 == -1) {
                throw new IOException("Could not find next manifest JAR name from " + n);
            }
            File file = new File(new String(NbInstaller.toArray(byteBuffer, n, n2 - n), "UTF-8"));
            long l = 0L;
            if (n2 + 8 >= byteBuffer.limit()) {
                throw new IOException("Ran out of space for timestamp for " + file);
            }
            for (int i = 0; i < 8; ++i) {
                long l2 = byteBuffer.get(n2 + i + 1);
                if (l2 < 0L) {
                    l2 += 256L;
                }
                int n3 = 7 - i;
                long l3 = l2 << n3 * 8;
                l |= l3;
            }
            n = n2 + 9;
            if ((n2 = NbInstaller.findNullByte(byteBuffer, n)) == -1) {
                throw new IOException("Could not find manifest body for " + file);
            }
            try {
                manifest = new Manifest(new ByteArrayInputStream(NbInstaller.toArray(byteBuffer, n, n2 - n)));
            }
            catch (IOException iOException) {
                Exceptions.attachMessage((Throwable)iOException, (String)("While in entry for " + file));
                throw iOException;
            }
            map.put(file, new DateAndManifest(l, manifest));
            if (MANIFEST_LOG.isLoggable(Level.FINE)) {
                MANIFEST_LOG.fine("Manifest cache entry: jar=" + file + " date=" + new Date(l) + " codename=" + manifest.getMainAttributes().getValue("OpenIDE-Module"));
            }
            n = n2 + 1;
        }
        return;
    }

    private static byte[] toArray(ByteBuffer byteBuffer, int n, int n2) {
        byte[] byArray = new byte[n2];
        byteBuffer.position(n);
        byteBuffer.get(byArray, 0, n2);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preresolveClasses(List<Module> list) {
        Util.err.info("Pre-resolving classes for all loaded modules...be sure you have not specified -J-Xverify:none in ide.cfg");
        for (Module module : list) {
            if (module.isFixed() || module.getJarFile() == null) continue;
            File file = module.getJarFile();
            try {
                JarFile jarFile = new JarFile(file, true);
                try {
                    for (JarEntry jarEntry : NbCollections.iterable(jarFile.entries())) {
                        String string = jarEntry.getName();
                        if (!string.endsWith(".class")) continue;
                        String string2 = string.substring(0, string.length() - 6).replace('/', '.');
                        Throwable throwable = null;
                        try {
                            Class.forName(string2, false, module.getClassLoader());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throwable = classNotFoundException;
                        }
                        catch (LinkageError linkageError) {
                            throwable = linkageError;
                        }
                        catch (RuntimeException runtimeException) {
                            throwable = runtimeException;
                        }
                        if (throwable == null) continue;
                        Util.err.log(Level.WARNING, "From " + string2 + " in " + module.getCodeNameBase() + " with effective classpath " + this.getEffectiveClasspath(module), throwable);
                    }
                }
                finally {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                Util.err.log(Level.WARNING, null, iOException);
            }
        }
    }

    static {
        CLASSPATH_PACKAGES = new String[]{"org/netbeans/core/startup/"};
        CLASSPATH_JARS = new String[][]{{"core", "org/netbeans/core/", "org/netbeans/beaninfo/"}, {"boot"}};
        MANIFEST_LOG = Logger.getLogger(NbInstaller.class.getName() + ".manifestCache");
    }

    class CacheFlusher
    implements Stamps.Updater {
        CacheFlusher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushCaches(DataOutputStream dataOutputStream) throws IOException {
            HashMap hashMap;
            NbInstaller.this.updater = new CacheFlusher();
            MANIFEST_LOG.fine("Saving manifest cache");
            Iterator iterator = NbInstaller.this.MANIFEST_CACHE;
            synchronized (iterator) {
                hashMap = new HashMap(NbInstaller.this.manifestCache);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                File file = (File)entry.getKey();
                dataOutputStream.write(file.getAbsolutePath().getBytes("UTF-8"));
                dataOutputStream.write(0);
                long l = ((DateAndManifest)entry.getValue()).date;
                for (int i = 7; i >= 0; --i) {
                    dataOutputStream.write((int)(l >> i * 8 & 0xFFL));
                }
                ((DateAndManifest)entry.getValue()).manifest.write(dataOutputStream);
                dataOutputStream.write(0);
            }
            dataOutputStream.close();
            MANIFEST_LOG.fine("Saving manifest cache - done");
        }

        public void cacheReady() {
        }
    }

    private static final class DateAndManifest {
        public final long date;
        public final Manifest manifest;

        public DateAndManifest(long l, Manifest manifest) {
            this.date = l;
            this.manifest = manifest;
        }
    }

    private final class Convertor
    implements InstanceContent.Convertor<ManifestSection, Object> {
        Convertor() {
        }

        public Object convert(ManifestSection manifestSection) {
            try {
                return manifestSection.getInstance();
            }
            catch (Exception exception) {
                Util.err.log(Level.WARNING, null, exception);
                NbInstaller.this.loadGenericSection(manifestSection, false);
                return null;
            }
        }

        public Class<?> type(ManifestSection manifestSection) {
            return manifestSection.getSuperclass();
        }

        public String id(ManifestSection manifestSection) {
            return manifestSection.toString();
        }

        public String displayName(ManifestSection manifestSection) {
            return manifestSection.toString();
        }
    }
}

