/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.ModuleFactory;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;

public class ProxyClassLoader
extends ClassLoader {
    private static final Logger LOGGER = Logger.getLogger(ProxyClassLoader.class.getName());
    private static final boolean LOG_LOADING;
    private static final ClassLoader TOP_CL;
    private final Map<String, Package> packages = new HashMap<String, Package>();
    private ProxyClassLoader[] parents;
    private final boolean transitive;
    private ClassLoader systemCL = TOP_CL;
    private static final Map<String, Set<ProxyClassLoader>> packageCoverage;
    private Set<ProxyClassLoader> parentSet = new HashSet<ProxyClassLoader>();
    private static Map<String, Boolean> sclPackages;
    private static final Set<String> arbitraryLoadWarnings;

    public ProxyClassLoader(ClassLoader[] classLoaderArray, boolean bl) {
        super(TOP_CL);
        this.transitive = bl;
        this.parents = this.coalesceParents(classLoaderArray);
        this.parentSet.addAll(Arrays.asList(this.parents));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addCoveredPackages(Iterable<String> iterable) {
        Map<String, Set<ProxyClassLoader>> map = packageCoverage;
        synchronized (map) {
            for (String string : iterable) {
                Set<ProxyClassLoader> set = packageCoverage.get(string);
                if (set == null) {
                    set = Collections.singleton(this);
                    packageCoverage.put(string, set);
                    continue;
                }
                if (set.size() == 1) {
                    set = new HashSet<ProxyClassLoader>(set);
                    packageCoverage.put(string, set);
                    set.add(this);
                    continue;
                }
                set.add(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(ClassLoader[] classLoaderArray) throws IllegalArgumentException {
        if (classLoaderArray == null) {
            throw new IllegalArgumentException("null parents array");
        }
        for (ClassLoader classLoader : classLoaderArray) {
            if (classLoader != null) continue;
            throw new IllegalArgumentException("null parent: " + Arrays.asList(classLoaderArray));
        }
        ClassLoader[] classLoaderArray2 = null;
        ModuleFactory moduleFactory = (ModuleFactory)Lookup.getDefault().lookup(ModuleFactory.class);
        if (moduleFactory != null && moduleFactory.removeBaseClassLoader()) {
            this.systemCL = ClassLoader.getSystemClassLoader();
            classLoaderArray2 = this.coalesceAppend(new ProxyClassLoader[0], classLoaderArray);
        } else {
            classLoaderArray2 = this.coalesceAppend(this.parents, classLoaderArray);
        }
        ProxyClassLoader proxyClassLoader = this;
        synchronized (proxyClassLoader) {
            this.parents = classLoaderArray2;
            this.parentSet.clear();
            this.parentSet.addAll(Arrays.asList(this.parents));
        }
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (LOG_LOADING && !string.startsWith("java.")) {
            LOGGER.log(Level.FINEST, "{0} initiated loading of {1}", new Object[]{this, string});
        }
        Class clazz = null;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new ClassNotFoundException("Will not load classes from default package (" + string + ")");
        }
        String string2 = n >= 0 ? string.substring(0, n) : "";
        String string3 = string2.replace('.', '/') + "/";
        Set<ProxyClassLoader> set = packageCoverage.get(string2);
        Boolean bl2 = sclPackages.get(string2);
        if ((bl2 == null || bl2.booleanValue()) && this.shouldDelegateResource(string3, null)) {
            try {
                clazz = this.systemCL.loadClass(string);
                if (bl2 == null) {
                    sclPackages.put(string2, true);
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (set != null) {
            if (set.size() == 1) {
                ProxyClassLoader proxyClassLoader = set.iterator().next();
                if ((proxyClassLoader == this || this.parentSet.contains(proxyClassLoader) && this.shouldDelegateResource(string3, proxyClassLoader)) && (clazz = super.selfLoadClass(string2, string)) != null) {
                    sclPackages.put(string2, false);
                }
            } else {
                for (ProxyClassLoader proxyClassLoader : this.parents) {
                    Class clazz2;
                    if (!set.contains(proxyClassLoader) || !this.shouldDelegateResource(string3, proxyClassLoader) || (clazz2 = super.selfLoadClass(string2, string)) == null) continue;
                    if (clazz == null) {
                        clazz = clazz2;
                        continue;
                    }
                    if (clazz == clazz2) continue;
                    String string4 = "Will not load class " + string + " arbitrarily from one of " + clazz.getClassLoader() + " and " + proxyClassLoader + " starting from " + this + "; see http://wiki.netbeans.org/DevFaqModuleCCE";
                    ClassNotFoundException classNotFoundException = new ClassNotFoundException(string4);
                    if (arbitraryLoadWarnings.add(string4)) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, null, classNotFoundException);
                        } else {
                            LOGGER.warning(string4);
                        }
                    }
                    throw classNotFoundException;
                }
                if (clazz == null && set.contains(this)) {
                    clazz = this.selfLoadClass(string2, string);
                }
                if (clazz != null) {
                    sclPackages.put(string2, false);
                }
            }
        }
        if (clazz == null && this.shouldDelegateResource(string3, null)) {
            try {
                clazz = this.systemCL.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ClassNotFoundException(this.diagnosticCNFEMessage(classNotFoundException.getMessage(), set), classNotFoundException);
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(this.diagnosticCNFEMessage(string, set));
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private String diagnosticCNFEMessage(String string, Set<ProxyClassLoader> set) {
        return string + " starting from " + this + " with possible defining loaders " + set + " and declared parents " + this.parentSet;
    }

    private synchronized Class selfLoadClass(String string, String string2) {
        Class clazz = this.findLoadedClass(string2);
        if (clazz == null) {
            try {
                clazz = this.doLoadClass(string, string2);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw (NoClassDefFoundError)new NoClassDefFoundError(noClassDefFoundError.getMessage() + " while loading " + string + string2 + "; see http://wiki.netbeans.org/DevFaqTroubleshootClassNotFound").initCause(noClassDefFoundError);
            }
            if (LOG_LOADING && !string2.startsWith("java.")) {
                LOGGER.log(Level.FINEST, "{0} loaded {1}", new Object[]{this, string2});
            }
        }
        return clazz;
    }

    protected Class doLoadClass(String string, String string2) {
        return null;
    }

    private String stripInitialSlash(String string) {
        if (string.startsWith("/")) {
            LOGGER.log(Level.WARNING, "Should not use initial '/' in calls to ClassLoader.getResource(s): {0}", string);
            return string.substring(1);
        }
        return string;
    }

    @Override
    public final URL getResource(String string) {
        Set<ProxyClassLoader> set;
        URL uRL = null;
        int n = (string = this.stripInitialSlash(string)).lastIndexOf(47);
        String string2 = n >= 0 ? string.substring(0, n).replace('/', '.') : "";
        String string3 = string.substring(0, n + 1);
        Boolean bl = sclPackages.get(string2);
        if ((bl == null || bl.booleanValue()) && this.shouldDelegateResource(string3, null) && (set = this.systemCL.getResource(string)) != null) {
            if (bl == null) {
                sclPackages.put(string2, true);
            }
            return set;
        }
        set = packageCoverage.get(string2);
        if (set == null) {
            if (this.shouldDelegateResource(string3, null)) {
                uRL = this.systemCL.getResource(string);
            }
        } else if (set.size() == 1) {
            ProxyClassLoader proxyClassLoader = (ProxyClassLoader)set.iterator().next();
            if (proxyClassLoader == this || this.parentSet.contains(proxyClassLoader) && this.shouldDelegateResource(string3, proxyClassLoader)) {
                uRL = proxyClassLoader.findResource(string);
            }
        } else {
            ProxyClassLoader proxyClassLoader;
            ProxyClassLoader[] proxyClassLoaderArray = this.parents;
            int n2 = proxyClassLoaderArray.length;
            for (int i = 0; !(i >= n2 || set.contains(proxyClassLoader = proxyClassLoaderArray[i]) && this.shouldDelegateResource(string3, proxyClassLoader) && (uRL = proxyClassLoader.findResource(string)) != null); ++i) {
            }
            if (uRL == null && set.contains(this)) {
                uRL = this.findResource(string);
            }
        }
        if (uRL == null && this.shouldDelegateResource(string3, null)) {
            uRL = this.systemCL.getResource(string);
        }
        return uRL;
    }

    @Override
    public URL findResource(String string) {
        return super.findResource(string);
    }

    @Override
    public final synchronized Enumeration<URL> getResources(String string) throws IOException {
        Set<ProxyClassLoader> set;
        string = this.stripInitialSlash(string);
        int n = string.lastIndexOf(47);
        String string2 = string.substring(0, n + 1);
        String string3 = string.startsWith("META-INF/") ? string.substring(8) : (n >= 0 ? string.substring(0, n).replace('/', '.') : "");
        ArrayList<Enumeration<URL>> arrayList = new ArrayList<Enumeration<URL>>();
        if (this.shouldDelegateResource(string2, null)) {
            arrayList.add(this.systemCL.getResources(string));
        }
        if ((set = packageCoverage.get(string3)) != null) {
            for (ProxyClassLoader proxyClassLoader : this.parents) {
                if (!set.contains(proxyClassLoader) || !this.shouldDelegateResource(string2, proxyClassLoader)) continue;
                arrayList.add(proxyClassLoader.findResources(string));
            }
            if (set.contains(this)) {
                arrayList.add(this.findResources(string));
            }
        }
        return Enumerations.concat(Collections.enumeration(arrayList));
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        return super.findResources(string);
    }

    @Override
    protected Package getPackage(String string) {
        return this.getPackageFast(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackageFast(String string, boolean bl) {
        Map<String, Package> map = this.packages;
        synchronized (map) {
            ProxyClassLoader proxyClassLoader;
            Package package_ = this.packages.get(string);
            if (package_ != null) {
                return package_;
            }
            if (!bl) {
                return null;
            }
            for (int i = 0; i < this.parents.length && (package_ = (proxyClassLoader = this.parents[i]).getPackageFast(string, false)) == null; ++i) {
            }
            if (package_ == null) {
                package_ = super.getPackage(string);
            }
            if (package_ != null) {
                this.packages.put(string, package_);
            }
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        Map<String, Package> map = this.packages;
        synchronized (map) {
            Package package_ = super.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
            this.packages.put(string, package_);
            return package_;
        }
    }

    @Override
    protected synchronized Package[] getPackages() {
        return this.getPackages(new HashSet<ClassLoader>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Package[] getPackages(Set<ClassLoader> set) {
        HashMap<String, Package> hashMap = new HashMap<String, Package>();
        this.addPackages(hashMap, super.getPackages());
        for (int i = 0; i < this.parents.length; ++i) {
            ProxyClassLoader proxyClassLoader = this.parents[i];
            if (!(proxyClassLoader instanceof ProxyClassLoader) || !set.add(proxyClassLoader)) continue;
            this.addPackages(hashMap, proxyClassLoader.getPackages(set));
        }
        Map<String, Package> map = this.packages;
        synchronized (map) {
            hashMap.keySet().removeAll(this.packages.keySet());
            this.packages.putAll(hashMap);
        }
        return this.packages.values().toArray(new Package[this.packages.size()]);
    }

    private ProxyClassLoader[] coalesceParents(ClassLoader[] classLoaderArray) throws IllegalArgumentException {
        return this.coalesceAppend(new ProxyClassLoader[0], classLoaderArray);
    }

    private ProxyClassLoader[] coalesceAppend(ProxyClassLoader[] proxyClassLoaderArray, ClassLoader[] classLoaderArray) throws IllegalArgumentException {
        int n = proxyClassLoaderArray.length + classLoaderArray.length;
        LinkedHashSet<ClassLoader> linkedHashSet = new LinkedHashSet<ClassLoader>(n);
        linkedHashSet.addAll(Arrays.asList(proxyClassLoaderArray));
        if (linkedHashSet.containsAll(Arrays.asList(classLoaderArray))) {
            return proxyClassLoaderArray;
        }
        for (ClassLoader classLoader : classLoaderArray) {
            this.addRec(linkedHashSet, classLoader);
        }
        boolean bl = true;
        ArrayList<ProxyClassLoader> arrayList = new ArrayList<ProxyClassLoader>(linkedHashSet.size());
        for (ClassLoader classLoader : linkedHashSet) {
            if (bl) {
                if (classLoader instanceof ProxyClassLoader) {
                    bl = false;
                    arrayList.add((ProxyClassLoader)classLoader);
                    continue;
                }
                if (ProxyClassLoader.isParentOf(this.systemCL, classLoader)) {
                    this.systemCL = classLoader;
                    continue;
                }
                throw new IllegalArgumentException("Bad ClassLoader ordering: " + Arrays.asList(classLoaderArray));
            }
            if (classLoader instanceof ProxyClassLoader) {
                arrayList.add((ProxyClassLoader)classLoader);
                continue;
            }
            throw new IllegalArgumentException("Bad ClassLoader ordering: " + Arrays.asList(classLoaderArray));
        }
        ProxyClassLoader[] proxyClassLoaderArray2 = arrayList.toArray(new ProxyClassLoader[arrayList.size()]);
        return proxyClassLoaderArray2;
    }

    private static boolean isParentOf(ClassLoader classLoader, ClassLoader classLoader2) {
        while (classLoader2 != null) {
            if (classLoader2 == classLoader) {
                return true;
            }
            classLoader2 = classLoader2.getParent();
        }
        return false;
    }

    private void addRec(Set<ClassLoader> set, ClassLoader classLoader) throws IllegalArgumentException {
        if (classLoader == this) {
            throw new IllegalArgumentException("cycle in parents");
        }
        if (set.contains(classLoader)) {
            return;
        }
        if (classLoader instanceof ProxyClassLoader && ((ProxyClassLoader)classLoader).transitive) {
            for (ProxyClassLoader proxyClassLoader : ((ProxyClassLoader)classLoader).parents) {
                this.addRec(set, proxyClassLoader);
            }
        }
        set.add(classLoader);
    }

    private void addPackages(Map<String, Package> map, Package[] packageArray) {
        for (int i = 0; i < packageArray.length; ++i) {
            map.put(packageArray[i].getName(), packageArray[i]);
        }
    }

    protected final void setSystemClassLoader(ClassLoader classLoader) {
        this.systemCL = classLoader;
    }

    protected boolean shouldDelegateResource(String string, ClassLoader classLoader) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map<String, Set<ProxyClassLoader>> map = packageCoverage;
        synchronized (map) {
            Iterator<String> iterator = packageCoverage.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                Set<ProxyClassLoader> set = packageCoverage.get(string);
                if (set.contains(this) && set.size() == 1) {
                    iterator.remove();
                    continue;
                }
                set.remove(this);
            }
        }
    }

    final ClassLoader firstParent() {
        if (this.parents == null || this.parents.length == 0) {
            return null;
        }
        return this.parents[0];
    }

    static {
        TOP_CL = ProxyClassLoader.class.getClassLoader();
        boolean bl = System.getProperty("org.netbeans.ProxyClassLoader.level") != null;
        LOG_LOADING = bl || LOGGER.isLoggable(Level.FINE);
        packageCoverage = new HashMap<String, Set<ProxyClassLoader>>();
        sclPackages = Collections.synchronizedMap(new HashMap());
        arbitraryLoadWarnings = Collections.synchronizedSet(new HashSet());
    }
}

