/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.Transport;
import com.sun.tools.jdi.VirtualMachineManagerService;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import sun.jvm.hotspot.jdi.ConnectorImpl;

public class SACoreAttachingConnector
extends ConnectorImpl
implements AttachingConnector {
    static final String ARG_COREFILE = "core";
    static final String ARG_JAVA_EXECUTABLE = "javaExecutable";
    private Transport transport;

    public SACoreAttachingConnector(VirtualMachineManagerService ignored) {
        this();
    }

    public SACoreAttachingConnector() {
        this.addStringArgument(ARG_JAVA_EXECUTABLE, "Java Executable", "Pathname of Java Executable", "", true);
        this.addStringArgument(ARG_COREFILE, "Corefile", "Pathname of a corefile from a Java Process", ARG_COREFILE, false);
        this.transport = new Transport(){

            public String name() {
                return "filesystem";
            }
        };
    }

    private void checkCoreAttach(String corefile) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                this.checkNativeLink(sm, System.getProperty("os.name"));
                sm.checkRead(corefile);
            }
            catch (SecurityException se) {
                throw new SecurityException("permission denied to attach to " + corefile);
            }
        }
    }

    private VirtualMachine createVirtualMachine(Class vmImplClass, String javaExec, String corefile) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method connectByCoreMethod = vmImplClass.getMethod("createVirtualMachineForCorefile", VirtualMachineManager.class, String.class, String.class, Integer.TYPE);
        return (VirtualMachine)connectByCoreMethod.invoke(null, Bootstrap.virtualMachineManager(), javaExec, corefile, new Integer(0));
    }

    public VirtualMachine attach(Map arguments) throws IOException, IllegalConnectorArgumentsException {
        String javaExec = this.argument(ARG_JAVA_EXECUTABLE, arguments).value();
        if (javaExec == null || javaExec.equals("")) {
            throw new IllegalConnectorArgumentsException("javaExec should be non-null and non-empty", ARG_JAVA_EXECUTABLE);
        }
        String corefile = this.argument(ARG_COREFILE, arguments).value();
        if (corefile == null || corefile.equals("")) {
            throw new IllegalConnectorArgumentsException("corefile should be non-null and non-empty", ARG_COREFILE);
        }
        this.checkCoreAttach(corefile);
        VirtualMachine myVM = null;
        try {
            try {
                Class vmImplClass = SACoreAttachingConnector.loadVirtualMachineImplClass();
                myVM = this.createVirtualMachine(vmImplClass, javaExec, corefile);
            }
            catch (InvocationTargetException ite) {
                Class vmImplClass = SACoreAttachingConnector.handleVMVersionMismatch(ite);
                if (vmImplClass != null) {
                    return this.createVirtualMachine(vmImplClass, javaExec, corefile);
                }
                throw ite;
            }
        }
        catch (Exception ee) {
            if (DEBUG) {
                System.out.println("VirtualMachineImpl() got an exception:");
                ee.printStackTrace();
                System.out.println("coreFile = " + corefile + ", javaExec = " + javaExec);
            }
            throw (IOException)new IOException().initCause(ee);
        }
        SACoreAttachingConnector.setVMDisposeObserver(myVM);
        return myVM;
    }

    public String name() {
        return "sun.jvm.hotspot.jdi.SACoreAttachingConnector";
    }

    public String description() {
        return this.getString("This connector allows you to attach to a core file using the Serviceability Agent");
    }

    public Transport transport() {
        return this.transport;
    }
}

