/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.RTLDataTypes;
import sun.jvm.hotspot.asm.sparc.RegisterDecoder;
import sun.jvm.hotspot.asm.sparc.SPARCFloatRegister;
import sun.jvm.hotspot.asm.sparc.SPARCInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCV9InstructionFactory;
import sun.jvm.hotspot.asm.sparc.V9CMoveDecoder;

class V9FMOVccDecoder
extends V9CMoveDecoder
implements RTLDataTypes {
    private final int opf;
    private final int dataType;

    V9FMOVccDecoder(int opf, int dataType) {
        this.opf = opf;
        this.dataType = dataType;
    }

    private static String getFMoveCCName(int conditionCode, int conditionFlag, int dataType) {
        StringBuffer buf = new StringBuffer("fmov");
        buf.append(V9FMOVccDecoder.getFloatTypeCode(dataType));
        buf.append(V9FMOVccDecoder.getConditionName(conditionCode, conditionFlag));
        return buf.toString();
    }

    private static int getFMoveConditionFlag(int instruction) {
        return (instruction & 0x3800) >>> 11;
    }

    Instruction decode(int instruction, SPARCInstructionFactory factory) {
        SPARCV9InstructionFactory v9factory = (SPARCV9InstructionFactory)factory;
        SPARCInstruction instr = null;
        int conditionFlag = V9FMOVccDecoder.getFMoveConditionFlag(instruction);
        if (conditionFlag == 5 || conditionFlag == 7) {
            instr = v9factory.newIllegalInstruction(instruction);
        } else {
            int rdNum = V9FMOVccDecoder.getDestinationRegister(instruction);
            int rs1Num = V9FMOVccDecoder.getSourceRegister1(instruction);
            SPARCRegister rd = RegisterDecoder.decode(this.dataType, rdNum);
            int conditionCode = V9FMOVccDecoder.getMoveConditionCode(instruction);
            SPARCRegister rs = RegisterDecoder.decode(this.dataType, rs1Num);
            String name = V9FMOVccDecoder.getFMoveCCName(conditionCode, conditionFlag, this.dataType);
            instr = v9factory.newV9FMOVccInstruction(name, this.opf, conditionCode, conditionFlag, (SPARCFloatRegister)rs, (SPARCFloatRegister)rd);
        }
        return instr;
    }
}

