/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCV9SpecialRegisterInstruction;
import sun.jvm.hotspot.utilities.Assert;

public class SPARCV9ReadInstruction
extends SPARCV9SpecialRegisterInstruction {
    private final int specialReg;
    private final int asrRegNum;
    private final SPARCRegister rd;

    public SPARCV9ReadInstruction(int specialReg, int asrRegNum, SPARCRegister rd) {
        super("rd");
        this.specialReg = specialReg;
        this.asrRegNum = asrRegNum;
        this.rd = rd;
    }

    public int getSpecialRegister() {
        return this.specialReg;
    }

    public int getAncillaryRegister() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.specialReg == 7, "not an ancillary register");
        }
        return this.asrRegNum;
    }

    protected String getDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        if (this.specialReg == 7) {
            buf.append("%asr" + this.asrRegNum);
        } else {
            buf.append(SPARCV9ReadInstruction.getSpecialRegisterName(this.specialReg));
        }
        buf.append(comma);
        buf.append(this.rd.toString());
        return buf.toString();
    }
}

