/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.ListenerList;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

class FCLSupport {
    ListenerList<FileChangeListener> listeners;
    private static RequestProcessor RP = new RequestProcessor("Async FileEvent dispatcher", 1, false, false);
    private static final Queue<DispatchEventWrapper> q = new ConcurrentLinkedQueue<DispatchEventWrapper>();
    private static RequestProcessor.Task task = RP.create(new Runnable(){

        @Override
        public void run() {
            DispatchEventWrapper dispatchEventWrapper = (DispatchEventWrapper)q.poll();
            HashSet<Runnable> hashSet = new HashSet<Runnable>();
            while (dispatchEventWrapper != null) {
                dispatchEventWrapper.dispatchEvent(false, hashSet);
                dispatchEventWrapper = (DispatchEventWrapper)q.poll();
            }
            for (Runnable runnable : hashSet) {
                runnable.run();
            }
        }
    });

    FCLSupport() {
    }

    final synchronized void addFileChangeListener(FileChangeListener fileChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add(fileChangeListener);
    }

    final synchronized void removeFileChangeListener(FileChangeListener fileChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(fileChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispatchEvent(FileEvent fileEvent, Op op, Collection<Runnable> collection) {
        List<FileChangeListener> list;
        FCLSupport fCLSupport = this;
        synchronized (fCLSupport) {
            if (this.listeners == null) {
                return;
            }
            list = this.listeners.getAllListeners();
        }
        for (FileChangeListener fileChangeListener : list) {
            FCLSupport.dispatchEvent(fileChangeListener, fileEvent, op, collection);
        }
    }

    static final void dispatchEvent(FileChangeListener fileChangeListener, FileEvent fileEvent, Op op, Collection<Runnable> collection) {
        boolean bl = fileEvent.isAsynchronous();
        DispatchEventWrapper dispatchEventWrapper = new DispatchEventWrapper(fileChangeListener, fileEvent, op);
        dispatchEventWrapper.dispatchEvent(bl, collection);
    }

    final synchronized boolean hasListeners() {
        return this.listeners != null && this.listeners.hasListeners();
    }

    private static class DispatchEventWrapper {
        final FileChangeListener fcl;
        final FileEvent fe;
        final Op operation;

        DispatchEventWrapper(FileChangeListener fileChangeListener, FileEvent fileEvent, Op op) {
            this.fcl = fileChangeListener;
            this.fe = fileEvent;
            this.operation = op;
        }

        void dispatchEvent(boolean bl, Collection<Runnable> collection) {
            if (bl) {
                q.offer(this);
                task.schedule(300);
            } else {
                this.dispatchEventImpl(this.fcl, this.fe, this.operation, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void dispatchEventImpl(FileChangeListener fileChangeListener, FileEvent fileEvent, Op op, Collection<Runnable> collection) {
            try {
                if (collection != null) {
                    fileEvent.setPostNotify(collection);
                }
                switch (op) {
                    case DATA_CREATED: {
                        fileChangeListener.fileDataCreated(fileEvent);
                        return;
                    }
                    case FOLDER_CREATED: {
                        fileChangeListener.fileFolderCreated(fileEvent);
                        return;
                    }
                    case FILE_CHANGED: {
                        fileChangeListener.fileChanged(fileEvent);
                        return;
                    }
                    case FILE_DELETED: {
                        fileChangeListener.fileDeleted(fileEvent);
                        return;
                    }
                    case FILE_RENAMED: {
                        fileChangeListener.fileRenamed((FileRenameEvent)fileEvent);
                        return;
                    }
                    case ATTR_CHANGED: {
                        fileChangeListener.fileAttributeChanged((FileAttributeEvent)fileEvent);
                        return;
                    }
                    default: {
                        throw new AssertionError((Object)op);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                Exceptions.printStackTrace((Throwable)runtimeException);
                return;
            }
            finally {
                if (collection != null) {
                    fileEvent.setPostNotify(null);
                }
            }
        }
    }

    static enum Op {
        DATA_CREATED,
        FOLDER_CREATED,
        FILE_CHANGED,
        FILE_DELETED,
        FILE_RENAMED,
        ATTR_CHANGED;

    }
}

