/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.StreamPool;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;

final class AbstractFileObject
extends AbstractFolder {
    static final long serialVersionUID = -2343651324897646809L;
    private static final char EXT_SEP = '.';
    private static final char PATH_SEP = '/';
    private Reference<FileLock> lock;
    private Boolean folder;
    private Date lastModified = this.lastModified();

    public AbstractFileObject(AbstractFileSystem abstractFileSystem, AbstractFileObject abstractFileObject, String string) {
        super(abstractFileSystem, abstractFileObject, string);
    }

    private boolean initLastModified(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = bl || this.getLastModified() == null;
        if (bl2) {
            this.putLastModified(this.getAbstractFileSystem().info.lastModified(this.getPath()));
        }
        return bl2;
    }

    private synchronized Date getLastModified() {
        return this.lastModified;
    }

    private synchronized Date putLastModified(Date date) {
        this.lastModified = date;
        return this.lastModified;
    }

    private AbstractFileSystem getAbstractFileSystem() {
        return (AbstractFileSystem)this.getFileSystem();
    }

    private AbstractFileObject getAbstractChild(String string) {
        return (AbstractFileObject)this.getChild(string);
    }

    @Override
    protected final String[] list() {
        return this.getAbstractFileSystem().list.children(this.getPath());
    }

    @Override
    protected final AbstractFolder createFile(String string) {
        return this.getAbstractFileSystem().createFileObject(this, string);
    }

    @Override
    public boolean isFolder() {
        if (this.folder == null) {
            if (this.parent == null || this.getAbstractFileSystem().info.folder(this.getPath())) {
                this.folder = Boolean.TRUE;
                return true;
            }
            this.folder = Boolean.FALSE;
            return false;
        }
        return this.folder;
    }

    @Override
    public final boolean isData() {
        return !this.isFolder();
    }

    @Override
    public Date lastModified() {
        this.initLastModified(!this.getAbstractFileSystem().isLastModifiedCacheEnabled());
        return this.getLastModified();
    }

    @Override
    @Deprecated
    public boolean isReadOnly() {
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        return abstractFileSystem.isReadOnly() || abstractFileSystem.info.readOnly(this.getPath());
    }

    @Override
    public String getMIMEType() {
        String string = this.getAbstractFileSystem().info.mimeType(this.getPath());
        if (string == null) {
            string = super.getMIMEType();
        }
        return string;
    }

    @Override
    public long getSize() {
        return this.getAbstractFileSystem().info.size(this.getPath());
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return StreamPool.createInputStream(this);
    }

    @Override
    public OutputStream getOutputStream(FileLock fileLock) throws IOException {
        return this.getOutputStream(fileLock, true);
    }

    synchronized OutputStream getOutputStream(FileLock fileLock, boolean bl) throws IOException {
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        if (abstractFileSystem.isReadOnly()) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_FSisRO", (Object)((FileSystem)abstractFileSystem).getDisplayName()));
        }
        if (this.isReadOnly()) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_FisRO", (Object)this.name, (Object)((FileSystem)abstractFileSystem).getDisplayName()));
        }
        this.testLock(fileLock);
        return StreamPool.createOutputStream(this, bl);
    }

    @Override
    public synchronized FileLock lock() throws IOException {
        FileLock fileLock;
        if (this.lock != null && (fileLock = this.lock.get()) != null) {
            throw new FileAlreadyLockedException();
        }
        this.getAbstractFileSystem().info.lock(this.getPath());
        fileLock = new AfLock();
        this.lock = new WeakReference<FileLock>(fileLock);
        return fileLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock(FileLock fileLock) {
        FileLock fileLock2 = null;
        AbstractFileObject abstractFileObject = this;
        synchronized (abstractFileObject) {
            if (this.lock != null) {
                fileLock2 = this.lock.get();
            }
            if (fileLock2 == fileLock) {
                this.putLastModified(null);
                this.lock = null;
            }
        }
        this.getAbstractFileSystem().info.unlock(this.getPath());
        if (this.isValid()) {
            this.lastModified();
        }
    }

    @Override
    public synchronized boolean isLocked() {
        return this.lock != null && this.lock.get() != null;
    }

    private void testLock(FileLock fileLock) throws IOException {
        if (this.lock == null) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_InvalidLock", (Object)fileLock, (Object)this.getPath(), (Object)this.getAbstractFileSystem().getDisplayName(), this.lock, (Object[])new Object[0]));
        }
        if (this.lock.get() != fileLock) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_InvalidLock", (Object)fileLock, (Object)this.getPath(), (Object)this.getAbstractFileSystem().getDisplayName(), (Object)this.lock.get(), (Object[])new Object[0]));
        }
    }

    @Override
    @Deprecated
    public void setImportant(boolean bl) {
        this.getAbstractFileSystem().markImportant(this.getPath(), bl);
    }

    @Override
    public Object getAttribute(String string) {
        return this.getAttribute(string, this.getPath());
    }

    final Object getAttribute(String string, String string2) {
        return this.getAbstractFileSystem().attr.readAttribute(string2, string);
    }

    @Override
    public void setAttribute(String string, Object object) throws IOException {
        this.setAttribute(string, object, true);
    }

    @Override
    void setAttribute(String string, Object object, boolean bl) throws IOException {
        Object object2 = null;
        if (bl) {
            object2 = this.getAttribute(string);
        }
        this.getAbstractFileSystem().attr.writeAttribute(this.getPath(), string, object);
        if (bl && object2 != object && this.hasAtLeastOneListeners()) {
            this.fileAttributeChanged0(new FileAttributeEvent(this, string, object2, object));
        }
    }

    @Override
    public Enumeration<String> getAttributes() {
        return this.getAttributes(this.getPath());
    }

    final Enumeration<String> getAttributes(String string) {
        return this.getAbstractFileSystem().attr.attributes(string);
    }

    @Override
    protected final Reference<AbstractFolder> createReference(AbstractFolder abstractFolder) {
        return this.getAbstractFileSystem().createReference(abstractFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject createFolder(String string) throws IOException {
        AbstractFileObject abstractFileObject;
        if (string.contains("/") || string.contains("\\")) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_SlashNotAllowed", (Object)string));
        }
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFileObject abstractFileObject2 = this;
            synchronized (abstractFileObject2) {
                AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
                if (abstractFileSystem.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_FSisRO", (Object)abstractFileSystem.getDisplayName()));
                }
                if (this.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_FisRO", (Object)string, (Object)abstractFileSystem.getDisplayName()));
                }
                if (!this.isFolder()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_FoNotFolder", (Object)string, (Object)this.getPath(), (Object)abstractFileSystem.getDisplayName()));
                }
                this.getAbstractFileSystem().change.createFolder(this.getPath() + '/' + string);
                this.registerChild(string);
                abstractFileObject = this.getAbstractChild(string);
                if (abstractFileObject == null) {
                    throw new FileStateInvalidException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_ApplicationCreateError", (Object)this.getPath(), (Object)string));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(this, abstractFileObject), false);
                }
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
        return abstractFileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject createData(String string, String string2) throws IOException {
        if (string.indexOf(47) != -1) {
            throw new IllegalArgumentException("Use FileUtil.createData() instead!");
        }
        String string3 = null;
        try {
            Serializable serializable;
            this.getFileSystem().beginAtomicAction();
            String string4 = null;
            AbstractFileObject abstractFileObject = this;
            synchronized (abstractFileObject) {
                serializable = this.getAbstractFileSystem();
                if (serializable.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_FSisRO", (Object)serializable.getDisplayName()));
                }
                if (this.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_FisRO", (Object)string, (Object)serializable.getDisplayName()));
                }
                String string5 = string4 = string2 == null || "".equals(string2) ? string : string + '.' + string2;
                if (!this.isFolder()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_FoNotFolder", (Object)string4, (Object)this.getPath(), (Object)serializable.getDisplayName()));
                }
                string3 = this.getPath() + '/' + string4;
            }
            this.getAbstractFileSystem().change.createData(string3);
            abstractFileObject = this;
            synchronized (abstractFileObject) {
                this.registerChild(string4);
                serializable = this.getAbstractChild(string4);
                if (serializable == null) {
                    throw new FileStateInvalidException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_ApplicationCreateError", (Object)this.getPath(), (Object)string4));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(this, (FileObject)serializable), true);
                }
                Serializable serializable2 = serializable;
                return serializable2;
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(FileLock fileLock, String string, String string2) throws IOException {
        if (this.parent == null) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_CannotRenameRoot", (Object)this.getAbstractFileSystem().getDisplayName()));
        }
        if (string.indexOf(47) != -1 || string2 != null && string2.indexOf(47) != -1 || string.indexOf(92) != -1 || string2 != null && string2.indexOf(92) != -1) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_CannotRename", (Object)this.getPath(), (Object)this.getAbstractFileSystem().getDisplayName(), (Object)(string + "." + string2)));
        }
        try {
            this.getFileSystem().beginAtomicAction();
            String string3 = null;
            String string4 = null;
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                this.testLock(fileLock);
                if (this.isData() && string2 != null && string2.trim().length() > 0) {
                    string = string + '.' + string2;
                }
                string3 = this.parent.isRoot() ? string : this.parent.getPath() + '/' + string;
                string4 = this.getPath();
                if (this.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_CannotRename", (Object)this.getPath(), (Object)this.getAbstractFileSystem().getDisplayName(), (Object)string3));
                }
                if (this.getFileSystem().isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_FSisRO", (Object)this.getAbstractFileSystem().getDisplayName()));
                }
                String string5 = this.getName();
                String string6 = this.getExt();
                this.getAbstractFileSystem().change.rename(string4, string3);
                String string7 = this.name;
                this.name = string;
                this.parent.refresh(string, string7);
                if (this.hasAtLeastOneListeners()) {
                    this.fileRenamed0(new FileRenameEvent((FileObject)this, string5, string6));
                }
            }
            this.getAbstractFileSystem().attr.renameAttributes(string4, string3);
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleDelete(FileLock fileLock) throws IOException {
        if (this.parent == null) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_CannotDeleteRoot", (Object)this.getAbstractFileSystem().getDisplayName()));
        }
        try {
            String string;
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                this.testLock(fileLock);
                string = this.getPath();
                try {
                    this.getAbstractFileSystem().change.delete(string);
                }
                catch (IOException iOException) {
                    StreamPool streamPool = StreamPool.find(this);
                    if (streamPool != null) {
                        streamPool.annotate(iOException);
                    }
                    throw iOException;
                }
                String string2 = this.name;
                this.validFlag = false;
                this.parent.refresh(null, string2, true);
            }
            this.getAbstractFileSystem().attr.deleteAttributes(string);
            if (this.hasAtLeastOneListeners()) {
                this.fileDeleted0(new FileEvent(this));
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
        AbstractFileSystem.Transfer transfer = this.getAbstractFileSystem().transfer;
        if (transfer == null || !(fileObject instanceof AbstractFileObject)) {
            return super.copy(fileObject, string, string2);
        }
        AbstractFileObject abstractFileObject = (AbstractFileObject)fileObject;
        AbstractFileSystem abstractFileSystem = abstractFileObject.getAbstractFileSystem();
        AbstractFileSystem.Transfer transfer2 = abstractFileSystem.transfer;
        if (transfer2 != null) {
            try {
                this.getFileSystem().beginAtomicAction();
                AbstractFileObject abstractFileObject2 = abstractFileObject;
                synchronized (abstractFileObject2) {
                    block14: {
                        String string3;
                        if (abstractFileSystem.isReadOnly()) {
                            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_FSisRO", (Object)abstractFileSystem.getDisplayName()));
                        }
                        if (!fileObject.canWrite()) {
                            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_FisRO", (Object)fileObject.getPath(), (Object)abstractFileSystem.getDisplayName()));
                        }
                        String string4 = string3 = "".equals(string2) ? string : string + '.' + string2;
                        if (!transfer.copy(this.getPath(), transfer2, fileObject.getPath() + '/' + string3)) break block14;
                        abstractFileObject.registerChild(string3);
                        AbstractFileObject abstractFileObject3 = abstractFileObject.getAbstractChild(string3);
                        if (abstractFileObject3 == null) {
                            throw new FileStateInvalidException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_ApplicationCreateError", (Object)abstractFileObject.getPath(), (Object)string3));
                        }
                        if (abstractFileObject.hasListeners()) {
                            abstractFileObject.fileCreated0(new FileEvent(abstractFileObject, abstractFileObject3), true);
                        }
                        AbstractFileObject abstractFileObject4 = abstractFileObject3;
                        return abstractFileObject4;
                    }
                }
            }
            finally {
                this.getFileSystem().finishAtomicAction();
            }
        }
        return super.copy(fileObject, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        if (this.parent == null) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_CannotDeleteRoot", (Object)abstractFileSystem.getDisplayName()));
        }
        AbstractFileSystem.Transfer transfer = this.getAbstractFileSystem().transfer;
        if (transfer == null || !(fileObject instanceof AbstractFileObject)) {
            return super.move(fileLock, fileObject, string, string2);
        }
        AbstractFileObject abstractFileObject = (AbstractFileObject)fileObject;
        AbstractFileSystem abstractFileSystem2 = abstractFileObject.getAbstractFileSystem();
        AbstractFileSystem.Transfer transfer2 = abstractFileSystem2.transfer;
        if (transfer2 != null) {
            try {
                this.getFileSystem().beginAtomicAction();
                AbstractFolder abstractFolder = this.parent;
                synchronized (abstractFolder) {
                    block16: {
                        this.testLock(fileLock);
                        if (abstractFileSystem2.isReadOnly()) {
                            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_FSisRO", (Object)abstractFileSystem2.getDisplayName()));
                        }
                        if (!fileObject.canWrite()) {
                            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_FisRO", (Object)fileObject.getPath(), (Object)abstractFileSystem2.getDisplayName()));
                        }
                        String string3 = "".equals(string2) ? string : string + '.' + string2;
                        String string4 = this.getPath();
                        if (!transfer.move(string4, transfer2, fileObject.getPath() + '/' + string3)) break block16;
                        String string5 = string;
                        this.validFlag = false;
                        this.parent.refresh(null, string5);
                        abstractFileObject.registerChild(string3);
                        AbstractFileObject abstractFileObject2 = abstractFileObject.getAbstractChild(string3);
                        if (abstractFileObject2 == null) {
                            throw new FileStateInvalidException(NbBundle.getMessage(AbstractFileObject.class, (String)"EXC_ApplicationCreateError", (Object)abstractFileObject.getPath(), (Object)string3));
                        }
                        if (this.hasAtLeastOneListeners()) {
                            this.fileDeleted0(new FileEvent(this));
                        }
                        if (abstractFileObject.hasListeners()) {
                            abstractFileObject.fileCreated0(new FileEvent(abstractFileObject, abstractFileObject2), true);
                        }
                        AbstractFileObject abstractFileObject3 = abstractFileObject2;
                        return abstractFileObject3;
                    }
                }
            }
            finally {
                this.getFileSystem().finishAtomicAction();
            }
        }
        return super.move(fileLock, fileObject, string, string2);
    }

    @Override
    public boolean isVirtual() {
        return this.getAbstractFileSystem().checkVirtual(this.getPath());
    }

    @Override
    protected void refresh(String string, String string2, boolean bl, boolean bl2) {
        this.refresh(string, string2, bl, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refresh(String string, String string2, boolean bl, boolean bl2, String[] stringArray) {
        FileEvent fileEvent = null;
        boolean bl3 = false;
        try {
            this.getFileSystem().beginAtomicAction();
            if (this.isFolder()) {
                super.refresh(string, string2, bl, bl2, stringArray);
            } else {
                StreamPool streamPool = StreamPool.find(this);
                if (streamPool != null && streamPool.isOutputStreamOpen()) {
                    return;
                }
                AbstractFileObject abstractFileObject = this;
                synchronized (abstractFileObject) {
                    Date date;
                    block20: {
                        date = null;
                        boolean bl4 = this.initLastModified(false);
                        if (!bl4) break block20;
                        return;
                    }
                    date = this.getAbstractFileSystem().info.lastModified(this.getPath());
                    if (Math.abs(this.getLastModified().getTime() - date.getTime()) != 0L) {
                        this.putLastModified(date);
                        if (bl && this.hasAtLeastOneListeners()) {
                            fileEvent = new FileEvent((FileObject)this, (FileObject)this, bl2);
                        }
                        if (date.getTime() == 0L) {
                            if (this.validFlag) {
                                this.validFlag = false;
                                if (fileEvent != null) {
                                    this.fileDeleted0(fileEvent);
                                }
                                bl3 = true;
                            }
                        } else if (fileEvent != null) {
                            this.fileChanged0(fileEvent);
                        }
                    }
                }
            }
            if (bl3 && this.parent.getFileObject(this.getName(), this.getExt()) != null) {
                this.parent.refreshFolder(null, this.getNameExt(), bl, bl2, null);
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void outputStreamClosed(boolean bl) {
        AbstractFileObject abstractFileObject = this;
        synchronized (abstractFileObject) {
            this.putLastModified(null);
            this.lastModified();
        }
        super.outputStreamClosed(bl);
    }

    @Override
    public boolean canWrite() {
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        return abstractFileSystem.canWrite(this.getPath());
    }

    @Override
    public boolean canRead() {
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        return abstractFileSystem.canRead(this.getPath());
    }

    final boolean superCanWrite() {
        return super.canWrite();
    }

    final boolean superCanRead() {
        return super.canRead();
    }

    @Deprecated
    static final class Replace
    implements Serializable {
        static final long serialVersionUID = -8543432135435542113L;
        private String fsName;
        private String fileName;

        public Replace(String string, String string2) {
            this.fsName = string;
            this.fileName = string2;
        }

        public Object readResolve() {
            Repository repository = Repository.getDefault();
            FileSystem fileSystem = repository.findFileSystem(this.fsName);
            FileObject fileObject = null;
            if (fileSystem != null) {
                fileObject = fileSystem.findResource(this.fileName);
            }
            if (fileObject == null) {
                return new Invalid(this.fsName, this.fileName);
            }
            return fileObject;
        }
    }

    static final class Invalid
    extends FileObject {
        static final long serialVersionUID = -4558997829579415276L;
        private static final Invalid ROOT = new Invalid("");
        private String name;
        private String fileSystemName;

        public Invalid(String string) {
            int n = string.lastIndexOf(47) + 1;
            this.name = n == 0 || n == string.length() ? string : string.substring(n);
        }

        public Invalid(String string, String string2) {
            this(string2);
            this.fileSystemName = string;
        }

        @Override
        public String getName() {
            int n = this.name.lastIndexOf(46);
            return n <= 0 ? this.name : this.name.substring(0, n);
        }

        @Override
        public String getExt() {
            int n = this.name.lastIndexOf(46) + 1;
            return n <= 1 || n == this.name.length() ? "" : this.name.substring(n);
        }

        @Override
        public FileSystem getFileSystem() throws FileStateInvalidException {
            throw new FileStateInvalidException(null, this.name + "[" + this.fileSystemName + "]");
        }

        @Override
        public boolean isRoot() {
            return this == ROOT;
        }

        @Override
        public boolean isFolder() {
            return this == ROOT;
        }

        @Override
        public Date lastModified() {
            return new Date();
        }

        @Override
        public boolean isData() {
            return false;
        }

        @Override
        @Deprecated
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public String getMIMEType() {
            return "content/unknown";
        }

        @Override
        public long getSize() {
            return 0L;
        }

        @Override
        public InputStream getInputStream() throws FileNotFoundException {
            throw new FileNotFoundException();
        }

        @Override
        public synchronized OutputStream getOutputStream(FileLock fileLock) throws IOException {
            throw new IOException();
        }

        @Override
        public synchronized FileLock lock() throws IOException {
            throw new IOException();
        }

        @Override
        @Deprecated
        public void setImportant(boolean bl) {
        }

        @Override
        public Object getAttribute(String string) {
            return null;
        }

        @Override
        public void setAttribute(String string, Object object) throws IOException {
            throw new IOException();
        }

        @Override
        public Enumeration<String> getAttributes() {
            return Enumerations.empty();
        }

        @Override
        public synchronized FileObject createFolder(String string) throws IOException {
            throw new IOException();
        }

        @Override
        public synchronized FileObject createData(String string, String string2) throws IOException {
            throw new IOException();
        }

        @Override
        public void rename(FileLock fileLock, String string, String string2) throws IOException {
            throw new IOException();
        }

        @Override
        public void delete(FileLock fileLock) throws IOException {
            throw new IOException();
        }

        @Override
        public FileObject getParent() {
            return this == ROOT ? null : ROOT;
        }

        @Override
        public synchronized FileObject[] getChildren() {
            return new FileObject[0];
        }

        @Override
        public synchronized FileObject getFileObject(String string, String string2) {
            return null;
        }

        @Override
        public void refresh() {
        }

        @Override
        public void addFileChangeListener(FileChangeListener fileChangeListener) {
        }

        @Override
        public void removeFileChangeListener(FileChangeListener fileChangeListener) {
        }
    }

    private class AfLock
    extends FileLock {
        AfLock() {
        }

        @Override
        public void releaseLock() {
            if (this.isValid()) {
                super.releaseLock();
                AbstractFileObject.this.unlock(this);
            }
        }
    }
}

