/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import javax.swing.event.EventListenerList;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;

public abstract class ExClipboard
extends Clipboard {
    private EventListenerList listeners = new EventListenerList();

    public ExClipboard(String string) {
        super(string);
    }

    public final void addClipboardListener(ClipboardListener clipboardListener) {
        this.listeners.add(ClipboardListener.class, clipboardListener);
    }

    public final void removeClipboardListener(ClipboardListener clipboardListener) {
        this.listeners.remove(ClipboardListener.class, clipboardListener);
    }

    protected final void fireClipboardChange() {
        Object[] objectArray = this.listeners.getListenerList();
        ClipboardEvent clipboardEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            ClipboardListener clipboardListener = (ClipboardListener)objectArray[i + 1];
            if (clipboardEvent == null) {
                clipboardEvent = new ClipboardEvent(this);
            }
            clipboardListener.clipboardChanged(clipboardEvent);
        }
    }

    protected abstract Convertor[] getConvertors();

    public Transferable convert(Transferable transferable) {
        Convertor[] convertorArray = this.getConvertors();
        for (int i = 0; i < convertorArray.length; ++i) {
            if (transferable == null) {
                return null;
            }
            transferable = convertorArray[i].convert(transferable);
        }
        return transferable;
    }

    public static void transferableAccepted(Transferable transferable, int n) {
        if (transferable instanceof ExTransferable) {
            ((ExTransferable)transferable).fireAccepted(n);
        } else if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                int n2 = multiTransferObject.getCount();
                for (int i = 0; i < n2; ++i) {
                    ExClipboard.transferableAccepted(multiTransferObject.getTransferableAt(i), n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void transferableRejected(Transferable transferable) {
        if (transferable instanceof ExTransferable) {
            ((ExTransferable)transferable).fireRejected();
        } else if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                int n = multiTransferObject.getCount();
                for (int i = 0; i < n; ++i) {
                    ExClipboard.transferableRejected(multiTransferObject.getTransferableAt(i));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        if (this.contents != null) {
            ExClipboard.transferableOwnershipLost(this.contents);
        }
        super.setContents(transferable, clipboardOwner);
    }

    public static void transferableOwnershipLost(Transferable transferable) {
        if (transferable instanceof ExTransferable) {
            ((ExTransferable)transferable).fireOwnershipLost();
        } else if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                int n = multiTransferObject.getCount();
                for (int i = 0; i < n; ++i) {
                    ExClipboard.transferableOwnershipLost(multiTransferObject.getTransferableAt(i));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface Convertor {
        public Transferable convert(Transferable var1);
    }
}

