/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.util.VersionID;

public class SecurityBaseline {
    private static final String BASELINE_VERSION_131 = "1.3.1_21";
    private static final String BASELINE_VERSION_142 = "1.4.2_43";
    private static final String BASELINE_VERSION_150 = "1.5.0_45";
    private static final String BASELINE_VERSION_160 = "1.6.0_45";
    private static final String CURRENT_VERSION = "1.6.0_45";
    private static final String CURRENT_NODOT_VERSION = "160_45";

    private static String getBaselineVersion131() {
        return BASELINE_VERSION_131;
    }

    private static String getBaselineVersion142() {
        return BASELINE_VERSION_142;
    }

    private static String getBaselineVersion150() {
        return BASELINE_VERSION_150;
    }

    private static String getBaselineVersion160() {
        return "1.6.0_45";
    }

    private static String getBaselineVersion(String string) {
        if (string.startsWith("1.3.1")) {
            return SecurityBaseline.getBaselineVersion131();
        }
        if (string.startsWith("1.4.2")) {
            return SecurityBaseline.getBaselineVersion142();
        }
        if (string.startsWith("1.5")) {
            return SecurityBaseline.getBaselineVersion150();
        }
        if (string.startsWith("1.6")) {
            return SecurityBaseline.getBaselineVersion160();
        }
        return "1.6.0_45";
    }

    public static boolean satisfiesSecurityBaseline(String string) {
        VersionID versionID = new VersionID(string);
        VersionID versionID2 = new VersionID(SecurityBaseline.getBaselineVersion(string));
        return versionID.isGreaterThanOrEqual(versionID2);
    }

    public static String getCurrentVersion() {
        return "1.6.0_45";
    }

    public static String getCurrentNoDotVersion() {
        return CURRENT_NODOT_VERSION;
    }
}

