/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import sun.tools.jconsole.InternalDialog;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMInternalFrame;
import sun.tools.jconsole.VMPanel;
import sun.tools.jconsole.VariableGridLayout;

public class CreateMBeanDialog
extends InternalDialog
implements ActionListener {
    JConsole jConsole;
    JComboBox connections;
    JButton createMBeanButton;
    JButton unregisterMBeanButton;
    JButton cancelButton;
    private static final String HOTSPOT_MBEAN = "sun.management.HotspotInternal";
    private static final String HOTSPOT_MBEAN_OBJECTNAME = "sun.management:type=HotspotInternal";

    public CreateMBeanDialog(JConsole jConsole) {
        super(jConsole, "JConsole: Hotspot MBeans", true);
        this.jConsole = jConsole;
        Utilities.setAccessibleDescription(this, Resources.getText("Hotspot MBeans.dialog.accessibleDescription", new Object[0]));
        Container container = this.getContentPane();
        ((JComponent)container).setBorder(new EmptyBorder(10, 10, 4, 10));
        JPanel jPanel = new JPanel(new VariableGridLayout(0, 1, 4, 4, false, true));
        container.add((Component)jPanel, "Center");
        this.connections = new JComboBox();
        this.updateConnections();
        jPanel.add(new LabeledComponent(Resources.getText("Manage Hotspot MBeans in: ", new Object[0]), this.connections));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        container.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, "North");
        this.createMBeanButton = new JButton(Resources.getText("Create", new Object[0]));
        jPanel3.add(this.createMBeanButton);
        this.unregisterMBeanButton = new JButton(Resources.getText("Unregister", new Object[0]));
        jPanel3.add(this.unregisterMBeanButton);
        this.cancelButton = new JButton(Resources.getText("Cancel", new Object[0]));
        jPanel3.add(this.cancelButton);
        this.statusBar = new JLabel(" ", 0);
        jPanel2.add((Component)this.statusBar, "South");
        this.createMBeanButton.addActionListener(this);
        this.unregisterMBeanButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        LabeledComponent.layout(jPanel);
        this.pack();
        this.setLocationRelativeTo(jConsole);
    }

    private void updateConnections() {
        List<VMInternalFrame> list = this.jConsole.getInternalFrames();
        TreeSet<ProxyClient> treeSet = new TreeSet<ProxyClient>(new Comparator<ProxyClient>(){

            @Override
            public int compare(ProxyClient proxyClient, ProxyClient proxyClient2) {
                return proxyClient.connectionName().compareTo(proxyClient2.connectionName());
            }
        });
        if (list.size() == 0) {
            VMPanel vMPanel;
            ProxyClient proxyClient;
            JComponent jComponent = (JComponent)this.jConsole.getContentPane();
            Component component = ((BorderLayout)jComponent.getLayout()).getLayoutComponent("Center");
            if (component instanceof VMPanel && (proxyClient = (vMPanel = (VMPanel)component).getProxyClient(false)) != null && proxyClient.hasPlatformMXBeans()) {
                treeSet.add(proxyClient);
            }
        } else {
            for (VMInternalFrame vMInternalFrame : list) {
                ProxyClient proxyClient = vMInternalFrame.getVMPanel().getProxyClient(false);
                if (proxyClient == null || !proxyClient.hasPlatformMXBeans()) continue;
                treeSet.add(proxyClient);
            }
        }
        this.connections.invalidate();
        this.connections.setModel(new DefaultComboBoxModel<Object>(treeSet.toArray()));
        this.connections.validate();
    }

    public void actionPerformed(final ActionEvent actionEvent) {
        this.setVisible(false);
        this.statusBar.setText("");
        if (actionEvent.getSource() != this.cancelButton) {
            new Thread("CreateMBeanDialog.actionPerformed"){

                public void run() {
                    try {
                        Object var1_1 = null;
                        Object object = CreateMBeanDialog.this.connections.getSelectedItem();
                        if (object == null) {
                            return;
                        }
                        if (actionEvent.getSource() == CreateMBeanDialog.this.createMBeanButton) {
                            MBeanServerConnection mBeanServerConnection = ((ProxyClient)object).getMBeanServerConnection();
                            mBeanServerConnection.createMBean(CreateMBeanDialog.HOTSPOT_MBEAN, null);
                        } else if (actionEvent.getSource() == CreateMBeanDialog.this.unregisterMBeanButton) {
                            MBeanServerConnection mBeanServerConnection = ((ProxyClient)object).getMBeanServerConnection();
                            mBeanServerConnection.unregisterMBean(new ObjectName(CreateMBeanDialog.HOTSPOT_MBEAN_OBJECTNAME));
                        }
                        return;
                    }
                    catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                        CreateMBeanDialog.this.statusBar.setText(Resources.getText("Error: MBeans already exist", new Object[0]));
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        CreateMBeanDialog.this.statusBar.setText(Resources.getText("Error: MBeans do not exist", new Object[0]));
                    }
                    catch (Exception exception) {
                        CreateMBeanDialog.this.statusBar.setText(exception.toString());
                    }
                    CreateMBeanDialog.this.setVisible(true);
                }
            }.start();
        }
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        if (bl) {
            this.setLocationRelativeTo(this.jConsole);
            this.invalidate();
            this.updateConnections();
            this.validate();
            this.repaint();
        }
        super.setVisible(bl);
        if (bl && !bl2) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CreateMBeanDialog.this.connections.requestFocus();
                }
            });
        }
    }
}

