/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.children;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.util.Mutex;

public class ChildrenSupport {
    static final int NO_CHILDREN_CACHED = 0;
    static final int SOME_CHILDREN_CACHED = 1;
    static final int ALL_CHILDREN_CACHED = 2;
    private Set<FileNaming> notExistingChildren;
    private Set<FileNaming> existingChildren;
    private int status = 0;
    private static final Mutex.Privileged mutexPrivileged = new Mutex.Privileged();
    private static final Mutex mutex = new Mutex(mutexPrivileged);

    public final Mutex.Privileged getMutexPrivileged() {
        return mutexPrivileged;
    }

    public static boolean isLock() {
        return mutex.isReadAccess() || mutex.isWriteAccess();
    }

    public Set<FileNaming> getCachedChildren() {
        return this.getExisting(false);
    }

    public synchronized Set<FileNaming> getChildren(FileNaming fileNaming, boolean bl) {
        if (bl || !this.isStatus(2)) {
            this.rescanChildren(fileNaming, false);
            this.setStatus(2);
        }
        return this.getExisting(false);
    }

    public boolean isCacheInitialized() {
        return !this.isStatus(0);
    }

    public synchronized FileNaming getChild(String string, FileNaming fileNaming, boolean bl) {
        FileNaming fileNaming2 = null;
        if (bl || this.isStatus(0)) {
            fileNaming2 = this.rescanChild(fileNaming, string, false);
        } else if (this.isStatus(1)) {
            fileNaming2 = this.lookupChildInCache(fileNaming, string, true);
            if (fileNaming2 == null && this.lookupChildInCache(fileNaming, string, false) == null) {
                fileNaming2 = this.rescanChild(fileNaming, string, false);
            }
        } else if (this.isStatus(2)) {
            fileNaming2 = this.lookupChildInCache(fileNaming, string, true);
        }
        this.setStatus(1);
        return fileNaming2;
    }

    public synchronized void removeChild(FileNaming fileNaming, FileNaming fileNaming2) {
        assert (fileNaming2 != null);
        this.getExisting().remove(fileNaming2);
        if (fileNaming2.getParent().equals(fileNaming)) {
            this.getNotExisting().add(fileNaming2);
        }
    }

    private synchronized void addChild(FileNaming fileNaming, FileNaming fileNaming2) {
        assert (fileNaming2 != null);
        assert (fileNaming2.getParent().equals(fileNaming)) : "childName: " + fileNaming2.getFile() + " folderName: " + fileNaming.getFile();
        this.getExisting().add(fileNaming2);
        this.getNotExisting().remove(fileNaming2);
    }

    public synchronized Map<FileNaming, Integer> refresh(FileNaming fileNaming) {
        Map<FileNaming, Integer> map = new HashMap<FileNaming, Integer>();
        HashSet<FileNaming> hashSet = new HashSet<FileNaming>(this.getExisting(false));
        HashSet<FileNaming> hashSet2 = new HashSet<FileNaming>(this.getNotExisting(false));
        if (this.isStatus(1)) {
            FileNaming fileNaming2;
            HashSet<FileNaming> hashSet3 = new HashSet<FileNaming>(hashSet);
            for (FileNaming object2 : hashSet3) {
                fileNaming2 = this.rescanChild(fileNaming, object2.getName(), true);
                if (fileNaming2 != null) continue;
                map.put(object2, ChildrenCache.REMOVED_CHILD);
            }
            HashSet<FileNaming> hashSet4 = new HashSet<FileNaming>(hashSet2);
            Iterator iterator = hashSet4.iterator();
            while (iterator.hasNext()) {
                fileNaming2 = (FileNaming)iterator.next();
                assert (fileNaming2 != null);
                FileNaming fileNaming3 = this.rescanChild(fileNaming, fileNaming2.getName(), true);
                if (fileNaming3 == null) continue;
                map.put(fileNaming2, ChildrenCache.ADDED_CHILD);
            }
        } else if (this.isStatus(2)) {
            map = this.rescanChildren(fileNaming, true);
        }
        return map;
    }

    public String toString() {
        return this.getExisting(false).toString();
    }

    boolean isStatus(int n) {
        return this.status == n;
    }

    private void setStatus(int n) {
        if (this.status < n) {
            this.status = n;
        }
    }

    private FileNaming rescanChild(FileNaming fileNaming, String string, boolean bl) {
        FileNaming fileNaming2;
        File file = fileNaming.getFile();
        File file2 = new File(file, string);
        FileInfo fileInfo = new FileInfo(file2);
        FileNaming fileNaming3 = fileNaming2 = fileInfo.isConvertibleToFileObject() ? NamingFactory.fromFile(fileNaming, file2, bl) : null;
        if (fileNaming2 != null) {
            this.addChild(fileNaming, fileNaming2);
        } else {
            FileName fileName = new FileName(fileNaming, file2){

                @Override
                public boolean isDirectory() {
                    return false;
                }

                @Override
                public boolean isFile() {
                    return false;
                }
            };
            this.removeChild(fileNaming, fileName);
        }
        return fileNaming2;
    }

    private Map<FileNaming, Integer> rescanChildren(FileNaming fileNaming, boolean bl) {
        Object object2;
        IdentityHashMap<FileNaming, Integer> identityHashMap = new IdentityHashMap<FileNaming, Integer>();
        LinkedHashSet<FileNaming> linkedHashSet = new LinkedHashSet<FileNaming>();
        File file = fileNaming.getFile();
        assert (fileNaming.getFile().getAbsolutePath().equals(fileNaming.toString()));
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                object2 = new FileInfo(fileArray[i], 1);
                if (!((FileInfo)object2).isConvertibleToFileObject()) continue;
                FileNaming object3 = NamingFactory.fromFile(fileNaming, fileArray[i], bl);
                linkedHashSet.add(object3);
            }
        } else if (file.exists()) {
            return identityHashMap;
        }
        Set<FileNaming> set = ChildrenSupport.deepMinus(this.getExisting(false), linkedHashSet);
        for (FileNaming fileNaming2 : set) {
            this.removeChild(fileNaming, fileNaming2);
            identityHashMap.put(fileNaming2, ChildrenCache.REMOVED_CHILD);
        }
        object2 = ChildrenSupport.deepMinus(linkedHashSet, this.getExisting(false));
        Iterator<FileNaming> iterator = object2.iterator();
        while (iterator.hasNext()) {
            FileNaming fileNaming3 = iterator.next();
            this.addChild(fileNaming, fileNaming3);
            identityHashMap.put(fileNaming3, ChildrenCache.ADDED_CHILD);
        }
        return identityHashMap;
    }

    private static Set<FileNaming> deepMinus(Set<FileNaming> set, Set<FileNaming> set2) {
        HashMap<FileNaming, FileNaming> hashMap = new HashMap<FileNaming, FileNaming>(set.size() * 2);
        for (FileNaming fileNaming : set) {
            hashMap.put(fileNaming, fileNaming);
        }
        for (FileNaming fileNaming : set2) {
            FileNaming fileNaming2 = (FileNaming)hashMap.remove(fileNaming);
            if (fileNaming2 == null || fileNaming2.isFile() == fileNaming.isFile()) continue;
            hashMap.put(fileNaming2, fileNaming2);
        }
        return hashMap.keySet();
    }

    private FileNaming lookupChildInCache(final FileNaming fileNaming, final String string, boolean bl) {
        Set<FileNaming> set;
        final File file = new File(fileNaming.getFile(), string);
        final Integer n = NamingFactory.createID(file);
        class FakeNaming
        implements FileNaming {
            public FileNaming lastEqual;

            FakeNaming() {
            }

            @Override
            public String getName() {
                return string;
            }

            @Override
            public FileNaming getParent() {
                return fileNaming;
            }

            @Override
            public boolean isRoot() {
                return false;
            }

            @Override
            public File getFile() {
                return file;
            }

            @Override
            public Integer getId() {
                return n;
            }

            @Override
            public FileNaming rename(String string2, ProvidedExtensions.IOHandler iOHandler) {
                throw new IllegalStateException();
            }

            public boolean equals(Object object) {
                if (this.hashCode() == object.hashCode()) {
                    assert (this.lastEqual == null) : "Just one can be there";
                    if (object instanceof FileNaming) {
                        this.lastEqual = (FileNaming)object;
                    }
                    return true;
                }
                return false;
            }

            public int hashCode() {
                return n;
            }

            @Override
            public boolean isFile() {
                return this.getFile().isFile();
            }

            @Override
            public boolean isDirectory() {
                return !this.isFile();
            }
        }
        FakeNaming fakeNaming = new FakeNaming();
        Set<FileNaming> set2 = set = bl ? this.getExisting(false) : this.getNotExisting(false);
        if (set.contains(fakeNaming)) {
            assert (fakeNaming.lastEqual != null) : "If cache contains the object, we set lastEqual";
            return fakeNaming.lastEqual;
        }
        return null;
    }

    private synchronized Set<FileNaming> getExisting() {
        return this.getExisting(true);
    }

    private synchronized Set<FileNaming> getExisting(boolean bl) {
        if (bl && this.existingChildren == null) {
            this.existingChildren = new HashSet<FileNaming>();
        }
        return this.existingChildren != null ? this.existingChildren : new HashSet<FileNaming>();
    }

    private synchronized Set<FileNaming> getNotExisting() {
        return this.getNotExisting(true);
    }

    private synchronized Set<FileNaming> getNotExisting(boolean bl) {
        if (bl && this.notExistingChildren == null) {
            this.notExistingChildren = new HashSet<FileNaming>();
        }
        return this.notExistingChildren != null ? this.notExistingChildren : new HashSet<FileNaming>();
    }
}

