/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import org.netbeans.swing.popupswitcher.SwitcherTable;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;

final class ButtonPopupSwitcher
implements MouseInputListener,
AWTEventListener {
    private static Popup popup;
    private Component invokingComponent = null;
    private long invocationTime = -1L;
    private static boolean shown;
    private static ButtonPopupSwitcher currentSwitcher;
    private SwitcherTable pTable;
    private int x;
    private int y;
    private boolean isDragging = true;

    public static void selectItem(JComponent jComponent, SwitcherTableItem[] switcherTableItemArray, int n, int n2) {
        ButtonPopupSwitcher buttonPopupSwitcher = new ButtonPopupSwitcher(switcherTableItemArray, n, n2);
        buttonPopupSwitcher.doSelect(jComponent);
        currentSwitcher = buttonPopupSwitcher;
    }

    private ButtonPopupSwitcher(SwitcherTableItem[] switcherTableItemArray, int n, int n2) {
        this.pTable = new SwitcherTable(switcherTableItemArray, n2);
        this.x = n - (int)this.pTable.getPreferredSize().getWidth();
        this.y = n2 + 1;
    }

    private void doSelect(JComponent jComponent) {
        this.invokingComponent = jComponent;
        this.invokingComponent.addMouseListener(this);
        this.invokingComponent.addMouseMotionListener(this);
        this.pTable.addMouseListener(this);
        this.pTable.addMouseMotionListener(this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
        popup = PopupFactory.getSharedInstance().getPopup(this.invokingComponent, this.pTable, this.x, this.y);
        popup.show();
        shown = true;
        this.invocationTime = System.currentTimeMillis();
    }

    public static boolean isShown() {
        return shown;
    }

    static void hidePopup() {
        if (ButtonPopupSwitcher.isShown()) {
            currentSwitcher.hideCurrentPopup();
        }
    }

    private synchronized void hideCurrentPopup() {
        this.pTable.removeMouseListener(this);
        this.pTable.removeMouseMotionListener(this);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.invokingComponent != null) {
            this.invokingComponent.removeMouseListener(this);
            this.invokingComponent.removeMouseMotionListener(this);
            this.invokingComponent = null;
        }
        if (popup != null) {
            SwingUtilities.invokeLater(new PopupHider(popup));
            popup = null;
            shown = false;
            currentSwitcher = null;
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        mouseEvent.consume();
        this.changeSelection(mouseEvent);
        this.isDragging = false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        long l;
        if (mouseEvent.getSource() == this.invokingComponent && (l = System.currentTimeMillis()) - this.invocationTime > 500L && this.isDragging) {
            this.mouseClicked(mouseEvent);
        }
        this.isDragging = false;
        mouseEvent.consume();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        SwitcherTableItem switcherTableItem;
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this.pTable);
        if (this.pTable.contains(point) && (switcherTableItem = this.pTable.getSelectedItem()) != null) {
            switcherTableItem.activate();
            this.hideCurrentPopup();
        }
        this.isDragging = false;
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.pTable.clearSelection();
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.changeSelection(mouseEvent);
        mouseEvent.consume();
    }

    private void changeSelection(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (mouseEvent.getSource() != this) {
            point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this.pTable);
        }
        if (this.pTable.contains(point)) {
            int n = this.pTable.rowAtPoint(point);
            int n2 = this.pTable.columnAtPoint(point);
            this.pTable.changeSelection(n, n2, false, false);
        } else {
            this.pTable.clearSelection();
        }
    }

    private boolean onSwitcherTable(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (!(mouseEvent.getSource() instanceof Component)) {
            return false;
        }
        point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this.pTable);
        return this.pTable.contains(point);
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getSource() == this) {
            return;
        }
        if (aWTEvent instanceof MouseEvent) {
            if (aWTEvent.getID() == 502) {
                long l = System.currentTimeMillis();
                if (l - this.invocationTime > 500L && !this.onSwitcherTable((MouseEvent)aWTEvent) && aWTEvent.getSource() != this.invokingComponent) {
                    this.hideCurrentPopup();
                }
            } else if (aWTEvent.getID() == 501 && !this.onSwitcherTable((MouseEvent)aWTEvent) && aWTEvent.getSource() != this.invokingComponent) {
                this.hideCurrentPopup();
            }
        } else if (aWTEvent instanceof KeyEvent && aWTEvent.getID() == 401) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            this.hideCurrentPopup();
        }
    }

    private class PopupHider
    implements Runnable {
        private Popup toHide;

        public PopupHider(Popup popup) {
            this.toHide = popup;
        }

        @Override
        public void run() {
            this.toHide.hide();
            this.toHide = null;
        }
    }
}

