/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.text.JTextComponent;
import sun.awt.shell.ShellFolder;
import sun.swing.DefaultLookup;
import sun.swing.FilePane;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicFileChooserUI
extends FileChooserUI {
    protected Icon directoryIcon = null;
    protected Icon fileIcon = null;
    protected Icon computerIcon = null;
    protected Icon hardDriveIcon = null;
    protected Icon floppyDriveIcon = null;
    protected Icon newFolderIcon = null;
    protected Icon upFolderIcon = null;
    protected Icon homeFolderIcon = null;
    protected Icon listViewIcon = null;
    protected Icon detailsViewIcon = null;
    protected int saveButtonMnemonic = 0;
    protected int openButtonMnemonic = 0;
    protected int cancelButtonMnemonic = 0;
    protected int updateButtonMnemonic = 0;
    protected int helpButtonMnemonic = 0;
    protected int directoryOpenButtonMnemonic = 0;
    protected String saveButtonText = null;
    protected String openButtonText = null;
    protected String cancelButtonText = null;
    protected String updateButtonText = null;
    protected String helpButtonText = null;
    protected String directoryOpenButtonText = null;
    private String openDialogTitleText = null;
    private String saveDialogTitleText = null;
    protected String saveButtonToolTipText = null;
    protected String openButtonToolTipText = null;
    protected String cancelButtonToolTipText = null;
    protected String updateButtonToolTipText = null;
    protected String helpButtonToolTipText = null;
    protected String directoryOpenButtonToolTipText = null;
    private Action approveSelectionAction = new ApproveSelectionAction();
    private Action cancelSelectionAction = new CancelSelectionAction();
    private Action updateAction = new UpdateAction();
    private Action newFolderAction;
    private Action goHomeAction = new GoHomeAction();
    private Action changeToParentDirectoryAction = new ChangeToParentDirectoryAction();
    private String newFolderErrorSeparator = null;
    private String newFolderErrorText = null;
    private String fileDescriptionText = null;
    private String directoryDescriptionText = null;
    private JFileChooser filechooser = null;
    private boolean directorySelected = false;
    private File directory = null;
    private PropertyChangeListener propertyChangeListener = null;
    private AcceptAllFileFilter acceptAllFileFilter = new AcceptAllFileFilter();
    private FileFilter actualFileFilter = null;
    private GlobFilter globFilter = null;
    private BasicDirectoryModel model = null;
    private BasicFileView fileView = new BasicFileView();
    private boolean usesSingleFilePane;
    private boolean readOnly;
    private JPanel accessoryPanel = null;
    private Handler handler;
    private static final TransferHandler defaultTransferHandler = new FileTransferHandler();

    public BasicFileChooserUI(JFileChooser jFileChooser) {
    }

    public void installUI(JComponent jComponent) {
        this.accessoryPanel = new JPanel(new BorderLayout());
        this.filechooser = (JFileChooser)jComponent;
        this.createModel();
        this.clearIconCache();
        this.installDefaults(this.filechooser);
        this.installComponents(this.filechooser);
        this.installListeners(this.filechooser);
        this.filechooser.applyComponentOrientation(this.filechooser.getComponentOrientation());
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
        }
        this.accessoryPanel = null;
        this.getFileChooser().removeAll();
        this.handler = null;
    }

    public void installComponents(JFileChooser jFileChooser) {
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
    }

    protected void installListeners(JFileChooser jFileChooser) {
        this.propertyChangeListener = this.createPropertyChangeListener(jFileChooser);
        if (this.propertyChangeListener != null) {
            jFileChooser.addPropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.addPropertyChangeListener(this.getModel());
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(jFileChooser, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, actionMap);
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)DefaultLookup.get(this.getFileChooser(), this, "FileChooser.ancestorInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        UIAction uIAction = new UIAction("refresh"){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicFileChooserUI.this.getFileChooser().rescanCurrentDirectory();
            }
        };
        actionMapUIResource.put("approveSelection", this.getApproveSelectionAction());
        actionMapUIResource.put("cancelSelection", this.getCancelSelectionAction());
        actionMapUIResource.put("refresh", uIAction);
        actionMapUIResource.put("Go Up", this.getChangeToParentDirectoryAction());
        return actionMapUIResource;
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        if (this.propertyChangeListener != null) {
            jFileChooser.removePropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.removePropertyChangeListener(this.getModel());
        SwingUtilities.replaceUIInputMap(jFileChooser, 1, null);
        SwingUtilities.replaceUIActionMap(jFileChooser, null);
    }

    protected void installDefaults(JFileChooser jFileChooser) {
        this.installIcons(jFileChooser);
        this.installStrings(jFileChooser);
        this.usesSingleFilePane = UIManager.getBoolean("FileChooser.usesSingleFilePane");
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
        TransferHandler transferHandler = jFileChooser.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            jFileChooser.setTransferHandler(defaultTransferHandler);
        }
        LookAndFeel.installProperty(jFileChooser, "opaque", Boolean.FALSE);
    }

    protected void installIcons(JFileChooser jFileChooser) {
        this.directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        this.fileIcon = UIManager.getIcon("FileView.fileIcon");
        this.computerIcon = UIManager.getIcon("FileView.computerIcon");
        this.hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
        this.floppyDriveIcon = UIManager.getIcon("FileView.floppyDriveIcon");
        this.newFolderIcon = UIManager.getIcon("FileChooser.newFolderIcon");
        this.upFolderIcon = UIManager.getIcon("FileChooser.upFolderIcon");
        this.homeFolderIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
        this.detailsViewIcon = UIManager.getIcon("FileChooser.detailsViewIcon");
        this.listViewIcon = UIManager.getIcon("FileChooser.listViewIcon");
    }

    protected void installStrings(JFileChooser jFileChooser) {
        Locale locale = jFileChooser.getLocale();
        this.newFolderErrorText = UIManager.getString((Object)"FileChooser.newFolderErrorText", locale);
        this.newFolderErrorSeparator = UIManager.getString((Object)"FileChooser.newFolderErrorSeparator", locale);
        this.fileDescriptionText = UIManager.getString((Object)"FileChooser.fileDescriptionText", locale);
        this.directoryDescriptionText = UIManager.getString((Object)"FileChooser.directoryDescriptionText", locale);
        this.saveButtonText = UIManager.getString((Object)"FileChooser.saveButtonText", locale);
        this.openButtonText = UIManager.getString((Object)"FileChooser.openButtonText", locale);
        this.saveDialogTitleText = UIManager.getString((Object)"FileChooser.saveDialogTitleText", locale);
        this.openDialogTitleText = UIManager.getString((Object)"FileChooser.openDialogTitleText", locale);
        this.cancelButtonText = UIManager.getString((Object)"FileChooser.cancelButtonText", locale);
        this.updateButtonText = UIManager.getString((Object)"FileChooser.updateButtonText", locale);
        this.helpButtonText = UIManager.getString((Object)"FileChooser.helpButtonText", locale);
        this.directoryOpenButtonText = UIManager.getString((Object)"FileChooser.directoryOpenButtonText", locale);
        this.saveButtonMnemonic = this.getMnemonic("FileChooser.saveButtonMnemonic", locale);
        this.openButtonMnemonic = this.getMnemonic("FileChooser.openButtonMnemonic", locale);
        this.cancelButtonMnemonic = this.getMnemonic("FileChooser.cancelButtonMnemonic", locale);
        this.updateButtonMnemonic = this.getMnemonic("FileChooser.updateButtonMnemonic", locale);
        this.helpButtonMnemonic = this.getMnemonic("FileChooser.helpButtonMnemonic", locale);
        this.directoryOpenButtonMnemonic = this.getMnemonic("FileChooser.directoryOpenButtonMnemonic", locale);
        this.saveButtonToolTipText = UIManager.getString((Object)"FileChooser.saveButtonToolTipText", locale);
        this.openButtonToolTipText = UIManager.getString((Object)"FileChooser.openButtonToolTipText", locale);
        this.cancelButtonToolTipText = UIManager.getString((Object)"FileChooser.cancelButtonToolTipText", locale);
        this.updateButtonToolTipText = UIManager.getString((Object)"FileChooser.updateButtonToolTipText", locale);
        this.helpButtonToolTipText = UIManager.getString((Object)"FileChooser.helpButtonToolTipText", locale);
        this.directoryOpenButtonToolTipText = UIManager.getString((Object)"FileChooser.directoryOpenButtonToolTipText", locale);
    }

    protected void uninstallDefaults(JFileChooser jFileChooser) {
        this.uninstallIcons(jFileChooser);
        this.uninstallStrings(jFileChooser);
        if (jFileChooser.getTransferHandler() instanceof UIResource) {
            jFileChooser.setTransferHandler(null);
        }
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
        this.directoryIcon = null;
        this.fileIcon = null;
        this.computerIcon = null;
        this.hardDriveIcon = null;
        this.floppyDriveIcon = null;
        this.newFolderIcon = null;
        this.upFolderIcon = null;
        this.homeFolderIcon = null;
        this.detailsViewIcon = null;
        this.listViewIcon = null;
    }

    protected void uninstallStrings(JFileChooser jFileChooser) {
        this.saveButtonText = null;
        this.openButtonText = null;
        this.cancelButtonText = null;
        this.updateButtonText = null;
        this.helpButtonText = null;
        this.directoryOpenButtonText = null;
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
        this.updateButtonToolTipText = null;
        this.helpButtonToolTipText = null;
        this.directoryOpenButtonToolTipText = null;
    }

    protected void createModel() {
        if (this.model != null) {
            this.model.invalidateFileCache();
        }
        this.model = new BasicDirectoryModel(this.getFileChooser());
    }

    public BasicDirectoryModel getModel() {
        return this.model;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return null;
    }

    public String getFileName() {
        return null;
    }

    public String getDirectoryName() {
        return null;
    }

    public void setFileName(String string) {
    }

    public void setDirectoryName(String string) {
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return null;
    }

    public String getApproveButtonToolTipText(JFileChooser jFileChooser) {
        String string = jFileChooser.getApproveButtonToolTipText();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonToolTipText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonToolTipText;
        }
        return null;
    }

    public void clearIconCache() {
        this.fileView.clearIconCache();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected MouseListener createDoubleClickListener(JFileChooser jFileChooser, JList jList) {
        return new Handler(jList);
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return this.getHandler();
    }

    protected boolean isDirectorySelected() {
        return this.directorySelected;
    }

    protected void setDirectorySelected(boolean bl) {
        this.directorySelected = bl;
    }

    protected File getDirectory() {
        return this.directory;
    }

    protected void setDirectory(File file) {
        this.directory = file;
    }

    private int getMnemonic(String string, Locale locale) {
        return SwingUtilities2.getUIDefaultsInt((Object)string, locale);
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser jFileChooser) {
        return this.acceptAllFileFilter;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    public String getDialogTitle(JFileChooser jFileChooser) {
        String string = jFileChooser.getDialogTitle();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openDialogTitleText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveDialogTitleText;
        }
        return this.getApproveButtonText(jFileChooser);
    }

    public int getApproveButtonMnemonic(JFileChooser jFileChooser) {
        int n = jFileChooser.getApproveButtonMnemonic();
        if (n > 0) {
            return n;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonMnemonic;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonMnemonic;
        }
        return n;
    }

    public String getApproveButtonText(JFileChooser jFileChooser) {
        String string = jFileChooser.getApproveButtonText();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }

    public Action getNewFolderAction() {
        if (this.newFolderAction == null) {
            this.newFolderAction = new NewFolderAction();
            if (this.readOnly) {
                this.newFolderAction.setEnabled(false);
            }
        }
        return this.newFolderAction;
    }

    public Action getGoHomeAction() {
        return this.goHomeAction;
    }

    public Action getChangeToParentDirectoryAction() {
        return this.changeToParentDirectoryAction;
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    public Action getCancelSelectionAction() {
        return this.cancelSelectionAction;
    }

    public Action getUpdateAction() {
        return this.updateAction;
    }

    private void resetGlobFilter() {
        if (this.actualFileFilter != null) {
            JFileChooser jFileChooser = this.getFileChooser();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (fileFilter != null && fileFilter.equals(this.globFilter)) {
                jFileChooser.setFileFilter(this.actualFileFilter);
                jFileChooser.removeChoosableFileFilter(this.globFilter);
            }
            this.actualFileFilter = null;
        }
    }

    private static boolean isGlobPattern(String string) {
        return File.separatorChar == '\\' && (string.indexOf(42) >= 0 || string.indexOf(63) >= 0) || File.separatorChar == '/' && (string.indexOf(42) >= 0 || string.indexOf(63) >= 0 || string.indexOf(91) >= 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void changeDirectory(File file) {
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && FilePane.usesShellFolder(jFileChooser)) {
            try {
                ShellFolder shellFolder = ShellFolder.getShellFolder(file);
                if (shellFolder.isLink()) {
                    ShellFolder shellFolder2 = shellFolder.getLinkLocation();
                    if (shellFolder2 != null) {
                        if (!jFileChooser.isTraversable(shellFolder2)) return;
                        file = shellFolder2;
                    } else {
                        file = shellFolder;
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
        }
        jFileChooser.setCurrentDirectory(file);
        if (jFileChooser.getFileSelectionMode() != 2 || !jFileChooser.getFileSystemView().isFileSystem(file)) return;
        this.setFileName(file.getAbsolutePath());
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return UIManager.getString("FileChooser.acceptAllFileFilterText");
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        protected ApproveSelectionAction() {
            super("approveSelection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            if (BasicFileChooserUI.this.isDirectorySelected() && (serializable = BasicFileChooserUI.this.getDirectory()) != null) {
                try {
                    serializable = ShellFolder.getNormalizedFile((File)serializable);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                BasicFileChooserUI.this.changeDirectory((File)serializable);
                return;
            }
            serializable = BasicFileChooserUI.this.getFileChooser();
            String string = BasicFileChooserUI.this.getFileName();
            FileSystemView fileSystemView = ((JFileChooser)serializable).getFileSystemView();
            File file = ((JFileChooser)serializable).getCurrentDirectory();
            if (string != null) {
                string = string.trim();
            }
            if (string == null || string.equals("")) {
                BasicFileChooserUI.this.resetGlobFilter();
                return;
            }
            File file2 = null;
            File[] fileArray = null;
            if (string != null && !string.equals("")) {
                if (File.separatorChar == '/') {
                    if (string.startsWith("~/")) {
                        string = System.getProperty("user.home") + string.substring(1);
                    } else if (string.equals("~")) {
                        string = System.getProperty("user.home");
                    }
                }
                if (((JFileChooser)serializable).isMultiSelectionEnabled() && string.startsWith("\"")) {
                    ArrayList<File> arrayList = new ArrayList<File>();
                    if ((string = string.substring(1)).endsWith("\"")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    Object[] objectArray = null;
                    int n = 0;
                    do {
                        String string2;
                        int n2;
                        if ((n2 = string.indexOf("\" \"")) > 0) {
                            string2 = string.substring(0, n2);
                            string = string.substring(n2 + 3);
                        } else {
                            string2 = string;
                            string = "";
                        }
                        Object object = fileSystemView.createFileObject(string2);
                        if (!((File)object).isAbsolute()) {
                            if (objectArray == null) {
                                objectArray = fileSystemView.getFiles(file, false);
                                Arrays.sort(objectArray);
                            }
                            for (int i = 0; i < objectArray.length; ++i) {
                                int n3 = (n + i) % objectArray.length;
                                if (!((File)objectArray[n3]).getName().equals(string2)) continue;
                                object = objectArray[n3];
                                n = n3 + 1;
                                break;
                            }
                        }
                        arrayList.add((File)object);
                    } while (string.length() > 0);
                    if (arrayList.size() > 0) {
                        fileArray = arrayList.toArray(new File[arrayList.size()]);
                    }
                    BasicFileChooserUI.this.resetGlobFilter();
                } else {
                    boolean bl;
                    file2 = fileSystemView.createFileObject(string);
                    if (!file2.isAbsolute()) {
                        file2 = fileSystemView.getChild(file, string);
                    }
                    FileFilter fileFilter = ((JFileChooser)serializable).getFileFilter();
                    if (!file2.exists() && BasicFileChooserUI.isGlobPattern(string)) {
                        if (BasicFileChooserUI.this.globFilter == null) {
                            BasicFileChooserUI.this.globFilter = new GlobFilter();
                        }
                        try {
                            BasicFileChooserUI.this.globFilter.setPattern(string);
                            if (!(fileFilter instanceof GlobFilter)) {
                                BasicFileChooserUI.this.actualFileFilter = fileFilter;
                            }
                            ((JFileChooser)serializable).setFileFilter(null);
                            ((JFileChooser)serializable).setFileFilter(BasicFileChooserUI.this.globFilter);
                            return;
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            // empty catch block
                        }
                    }
                    BasicFileChooserUI.this.resetGlobFilter();
                    boolean bl2 = file2 != null && file2.isDirectory();
                    boolean bl3 = file2 != null && ((JFileChooser)serializable).isTraversable(file2);
                    boolean bl4 = ((JFileChooser)serializable).isDirectorySelectionEnabled();
                    boolean bl5 = ((JFileChooser)serializable).isFileSelectionEnabled();
                    boolean bl6 = bl = actionEvent != null && (actionEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
                    if (bl2 && bl3 && (bl || !bl4)) {
                        BasicFileChooserUI.this.changeDirectory(file2);
                        return;
                    }
                    if (!(!bl2 && bl5 || bl2 && bl4 || bl4 && !file2.exists())) {
                        file2 = null;
                    }
                }
            }
            if (fileArray != null || file2 != null) {
                if (fileArray != null || ((JFileChooser)serializable).isMultiSelectionEnabled()) {
                    if (fileArray == null) {
                        fileArray = new File[]{file2};
                    }
                    ((JFileChooser)serializable).setSelectedFiles(fileArray);
                    ((JFileChooser)serializable).setSelectedFiles(fileArray);
                } else {
                    ((JFileChooser)serializable).setSelectedFile(file2);
                }
                ((JFileChooser)serializable).approveSelection();
            } else {
                if (((JFileChooser)serializable).isMultiSelectionEnabled()) {
                    ((JFileChooser)serializable).setSelectedFiles(null);
                } else {
                    ((JFileChooser)serializable).setSelectedFile(null);
                }
                ((JFileChooser)serializable).cancelSelection();
            }
        }
    }

    protected class BasicFileView
    extends FileView {
        protected Hashtable<File, Icon> iconCache = new Hashtable();

        public void clearIconCache() {
            this.iconCache = new Hashtable();
        }

        public String getName(File file) {
            String string = null;
            if (file != null) {
                string = BasicFileChooserUI.this.getFileChooser().getFileSystemView().getSystemDisplayName(file);
            }
            return string;
        }

        public String getDescription(File file) {
            return file.getName();
        }

        public String getTypeDescription(File file) {
            String string = BasicFileChooserUI.this.getFileChooser().getFileSystemView().getSystemTypeDescription(file);
            if (string == null) {
                string = file.isDirectory() ? BasicFileChooserUI.this.directoryDescriptionText : BasicFileChooserUI.this.fileDescriptionText;
            }
            return string;
        }

        public Icon getCachedIcon(File file) {
            return this.iconCache.get(file);
        }

        public void cacheIcon(File file, Icon icon) {
            if (file == null || icon == null) {
                return;
            }
            this.iconCache.put(file, icon);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            icon = BasicFileChooserUI.this.fileIcon;
            if (file != null) {
                FileSystemView fileSystemView = BasicFileChooserUI.this.getFileChooser().getFileSystemView();
                if (fileSystemView.isFloppyDrive(file)) {
                    icon = BasicFileChooserUI.this.floppyDriveIcon;
                } else if (fileSystemView.isDrive(file)) {
                    icon = BasicFileChooserUI.this.hardDriveIcon;
                } else if (fileSystemView.isComputerNode(file)) {
                    icon = BasicFileChooserUI.this.computerIcon;
                } else if (file.isDirectory()) {
                    icon = BasicFileChooserUI.this.directoryIcon;
                }
            }
            this.cacheIcon(file, icon);
            return icon;
        }

        public Boolean isHidden(File file) {
            String string = file.getName();
            if (string != null && string.charAt(0) == '.') {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        protected CancelSelectionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.getFileChooser().cancelSelection();
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        protected ChangeToParentDirectoryAction() {
            super("Go Up");
            this.putValue("ActionCommandKey", "Go Up");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component == null || !(component instanceof JTextComponent)) {
                BasicFileChooserUI.this.getFileChooser().changeToParentDirectory();
            }
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        Handler handler;

        public DoubleClickListener(JList jList) {
            this.handler = new Handler(jList);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.handler.mouseEntered(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.handler.mouseClicked(mouseEvent);
        }
    }

    static class FileTransferHandler
    extends TransferHandler
    implements UIResource {
        FileTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            int n;
            Serializable serializable;
            Object object;
            Object[] objectArray = null;
            if (jComponent instanceof JList) {
                objectArray = ((JList)jComponent).getSelectedValues();
            } else if (jComponent instanceof JTable && (object = ((JTable)(serializable = (JTable)jComponent)).getSelectedRows()) != null) {
                objectArray = new Object[((int[])object).length];
                for (n = 0; n < ((Object)object).length; ++n) {
                    objectArray[n] = ((JTable)serializable).getValueAt((int)object[n], 0);
                }
            }
            if (objectArray == null || objectArray.length == 0) {
                return null;
            }
            serializable = new StringBuffer();
            object = new StringBuffer();
            ((StringBuffer)object).append("<html>\n<body>\n<ul>\n");
            for (n = 0; n < objectArray.length; ++n) {
                Object object2 = objectArray[n];
                String string = object2 == null ? "" : object2.toString();
                ((StringBuffer)serializable).append(string + "\n");
                ((StringBuffer)object).append("  <li>" + string + "\n");
            }
            ((StringBuffer)serializable).deleteCharAt(((StringBuffer)serializable).length() - 1);
            ((StringBuffer)object).append("</ul>\n</body>\n</html>");
            return new FileTransferable(((StringBuffer)serializable).toString(), ((StringBuffer)object).toString(), objectArray);
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        static class FileTransferable
        extends BasicTransferable {
            Object[] fileData;

            FileTransferable(String string, String string2, Object[] objectArray) {
                super(string, string2);
                this.fileData = objectArray;
            }

            protected DataFlavor[] getRicherFlavors() {
                DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.javaFileListFlavor};
                return dataFlavorArray;
            }

            protected Object getRicherData(DataFlavor dataFlavor) {
                if (DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (int i = 0; i < this.fileData.length; ++i) {
                        arrayList.add(this.fileData[i]);
                    }
                    return arrayList;
                }
                return null;
            }
        }
    }

    class GlobFilter
    extends FileFilter {
        Pattern pattern;
        String globPattern;

        GlobFilter() {
        }

        public void setPattern(String string) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length * 2];
            boolean bl = File.separatorChar == '\\';
            boolean bl2 = false;
            int n = 0;
            this.globPattern = string;
            if (bl) {
                int n2 = cArray.length;
                if (string.endsWith("*.*")) {
                    n2 -= 2;
                }
                block16: for (int i = 0; i < n2; ++i) {
                    switch (cArray[i]) {
                        case '*': {
                            cArray2[n++] = 46;
                            cArray2[n++] = 42;
                            continue block16;
                        }
                        case '?': {
                            cArray2[n++] = 46;
                            continue block16;
                        }
                        case '\\': {
                            cArray2[n++] = 92;
                            cArray2[n++] = 92;
                            continue block16;
                        }
                        default: {
                            if ("+()^$.{}[]".indexOf(cArray[i]) >= 0) {
                                cArray2[n++] = 92;
                            }
                            cArray2[n++] = cArray[i];
                        }
                    }
                }
            } else {
                block17: for (int i = 0; i < cArray.length; ++i) {
                    switch (cArray[i]) {
                        case '*': {
                            if (!bl2) {
                                cArray2[n++] = 46;
                            }
                            cArray2[n++] = 42;
                            continue block17;
                        }
                        case '?': {
                            cArray2[n++] = bl2 ? 63 : 46;
                            continue block17;
                        }
                        case '[': {
                            bl2 = true;
                            cArray2[n++] = cArray[i];
                            if (i >= cArray.length - 1) continue block17;
                            switch (cArray[i + 1]) {
                                case '!': 
                                case '^': {
                                    cArray2[n++] = 94;
                                    ++i;
                                    break;
                                }
                                case ']': {
                                    cArray2[n++] = cArray[++i];
                                }
                            }
                            continue block17;
                        }
                        case ']': {
                            cArray2[n++] = cArray[i];
                            bl2 = false;
                            continue block17;
                        }
                        case '\\': {
                            if (i == 0 && cArray.length > 1 && cArray[1] == '~') {
                                cArray2[n++] = cArray[++i];
                                continue block17;
                            }
                            cArray2[n++] = 92;
                            if (i < cArray.length - 1 && "*?[]".indexOf(cArray[i + 1]) >= 0) {
                                cArray2[n++] = cArray[++i];
                                continue block17;
                            }
                            cArray2[n++] = 92;
                            continue block17;
                        }
                        default: {
                            if (!Character.isLetterOrDigit(cArray[i])) {
                                cArray2[n++] = 92;
                            }
                            cArray2[n++] = cArray[i];
                        }
                    }
                }
            }
            this.pattern = Pattern.compile(new String(cArray2, 0, n), 2);
        }

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            return this.pattern.matcher(file.getName()).matches();
        }

        public String getDescription() {
            return this.globPattern;
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        protected GoHomeAction() {
            super("Go Home");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = BasicFileChooserUI.this.getFileChooser();
            BasicFileChooserUI.this.changeDirectory(jFileChooser.getFileSystemView().getHomeDirectory());
        }
    }

    private class Handler
    implements MouseListener,
    ListSelectionListener {
        JList list;

        Handler() {
        }

        Handler(JList jList) {
            this.list = jList;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (this.list != null && SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() % 2 == 0 && (n = SwingUtilities2.loc2IndexFileList(this.list, mouseEvent.getPoint())) >= 0) {
                File file = (File)this.list.getModel().getElementAt(n);
                try {
                    file = ShellFolder.getNormalizedFile(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (BasicFileChooserUI.this.getFileChooser().isTraversable(file)) {
                    this.list.clearSelection();
                    BasicFileChooserUI.this.changeDirectory(file);
                } else {
                    BasicFileChooserUI.this.getFileChooser().approveSelection();
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.list != null) {
                TransferHandler transferHandler;
                TransferHandler transferHandler2 = BasicFileChooserUI.this.getFileChooser().getTransferHandler();
                if (transferHandler2 != (transferHandler = this.list.getTransferHandler())) {
                    this.list.setTransferHandler(transferHandler2);
                }
                if (BasicFileChooserUI.this.getFileChooser().getDragEnabled() != this.list.getDragEnabled()) {
                    this.list.setDragEnabled(BasicFileChooserUI.this.getFileChooser().getDragEnabled());
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                boolean bl;
                JFileChooser jFileChooser = BasicFileChooserUI.this.getFileChooser();
                FileSystemView fileSystemView = jFileChooser.getFileSystemView();
                JList jList = (JList)listSelectionEvent.getSource();
                int n = jFileChooser.getFileSelectionMode();
                boolean bl2 = bl = BasicFileChooserUI.this.usesSingleFilePane && n == 0;
                if (jFileChooser.isMultiSelectionEnabled()) {
                    File[] fileArray = null;
                    Object[] objectArray = jList.getSelectedValues();
                    if (objectArray != null) {
                        if (objectArray.length == 1 && ((File)objectArray[0]).isDirectory() && jFileChooser.isTraversable((File)objectArray[0]) && (bl || !fileSystemView.isFileSystem((File)objectArray[0]))) {
                            BasicFileChooserUI.this.setDirectorySelected(true);
                            BasicFileChooserUI.this.setDirectory((File)objectArray[0]);
                        } else {
                            ArrayList<File> arrayList = new ArrayList<File>(objectArray.length);
                            for (int i = 0; i < objectArray.length; ++i) {
                                File file = (File)objectArray[i];
                                boolean bl3 = file.isDirectory();
                                if ((!jFileChooser.isFileSelectionEnabled() || bl3) && (!jFileChooser.isDirectorySelectionEnabled() || !fileSystemView.isFileSystem(file) || !bl3)) continue;
                                arrayList.add(file);
                            }
                            if (arrayList.size() > 0) {
                                fileArray = arrayList.toArray(new File[arrayList.size()]);
                            }
                            BasicFileChooserUI.this.setDirectorySelected(false);
                        }
                    }
                    jFileChooser.setSelectedFiles(fileArray);
                } else {
                    File file = (File)jList.getSelectedValue();
                    if (file != null && file.isDirectory() && jFileChooser.isTraversable(file) && (bl || !fileSystemView.isFileSystem(file))) {
                        BasicFileChooserUI.this.setDirectorySelected(true);
                        BasicFileChooserUI.this.setDirectory(file);
                        if (BasicFileChooserUI.this.usesSingleFilePane) {
                            jFileChooser.setSelectedFile(null);
                        }
                    } else {
                        BasicFileChooserUI.this.setDirectorySelected(false);
                        if (file != null) {
                            jFileChooser.setSelectedFile(file);
                        }
                    }
                }
            }
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicFileChooserUI.this.readOnly) {
                return;
            }
            JFileChooser jFileChooser = BasicFileChooserUI.this.getFileChooser();
            File file = jFileChooser.getCurrentDirectory();
            File file2 = null;
            try {
                file2 = jFileChooser.getFileSystemView().createNewFolder(file);
                if (jFileChooser.isMultiSelectionEnabled()) {
                    jFileChooser.setSelectedFiles(new File[]{file2});
                } else {
                    jFileChooser.setSelectedFile(file2);
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(jFileChooser, BasicFileChooserUI.this.newFolderErrorText + BasicFileChooserUI.this.newFolderErrorSeparator + iOException, BasicFileChooserUI.this.newFolderErrorText, 0);
                return;
            }
            jFileChooser.rescanCurrentDirectory();
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            BasicFileChooserUI.this.getHandler().valueChanged(listSelectionEvent);
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        protected UpdateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = BasicFileChooserUI.this.getFileChooser();
            jFileChooser.setCurrentDirectory(jFileChooser.getFileSystemView().createFileObject(BasicFileChooserUI.this.getDirectoryName()));
            jFileChooser.rescanCurrentDirectory();
        }
    }
}

