/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatConverter;
import com.sun.media.sound.DLSInfo;
import com.sun.media.sound.DLSInstrument;
import com.sun.media.sound.DLSModulator;
import com.sun.media.sound.DLSRegion;
import com.sun.media.sound.DLSSample;
import com.sun.media.sound.DLSSampleLoop;
import com.sun.media.sound.DLSSampleOptions;
import com.sun.media.sound.ModelByteBuffer;
import com.sun.media.sound.ModelInstrumentComparator;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.RIFFInvalidDataException;
import com.sun.media.sound.RIFFInvalidFormatException;
import com.sun.media.sound.RIFFReader;
import com.sun.media.sound.RIFFWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLSSoundbank
implements Soundbank {
    private static final int DLS_CDL_AND = 1;
    private static final int DLS_CDL_OR = 2;
    private static final int DLS_CDL_XOR = 3;
    private static final int DLS_CDL_ADD = 4;
    private static final int DLS_CDL_SUBTRACT = 5;
    private static final int DLS_CDL_MULTIPLY = 6;
    private static final int DLS_CDL_DIVIDE = 7;
    private static final int DLS_CDL_LOGICAL_AND = 8;
    private static final int DLS_CDL_LOGICAL_OR = 9;
    private static final int DLS_CDL_LT = 10;
    private static final int DLS_CDL_LE = 11;
    private static final int DLS_CDL_GT = 12;
    private static final int DLS_CDL_GE = 13;
    private static final int DLS_CDL_EQ = 14;
    private static final int DLS_CDL_NOT = 15;
    private static final int DLS_CDL_CONST = 16;
    private static final int DLS_CDL_QUERY = 17;
    private static final int DLS_CDL_QUERYSUPPORTED = 18;
    private static final DLSID DLSID_GMInHardware = new DLSID(395259684L, 50020, 4561, 167, 96, 0, 0, 248, 117, 172, 18);
    private static final DLSID DLSID_GSInHardware = new DLSID(395259685L, 50020, 4561, 167, 96, 0, 0, 248, 117, 172, 18);
    private static final DLSID DLSID_XGInHardware = new DLSID(395259686L, 50020, 4561, 167, 96, 0, 0, 248, 117, 172, 18);
    private static final DLSID DLSID_SupportsDLS1 = new DLSID(395259687L, 50020, 4561, 167, 96, 0, 0, 248, 117, 172, 18);
    private static final DLSID DLSID_SupportsDLS2 = new DLSID(-247096859L, 18057, 4562, 175, 166, 0, 170, 0, 36, 216, 182);
    private static final DLSID DLSID_SampleMemorySize = new DLSID(395259688L, 50020, 4561, 167, 96, 0, 0, 248, 117, 172, 18);
    private static final DLSID DLSID_ManufacturersID = new DLSID(-1338109567L, 32917, 4562, 161, 239, 0, 96, 8, 51, 219, 216);
    private static final DLSID DLSID_ProductID = new DLSID(-1338109566L, 32917, 4562, 161, 239, 0, 96, 8, 51, 219, 216);
    private static final DLSID DLSID_SamplePlaybackRate = new DLSID(714209043L, 42175, 4562, 187, 223, 0, 96, 8, 51, 219, 216);
    private long major = -1L;
    private long minor = -1L;
    private DLSInfo info = new DLSInfo();
    private List<DLSInstrument> instruments = new ArrayList<DLSInstrument>();
    private List<DLSSample> samples = new ArrayList<DLSSample>();
    private boolean largeFormat = false;
    private File sampleFile;
    private Map<DLSRegion, Long> temp_rgnassign = new HashMap<DLSRegion, Long>();

    public DLSSoundbank() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLSSoundbank(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            this.readSoundbank(inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLSSoundbank(File file) throws IOException {
        this.largeFormat = true;
        this.sampleFile = file;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.readSoundbank(fileInputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public DLSSoundbank(InputStream inputStream) throws IOException {
        this.readSoundbank(inputStream);
    }

    private void readSoundbank(InputStream inputStream) throws IOException {
        RIFFReader rIFFReader = new RIFFReader(inputStream);
        if (!rIFFReader.getFormat().equals("RIFF")) {
            throw new RIFFInvalidFormatException("Input stream is not a valid RIFF stream!");
        }
        if (!rIFFReader.getType().equals("DLS ")) {
            throw new RIFFInvalidFormatException("Input stream is not a valid DLS soundbank!");
        }
        while (rIFFReader.hasNextChunk()) {
            RIFFReader rIFFReader2 = rIFFReader.nextChunk();
            if (rIFFReader2.getFormat().equals("LIST")) {
                if (rIFFReader2.getType().equals("INFO")) {
                    this.readInfoChunk(rIFFReader2);
                }
                if (rIFFReader2.getType().equals("lins")) {
                    this.readLinsChunk(rIFFReader2);
                }
                if (!rIFFReader2.getType().equals("wvpl")) continue;
                this.readWvplChunk(rIFFReader2);
                continue;
            }
            if (rIFFReader2.getFormat().equals("cdl ") && !this.readCdlChunk(rIFFReader2)) {
                throw new RIFFInvalidFormatException("DLS file isn't supported!");
            }
            if (rIFFReader2.getFormat().equals("colh")) {
                // empty if block
            }
            if (rIFFReader2.getFormat().equals("ptbl")) {
                // empty if block
            }
            if (!rIFFReader2.getFormat().equals("vers")) continue;
            this.major = rIFFReader2.readUnsignedInt();
            this.minor = rIFFReader2.readUnsignedInt();
        }
        for (Map.Entry entry : this.temp_rgnassign.entrySet()) {
            ((DLSRegion)entry.getKey()).sample = this.samples.get((int)((Long)entry.getValue()).longValue());
        }
        this.temp_rgnassign = null;
    }

    private boolean cdlIsQuerySupported(DLSID dLSID) {
        return dLSID.equals(DLSID_GMInHardware) || dLSID.equals(DLSID_GSInHardware) || dLSID.equals(DLSID_XGInHardware) || dLSID.equals(DLSID_SupportsDLS1) || dLSID.equals(DLSID_SupportsDLS2) || dLSID.equals(DLSID_SampleMemorySize) || dLSID.equals(DLSID_ManufacturersID) || dLSID.equals(DLSID_ProductID) || dLSID.equals(DLSID_SamplePlaybackRate);
    }

    private long cdlQuery(DLSID dLSID) {
        if (dLSID.equals(DLSID_GMInHardware)) {
            return 1L;
        }
        if (dLSID.equals(DLSID_GSInHardware)) {
            return 0L;
        }
        if (dLSID.equals(DLSID_XGInHardware)) {
            return 0L;
        }
        if (dLSID.equals(DLSID_SupportsDLS1)) {
            return 1L;
        }
        if (dLSID.equals(DLSID_SupportsDLS2)) {
            return 1L;
        }
        if (dLSID.equals(DLSID_SampleMemorySize)) {
            return Runtime.getRuntime().totalMemory();
        }
        if (dLSID.equals(DLSID_ManufacturersID)) {
            return 0L;
        }
        if (dLSID.equals(DLSID_ProductID)) {
            return 0L;
        }
        if (dLSID.equals(DLSID_SamplePlaybackRate)) {
            return 44100L;
        }
        return 0L;
    }

    private boolean readCdlChunk(RIFFReader rIFFReader) throws IOException {
        Stack<Long> stack = new Stack<Long>();
        while (rIFFReader.available() != 0) {
            int n = rIFFReader.readUnsignedShort();
            switch (n) {
                case 1: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l != 0L && l2 != 0L ? 1L : 0L);
                    break;
                }
                case 2: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l != 0L || l2 != 0L ? 1L : 0L);
                    break;
                }
                case 3: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l != 0L ^ l2 != 0L ? 1L : 0L);
                    break;
                }
                case 4: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l + l2);
                    break;
                }
                case 5: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l - l2);
                    break;
                }
                case 6: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l * l2);
                    break;
                }
                case 7: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l / l2);
                    break;
                }
                case 8: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l != 0L && l2 != 0L ? 1L : 0L);
                    break;
                }
                case 9: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l != 0L || l2 != 0L ? 1L : 0L);
                    break;
                }
                case 10: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l < l2 ? 1L : 0L);
                    break;
                }
                case 11: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l <= l2 ? 1L : 0L);
                    break;
                }
                case 12: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l > l2 ? 1L : 0L);
                    break;
                }
                case 13: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l >= l2 ? 1L : 0L);
                    break;
                }
                case 14: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l == l2 ? 1L : 0L);
                    break;
                }
                case 15: {
                    long l = (Long)stack.pop();
                    long l2 = (Long)stack.pop();
                    stack.push(l == 0L ? 1L : 0L);
                    break;
                }
                case 16: {
                    stack.push(rIFFReader.readUnsignedInt());
                    break;
                }
                case 17: {
                    DLSID dLSID = DLSID.read(rIFFReader);
                    stack.push(this.cdlQuery(dLSID));
                    break;
                }
                case 18: {
                    DLSID dLSID = DLSID.read(rIFFReader);
                    stack.push(this.cdlIsQuerySupported(dLSID) ? 1L : 0L);
                    break;
                }
            }
        }
        if (stack.isEmpty()) {
            return false;
        }
        return (Long)stack.pop() == 1L;
    }

    private void readInfoChunk(RIFFReader rIFFReader) throws IOException {
        this.info.name = null;
        while (rIFFReader.hasNextChunk()) {
            RIFFReader rIFFReader2 = rIFFReader.nextChunk();
            String string = rIFFReader2.getFormat();
            if (string.equals("INAM")) {
                this.info.name = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ICRD")) {
                this.info.creationDate = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IENG")) {
                this.info.engineers = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IPRD")) {
                this.info.product = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ICOP")) {
                this.info.copyright = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ICMT")) {
                this.info.comments = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ISFT")) {
                this.info.tools = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IARL")) {
                this.info.archival_location = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IART")) {
                this.info.artist = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ICMS")) {
                this.info.commissioned = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IGNR")) {
                this.info.genre = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IKEY")) {
                this.info.keywords = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IMED")) {
                this.info.medium = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ISBJ")) {
                this.info.subject = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ISRC")) {
                this.info.source = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ISRF")) {
                this.info.source_form = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (!string.equals("ITCH")) continue;
            this.info.technician = rIFFReader2.readString(rIFFReader2.available());
        }
    }

    private void readLinsChunk(RIFFReader rIFFReader) throws IOException {
        while (rIFFReader.hasNextChunk()) {
            RIFFReader rIFFReader2 = rIFFReader.nextChunk();
            if (!rIFFReader2.getFormat().equals("LIST") || !rIFFReader2.getType().equals("ins ")) continue;
            this.readInsChunk(rIFFReader2);
        }
    }

    private void readInsChunk(RIFFReader rIFFReader) throws IOException {
        DLSInstrument dLSInstrument = new DLSInstrument(this);
        while (rIFFReader.hasNextChunk()) {
            RIFFReader rIFFReader2 = rIFFReader.nextChunk();
            String string = rIFFReader2.getFormat();
            if (string.equals("LIST")) {
                Object object;
                Object object2;
                if (rIFFReader2.getType().equals("INFO")) {
                    this.readInsInfoChunk(dLSInstrument, rIFFReader2);
                }
                if (rIFFReader2.getType().equals("lrgn")) {
                    while (rIFFReader2.hasNextChunk()) {
                        object2 = rIFFReader2.nextChunk();
                        if (!((RIFFReader)object2).getFormat().equals("LIST")) continue;
                        if (((RIFFReader)object2).getType().equals("rgn ") && this.readRgnChunk((DLSRegion)(object = new DLSRegion()), (RIFFReader)object2)) {
                            dLSInstrument.getRegions().add((DLSRegion)object);
                        }
                        if (!((RIFFReader)object2).getType().equals("rgn2") || !this.readRgnChunk((DLSRegion)(object = new DLSRegion()), (RIFFReader)object2)) continue;
                        dLSInstrument.getRegions().add((DLSRegion)object);
                    }
                }
                if (rIFFReader2.getType().equals("lart")) {
                    object2 = new ArrayList();
                    while (rIFFReader2.hasNextChunk()) {
                        object = rIFFReader2.nextChunk();
                        if (rIFFReader2.getFormat().equals("cdl ") && !this.readCdlChunk(rIFFReader2)) {
                            object2.clear();
                            break;
                        }
                        if (!((RIFFReader)object).getFormat().equals("art1")) continue;
                        this.readArt1Chunk((List<DLSModulator>)object2, (RIFFReader)object);
                    }
                    dLSInstrument.getModulators().addAll((Collection<DLSModulator>)object2);
                }
                if (!rIFFReader2.getType().equals("lar2")) continue;
                object2 = new ArrayList<DLSModulator>();
                while (rIFFReader2.hasNextChunk()) {
                    object = rIFFReader2.nextChunk();
                    if (rIFFReader2.getFormat().equals("cdl ") && !this.readCdlChunk(rIFFReader2)) {
                        object2.clear();
                        break;
                    }
                    if (!((RIFFReader)object).getFormat().equals("art2")) continue;
                    this.readArt2Chunk((List<DLSModulator>)object2, (RIFFReader)object);
                }
                dLSInstrument.getModulators().addAll((Collection<DLSModulator>)object2);
                continue;
            }
            if (string.equals("dlid")) {
                dLSInstrument.guid = new byte[16];
                rIFFReader2.readFully(dLSInstrument.guid);
            }
            if (!string.equals("insh")) continue;
            rIFFReader2.readUnsignedInt();
            int n = rIFFReader2.read();
            n += (rIFFReader2.read() & 0x7F) << 7;
            rIFFReader2.read();
            int n2 = rIFFReader2.read();
            int n3 = rIFFReader2.read() & 0x7F;
            rIFFReader2.read();
            rIFFReader2.read();
            rIFFReader2.read();
            dLSInstrument.bank = n;
            dLSInstrument.preset = n3;
            dLSInstrument.druminstrument = (n2 & 0x80) > 0;
        }
        this.instruments.add(dLSInstrument);
    }

    private void readArt1Chunk(List<DLSModulator> list, RIFFReader rIFFReader) throws IOException {
        long l = rIFFReader.readUnsignedInt();
        long l2 = rIFFReader.readUnsignedInt();
        if (l - 8L != 0L) {
            rIFFReader.skipBytes(l - 8L);
        }
        int n = 0;
        while ((long)n < l2) {
            DLSModulator dLSModulator = new DLSModulator();
            dLSModulator.version = 1;
            dLSModulator.source = rIFFReader.readUnsignedShort();
            dLSModulator.control = rIFFReader.readUnsignedShort();
            dLSModulator.destination = rIFFReader.readUnsignedShort();
            dLSModulator.transform = rIFFReader.readUnsignedShort();
            dLSModulator.scale = rIFFReader.readInt();
            list.add(dLSModulator);
            ++n;
        }
    }

    private void readArt2Chunk(List<DLSModulator> list, RIFFReader rIFFReader) throws IOException {
        long l = rIFFReader.readUnsignedInt();
        long l2 = rIFFReader.readUnsignedInt();
        if (l - 8L != 0L) {
            rIFFReader.skipBytes(l - 8L);
        }
        int n = 0;
        while ((long)n < l2) {
            DLSModulator dLSModulator = new DLSModulator();
            dLSModulator.version = 2;
            dLSModulator.source = rIFFReader.readUnsignedShort();
            dLSModulator.control = rIFFReader.readUnsignedShort();
            dLSModulator.destination = rIFFReader.readUnsignedShort();
            dLSModulator.transform = rIFFReader.readUnsignedShort();
            dLSModulator.scale = rIFFReader.readInt();
            list.add(dLSModulator);
            ++n;
        }
    }

    private boolean readRgnChunk(DLSRegion dLSRegion, RIFFReader rIFFReader) throws IOException {
        while (rIFFReader.hasNextChunk()) {
            RIFFReader rIFFReader2 = rIFFReader.nextChunk();
            String string = rIFFReader2.getFormat();
            if (string.equals("LIST")) {
                RIFFReader rIFFReader3;
                ArrayList<DLSModulator> arrayList;
                if (rIFFReader2.getType().equals("lart")) {
                    arrayList = new ArrayList<DLSModulator>();
                    while (rIFFReader2.hasNextChunk()) {
                        rIFFReader3 = rIFFReader2.nextChunk();
                        if (rIFFReader2.getFormat().equals("cdl ") && !this.readCdlChunk(rIFFReader2)) {
                            arrayList.clear();
                            break;
                        }
                        if (!rIFFReader3.getFormat().equals("art1")) continue;
                        this.readArt1Chunk(arrayList, rIFFReader3);
                    }
                    dLSRegion.getModulators().addAll(arrayList);
                }
                if (!rIFFReader2.getType().equals("lar2")) continue;
                arrayList = new ArrayList();
                while (rIFFReader2.hasNextChunk()) {
                    rIFFReader3 = rIFFReader2.nextChunk();
                    if (rIFFReader2.getFormat().equals("cdl ") && !this.readCdlChunk(rIFFReader2)) {
                        arrayList.clear();
                        break;
                    }
                    if (!rIFFReader3.getFormat().equals("art2")) continue;
                    this.readArt2Chunk(arrayList, rIFFReader3);
                }
                dLSRegion.getModulators().addAll(arrayList);
                continue;
            }
            if (string.equals("cdl ") && !this.readCdlChunk(rIFFReader2)) {
                return false;
            }
            if (string.equals("rgnh")) {
                dLSRegion.keyfrom = rIFFReader2.readUnsignedShort();
                dLSRegion.keyto = rIFFReader2.readUnsignedShort();
                dLSRegion.velfrom = rIFFReader2.readUnsignedShort();
                dLSRegion.velto = rIFFReader2.readUnsignedShort();
                dLSRegion.options = rIFFReader2.readUnsignedShort();
                dLSRegion.exclusiveClass = rIFFReader2.readUnsignedShort();
            }
            if (string.equals("wlnk")) {
                dLSRegion.fusoptions = rIFFReader2.readUnsignedShort();
                dLSRegion.phasegroup = rIFFReader2.readUnsignedShort();
                dLSRegion.channel = rIFFReader2.readUnsignedInt();
                long l = rIFFReader2.readUnsignedInt();
                this.temp_rgnassign.put(dLSRegion, l);
            }
            if (!string.equals("wsmp")) continue;
            dLSRegion.sampleoptions = new DLSSampleOptions();
            this.readWsmpChunk(dLSRegion.sampleoptions, rIFFReader2);
        }
        return true;
    }

    private void readWsmpChunk(DLSSampleOptions dLSSampleOptions, RIFFReader rIFFReader) throws IOException {
        long l = rIFFReader.readUnsignedInt();
        dLSSampleOptions.unitynote = rIFFReader.readUnsignedShort();
        dLSSampleOptions.finetune = rIFFReader.readShort();
        dLSSampleOptions.attenuation = rIFFReader.readInt();
        dLSSampleOptions.options = rIFFReader.readUnsignedInt();
        long l2 = rIFFReader.readInt();
        if (l > 20L) {
            rIFFReader.skipBytes(l - 20L);
        }
        int n = 0;
        while ((long)n < l2) {
            DLSSampleLoop dLSSampleLoop = new DLSSampleLoop();
            long l3 = rIFFReader.readUnsignedInt();
            dLSSampleLoop.type = rIFFReader.readUnsignedInt();
            dLSSampleLoop.start = rIFFReader.readUnsignedInt();
            dLSSampleLoop.length = rIFFReader.readUnsignedInt();
            dLSSampleOptions.loops.add(dLSSampleLoop);
            if (l3 > 16L) {
                rIFFReader.skipBytes(l3 - 16L);
            }
            ++n;
        }
    }

    private void readInsInfoChunk(DLSInstrument dLSInstrument, RIFFReader rIFFReader) throws IOException {
        dLSInstrument.info.name = null;
        while (rIFFReader.hasNextChunk()) {
            RIFFReader rIFFReader2 = rIFFReader.nextChunk();
            String string = rIFFReader2.getFormat();
            if (string.equals("INAM")) {
                dLSInstrument.info.name = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ICRD")) {
                dLSInstrument.info.creationDate = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IENG")) {
                dLSInstrument.info.engineers = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IPRD")) {
                dLSInstrument.info.product = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ICOP")) {
                dLSInstrument.info.copyright = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ICMT")) {
                dLSInstrument.info.comments = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ISFT")) {
                dLSInstrument.info.tools = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IARL")) {
                dLSInstrument.info.archival_location = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IART")) {
                dLSInstrument.info.artist = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ICMS")) {
                dLSInstrument.info.commissioned = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IGNR")) {
                dLSInstrument.info.genre = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IKEY")) {
                dLSInstrument.info.keywords = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IMED")) {
                dLSInstrument.info.medium = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ISBJ")) {
                dLSInstrument.info.subject = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ISRC")) {
                dLSInstrument.info.source = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ISRF")) {
                dLSInstrument.info.source_form = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (!string.equals("ITCH")) continue;
            dLSInstrument.info.technician = rIFFReader2.readString(rIFFReader2.available());
        }
    }

    private void readWvplChunk(RIFFReader rIFFReader) throws IOException {
        while (rIFFReader.hasNextChunk()) {
            RIFFReader rIFFReader2 = rIFFReader.nextChunk();
            if (!rIFFReader2.getFormat().equals("LIST") || !rIFFReader2.getType().equals("wave")) continue;
            this.readWaveChunk(rIFFReader2);
        }
    }

    private void readWaveChunk(RIFFReader rIFFReader) throws IOException {
        DLSSample dLSSample = new DLSSample(this);
        while (rIFFReader.hasNextChunk()) {
            int n;
            RIFFReader rIFFReader2 = rIFFReader.nextChunk();
            String string = rIFFReader2.getFormat();
            if (string.equals("LIST")) {
                if (!rIFFReader2.getType().equals("INFO")) continue;
                this.readWaveInfoChunk(dLSSample, rIFFReader2);
                continue;
            }
            if (string.equals("dlid")) {
                dLSSample.guid = new byte[16];
                rIFFReader2.readFully(dLSSample.guid);
            }
            if (string.equals("fmt ")) {
                int n2 = rIFFReader2.readUnsignedShort();
                if (n2 != 1 && n2 != 3) {
                    throw new RIFFInvalidDataException("Only PCM samples are supported!");
                }
                n = rIFFReader2.readUnsignedShort();
                long l = rIFFReader2.readUnsignedInt();
                rIFFReader2.readUnsignedInt();
                int n3 = rIFFReader2.readUnsignedShort();
                int n4 = rIFFReader2.readUnsignedShort();
                AudioFormat audioFormat = null;
                if (n2 == 1) {
                    audioFormat = n4 == 8 ? new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, l, n4, n, n3, l, false) : new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, l, n4, n, n3, l, false);
                }
                if (n2 == 3) {
                    audioFormat = new AudioFormat(AudioFloatConverter.PCM_FLOAT, l, n4, n, n3, l, false);
                }
                dLSSample.format = audioFormat;
            }
            if (string.equals("data")) {
                if (this.largeFormat) {
                    dLSSample.setData(new ModelByteBuffer(this.sampleFile, rIFFReader2.getFilePointer(), (long)rIFFReader2.available()));
                } else {
                    byte[] byArray = new byte[rIFFReader2.available()];
                    dLSSample.setData(byArray);
                    n = 0;
                    int n5 = rIFFReader2.available();
                    while (n != n5) {
                        if (n5 - n > 65536) {
                            rIFFReader2.readFully(byArray, n, 65536);
                            n += 65536;
                            continue;
                        }
                        rIFFReader2.readFully(byArray, n, n5 - n);
                        n = n5;
                    }
                }
            }
            if (!string.equals("wsmp")) continue;
            dLSSample.sampleoptions = new DLSSampleOptions();
            this.readWsmpChunk(dLSSample.sampleoptions, rIFFReader2);
        }
        this.samples.add(dLSSample);
    }

    private void readWaveInfoChunk(DLSSample dLSSample, RIFFReader rIFFReader) throws IOException {
        dLSSample.info.name = null;
        while (rIFFReader.hasNextChunk()) {
            RIFFReader rIFFReader2 = rIFFReader.nextChunk();
            String string = rIFFReader2.getFormat();
            if (string.equals("INAM")) {
                dLSSample.info.name = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ICRD")) {
                dLSSample.info.creationDate = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IENG")) {
                dLSSample.info.engineers = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IPRD")) {
                dLSSample.info.product = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ICOP")) {
                dLSSample.info.copyright = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ICMT")) {
                dLSSample.info.comments = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ISFT")) {
                dLSSample.info.tools = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IARL")) {
                dLSSample.info.archival_location = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IART")) {
                dLSSample.info.artist = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ICMS")) {
                dLSSample.info.commissioned = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IGNR")) {
                dLSSample.info.genre = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IKEY")) {
                dLSSample.info.keywords = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("IMED")) {
                dLSSample.info.medium = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ISBJ")) {
                dLSSample.info.subject = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ISRC")) {
                dLSSample.info.source = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (string.equals("ISRF")) {
                dLSSample.info.source_form = rIFFReader2.readString(rIFFReader2.available());
                continue;
            }
            if (!string.equals("ITCH")) continue;
            dLSSample.info.technician = rIFFReader2.readString(rIFFReader2.available());
        }
    }

    public void save(String string) throws IOException {
        this.writeSoundbank(new RIFFWriter(string, "DLS "));
    }

    public void save(File file) throws IOException {
        this.writeSoundbank(new RIFFWriter(file, "DLS "));
    }

    public void save(OutputStream outputStream) throws IOException {
        this.writeSoundbank(new RIFFWriter(outputStream, "DLS "));
    }

    private void writeSoundbank(RIFFWriter rIFFWriter) throws IOException {
        RIFFWriter rIFFWriter2;
        RIFFWriter rIFFWriter3 = rIFFWriter.writeChunk("colh");
        rIFFWriter3.writeUnsignedInt(this.instruments.size());
        if (this.major != -1L && this.minor != -1L) {
            rIFFWriter2 = rIFFWriter.writeChunk("vers");
            rIFFWriter2.writeUnsignedInt(this.major);
            rIFFWriter2.writeUnsignedInt(this.minor);
        }
        this.writeInstruments(rIFFWriter.writeList("lins"));
        rIFFWriter2 = rIFFWriter.writeChunk("ptbl");
        rIFFWriter2.writeUnsignedInt(8L);
        rIFFWriter2.writeUnsignedInt(this.samples.size());
        long l = rIFFWriter.getFilePointer();
        for (int i = 0; i < this.samples.size(); ++i) {
            rIFFWriter2.writeUnsignedInt(0L);
        }
        RIFFWriter rIFFWriter4 = rIFFWriter.writeList("wvpl");
        long l2 = rIFFWriter4.getFilePointer();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (DLSSample dLSSample : this.samples) {
            arrayList.add(rIFFWriter4.getFilePointer() - l2);
            this.writeSample(rIFFWriter4.writeList("wave"), dLSSample);
        }
        long l3 = rIFFWriter.getFilePointer();
        rIFFWriter.seek(l);
        rIFFWriter.setWriteOverride(true);
        for (Long l4 : arrayList) {
            rIFFWriter.writeUnsignedInt(l4);
        }
        rIFFWriter.setWriteOverride(false);
        rIFFWriter.seek(l3);
        this.writeInfo(rIFFWriter.writeList("INFO"), this.info);
        rIFFWriter.close();
    }

    private void writeSample(RIFFWriter rIFFWriter, DLSSample dLSSample) throws IOException {
        AudioFormat audioFormat = dLSSample.getFormat();
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        float f = audioFormat.getSampleRate();
        int n = audioFormat.getSampleSizeInBits();
        int n2 = audioFormat.getChannels();
        int n3 = audioFormat.getFrameSize();
        float f2 = audioFormat.getFrameRate();
        boolean bl = audioFormat.isBigEndian();
        boolean bl2 = false;
        if (audioFormat.getSampleSizeInBits() == 8) {
            if (!encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
                encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                bl2 = true;
            }
        } else {
            if (!encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                bl2 = true;
            }
            if (bl) {
                bl = false;
                bl2 = true;
            }
        }
        if (bl2) {
            audioFormat = new AudioFormat(encoding, f, n, n2, n3, f2, bl);
        }
        RIFFWriter rIFFWriter2 = rIFFWriter.writeChunk("fmt ");
        int n4 = 0;
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            n4 = 1;
        } else if (audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            n4 = 1;
        } else if (audioFormat.getEncoding().equals(AudioFloatConverter.PCM_FLOAT)) {
            n4 = 3;
        }
        rIFFWriter2.writeUnsignedShort(n4);
        rIFFWriter2.writeUnsignedShort(audioFormat.getChannels());
        rIFFWriter2.writeUnsignedInt((long)audioFormat.getSampleRate());
        long l = (long)audioFormat.getFrameRate() * (long)audioFormat.getFrameSize();
        rIFFWriter2.writeUnsignedInt(l);
        rIFFWriter2.writeUnsignedShort(audioFormat.getFrameSize());
        rIFFWriter2.writeUnsignedShort(audioFormat.getSampleSizeInBits());
        rIFFWriter2.write(0);
        rIFFWriter2.write(0);
        this.writeSampleOptions(rIFFWriter.writeChunk("wsmp"), dLSSample.sampleoptions);
        if (bl2) {
            int n5;
            RIFFWriter rIFFWriter3 = rIFFWriter.writeChunk("data");
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(audioFormat, (AudioInputStream)dLSSample.getData());
            byte[] byArray = new byte[1024];
            while ((n5 = audioInputStream.read(byArray)) != -1) {
                rIFFWriter3.write(byArray, 0, n5);
            }
        } else {
            RIFFWriter rIFFWriter4 = rIFFWriter.writeChunk("data");
            ModelByteBuffer modelByteBuffer = dLSSample.getDataBuffer();
            modelByteBuffer.writeTo(rIFFWriter4);
        }
        this.writeInfo(rIFFWriter.writeList("INFO"), dLSSample.info);
    }

    private void writeInstruments(RIFFWriter rIFFWriter) throws IOException {
        for (DLSInstrument dLSInstrument : this.instruments) {
            this.writeInstrument(rIFFWriter.writeList("ins "), dLSInstrument);
        }
    }

    private void writeInstrument(RIFFWriter rIFFWriter, DLSInstrument dLSInstrument) throws IOException {
        int n = 0;
        int n2 = 0;
        for (DLSModulator object2 : dLSInstrument.getModulators()) {
            if (object2.version == 1) {
                ++n;
            }
            if (object2.version != 2) continue;
            ++n2;
        }
        for (DLSRegion dLSRegion : dLSInstrument.regions) {
            for (DLSModulator dLSModulator : dLSRegion.getModulators()) {
                if (dLSModulator.version == 1) {
                    ++n;
                }
                if (dLSModulator.version != 2) continue;
                ++n2;
            }
        }
        int n3 = 1;
        if (n2 > 0) {
            n3 = 2;
        }
        RIFFWriter rIFFWriter2 = rIFFWriter.writeChunk("insh");
        rIFFWriter2.writeUnsignedInt(dLSInstrument.getRegions().size());
        rIFFWriter2.writeUnsignedInt((long)dLSInstrument.bank + (dLSInstrument.druminstrument ? 0x80000000L : 0L));
        rIFFWriter2.writeUnsignedInt(dLSInstrument.preset);
        RIFFWriter rIFFWriter3 = rIFFWriter.writeList("lrgn");
        for (DLSRegion dLSRegion : dLSInstrument.regions) {
            this.writeRegion(rIFFWriter3, dLSRegion, n3);
        }
        this.writeArticulators(rIFFWriter, dLSInstrument.getModulators());
        this.writeInfo(rIFFWriter.writeList("INFO"), dLSInstrument.info);
    }

    private void writeArticulators(RIFFWriter rIFFWriter, List<DLSModulator> list) throws IOException {
        Object object;
        int n = 0;
        int n2 = 0;
        for (DLSModulator object22 : list) {
            if (object22.version == 1) {
                ++n;
            }
            if (object22.version != 2) continue;
            ++n2;
        }
        if (n > 0) {
            object = rIFFWriter.writeList("lart");
            RIFFWriter rIFFWriter2 = ((RIFFWriter)object).writeChunk("art1");
            rIFFWriter2.writeUnsignedInt(8L);
            rIFFWriter2.writeUnsignedInt(n);
            for (DLSModulator dLSModulator : list) {
                if (dLSModulator.version != 1) continue;
                rIFFWriter2.writeUnsignedShort(dLSModulator.source);
                rIFFWriter2.writeUnsignedShort(dLSModulator.control);
                rIFFWriter2.writeUnsignedShort(dLSModulator.destination);
                rIFFWriter2.writeUnsignedShort(dLSModulator.transform);
                rIFFWriter2.writeInt(dLSModulator.scale);
            }
        }
        if (n2 > 0) {
            object = rIFFWriter.writeList("lar2");
            RIFFWriter rIFFWriter3 = ((RIFFWriter)object).writeChunk("art2");
            rIFFWriter3.writeUnsignedInt(8L);
            rIFFWriter3.writeUnsignedInt(n2);
            for (DLSModulator dLSModulator : list) {
                if (dLSModulator.version != 2) continue;
                rIFFWriter3.writeUnsignedShort(dLSModulator.source);
                rIFFWriter3.writeUnsignedShort(dLSModulator.control);
                rIFFWriter3.writeUnsignedShort(dLSModulator.destination);
                rIFFWriter3.writeUnsignedShort(dLSModulator.transform);
                rIFFWriter3.writeInt(dLSModulator.scale);
            }
        }
    }

    private void writeRegion(RIFFWriter rIFFWriter, DLSRegion dLSRegion, int n) throws IOException {
        RIFFWriter rIFFWriter2 = null;
        if (n == 1) {
            rIFFWriter2 = rIFFWriter.writeList("rgn ");
        }
        if (n == 2) {
            rIFFWriter2 = rIFFWriter.writeList("rgn2");
        }
        if (rIFFWriter2 == null) {
            return;
        }
        RIFFWriter rIFFWriter3 = rIFFWriter2.writeChunk("rgnh");
        rIFFWriter3.writeUnsignedShort(dLSRegion.keyfrom);
        rIFFWriter3.writeUnsignedShort(dLSRegion.keyto);
        rIFFWriter3.writeUnsignedShort(dLSRegion.velfrom);
        rIFFWriter3.writeUnsignedShort(dLSRegion.velto);
        rIFFWriter3.writeUnsignedShort(dLSRegion.options);
        rIFFWriter3.writeUnsignedShort(dLSRegion.exclusiveClass);
        if (dLSRegion.sampleoptions != null) {
            this.writeSampleOptions(rIFFWriter2.writeChunk("wsmp"), dLSRegion.sampleoptions);
        }
        if (dLSRegion.sample != null && this.samples.indexOf(dLSRegion.sample) != -1) {
            RIFFWriter rIFFWriter4 = rIFFWriter2.writeChunk("wlnk");
            rIFFWriter4.writeUnsignedShort(dLSRegion.fusoptions);
            rIFFWriter4.writeUnsignedShort(dLSRegion.phasegroup);
            rIFFWriter4.writeUnsignedInt(dLSRegion.channel);
            rIFFWriter4.writeUnsignedInt(this.samples.indexOf(dLSRegion.sample));
        }
        this.writeArticulators(rIFFWriter2, dLSRegion.getModulators());
        rIFFWriter2.close();
    }

    private void writeSampleOptions(RIFFWriter rIFFWriter, DLSSampleOptions dLSSampleOptions) throws IOException {
        rIFFWriter.writeUnsignedInt(20L);
        rIFFWriter.writeUnsignedShort(dLSSampleOptions.unitynote);
        rIFFWriter.writeShort(dLSSampleOptions.finetune);
        rIFFWriter.writeInt(dLSSampleOptions.attenuation);
        rIFFWriter.writeUnsignedInt(dLSSampleOptions.options);
        rIFFWriter.writeInt(dLSSampleOptions.loops.size());
        for (DLSSampleLoop dLSSampleLoop : dLSSampleOptions.loops) {
            rIFFWriter.writeUnsignedInt(16L);
            rIFFWriter.writeUnsignedInt(dLSSampleLoop.type);
            rIFFWriter.writeUnsignedInt(dLSSampleLoop.start);
            rIFFWriter.writeUnsignedInt(dLSSampleLoop.length);
        }
    }

    private void writeInfoStringChunk(RIFFWriter rIFFWriter, String string, String string2) throws IOException {
        if (string2 == null) {
            return;
        }
        RIFFWriter rIFFWriter2 = rIFFWriter.writeChunk(string);
        rIFFWriter2.writeString(string2);
        int n = string2.getBytes("ascii").length;
        rIFFWriter2.write(0);
        if (++n % 2 != 0) {
            rIFFWriter2.write(0);
        }
    }

    private void writeInfo(RIFFWriter rIFFWriter, DLSInfo dLSInfo) throws IOException {
        this.writeInfoStringChunk(rIFFWriter, "INAM", dLSInfo.name);
        this.writeInfoStringChunk(rIFFWriter, "ICRD", dLSInfo.creationDate);
        this.writeInfoStringChunk(rIFFWriter, "IENG", dLSInfo.engineers);
        this.writeInfoStringChunk(rIFFWriter, "IPRD", dLSInfo.product);
        this.writeInfoStringChunk(rIFFWriter, "ICOP", dLSInfo.copyright);
        this.writeInfoStringChunk(rIFFWriter, "ICMT", dLSInfo.comments);
        this.writeInfoStringChunk(rIFFWriter, "ISFT", dLSInfo.tools);
        this.writeInfoStringChunk(rIFFWriter, "IARL", dLSInfo.archival_location);
        this.writeInfoStringChunk(rIFFWriter, "IART", dLSInfo.artist);
        this.writeInfoStringChunk(rIFFWriter, "ICMS", dLSInfo.commissioned);
        this.writeInfoStringChunk(rIFFWriter, "IGNR", dLSInfo.genre);
        this.writeInfoStringChunk(rIFFWriter, "IKEY", dLSInfo.keywords);
        this.writeInfoStringChunk(rIFFWriter, "IMED", dLSInfo.medium);
        this.writeInfoStringChunk(rIFFWriter, "ISBJ", dLSInfo.subject);
        this.writeInfoStringChunk(rIFFWriter, "ISRC", dLSInfo.source);
        this.writeInfoStringChunk(rIFFWriter, "ISRF", dLSInfo.source_form);
        this.writeInfoStringChunk(rIFFWriter, "ITCH", dLSInfo.technician);
    }

    public DLSInfo getInfo() {
        return this.info;
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    @Override
    public String getVersion() {
        return this.major + "." + this.minor;
    }

    @Override
    public String getVendor() {
        return this.info.engineers;
    }

    @Override
    public String getDescription() {
        return this.info.comments;
    }

    public void setName(String string) {
        this.info.name = string;
    }

    public void setVendor(String string) {
        this.info.engineers = string;
    }

    public void setDescription(String string) {
        this.info.comments = string;
    }

    @Override
    public SoundbankResource[] getResources() {
        SoundbankResource[] soundbankResourceArray = new SoundbankResource[this.samples.size()];
        int n = 0;
        for (int i = 0; i < this.samples.size(); ++i) {
            soundbankResourceArray[n++] = this.samples.get(i);
        }
        return soundbankResourceArray;
    }

    public DLSInstrument[] getInstruments() {
        DLSInstrument[] dLSInstrumentArray = this.instruments.toArray(new DLSInstrument[this.instruments.size()]);
        Arrays.sort(dLSInstrumentArray, new ModelInstrumentComparator());
        return dLSInstrumentArray;
    }

    public DLSSample[] getSamples() {
        return this.samples.toArray(new DLSSample[this.samples.size()]);
    }

    @Override
    public Instrument getInstrument(Patch patch) {
        int n = patch.getProgram();
        int n2 = patch.getBank();
        boolean bl = false;
        if (patch instanceof ModelPatch) {
            bl = ((ModelPatch)patch).isPercussion();
        }
        for (DLSInstrument dLSInstrument : this.instruments) {
            Patch patch2 = ((Instrument)dLSInstrument).getPatch();
            int n3 = patch2.getProgram();
            int n4 = patch2.getBank();
            if (n != n3 || n2 != n4) continue;
            boolean bl2 = false;
            if (patch2 instanceof ModelPatch) {
                bl2 = ((ModelPatch)patch2).isPercussion();
            }
            if (bl != bl2) continue;
            return dLSInstrument;
        }
        return null;
    }

    public void addResource(SoundbankResource soundbankResource) {
        if (soundbankResource instanceof DLSInstrument) {
            this.instruments.add((DLSInstrument)soundbankResource);
        }
        if (soundbankResource instanceof DLSSample) {
            this.samples.add((DLSSample)soundbankResource);
        }
    }

    public void removeResource(SoundbankResource soundbankResource) {
        if (soundbankResource instanceof DLSInstrument) {
            this.instruments.remove((DLSInstrument)soundbankResource);
        }
        if (soundbankResource instanceof DLSSample) {
            this.samples.remove((DLSSample)soundbankResource);
        }
    }

    public void addInstrument(DLSInstrument dLSInstrument) {
        this.instruments.add(dLSInstrument);
    }

    public void removeInstrument(DLSInstrument dLSInstrument) {
        this.instruments.remove(dLSInstrument);
    }

    public long getMajor() {
        return this.major;
    }

    public void setMajor(long l) {
        this.major = l;
    }

    public long getMinor() {
        return this.minor;
    }

    public void setMinor(long l) {
        this.minor = l;
    }

    private static class DLSID {
        long i1;
        int s1;
        int s2;
        int x1;
        int x2;
        int x3;
        int x4;
        int x5;
        int x6;
        int x7;
        int x8;

        private DLSID() {
        }

        public DLSID(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
            this.i1 = l;
            this.s1 = n;
            this.s2 = n2;
            this.x1 = n3;
            this.x2 = n4;
            this.x3 = n5;
            this.x4 = n6;
            this.x5 = n7;
            this.x6 = n8;
            this.x7 = n9;
            this.x8 = n10;
        }

        public static DLSID read(RIFFReader rIFFReader) throws IOException {
            DLSID dLSID = new DLSID();
            dLSID.i1 = rIFFReader.readUnsignedInt();
            dLSID.s1 = rIFFReader.readUnsignedShort();
            dLSID.s2 = rIFFReader.readUnsignedShort();
            dLSID.x1 = rIFFReader.readUnsignedByte();
            dLSID.x2 = rIFFReader.readUnsignedByte();
            dLSID.x3 = rIFFReader.readUnsignedByte();
            dLSID.x4 = rIFFReader.readUnsignedByte();
            dLSID.x5 = rIFFReader.readUnsignedByte();
            dLSID.x6 = rIFFReader.readUnsignedByte();
            dLSID.x7 = rIFFReader.readUnsignedByte();
            dLSID.x8 = rIFFReader.readUnsignedByte();
            return dLSID;
        }

        public int hashCode() {
            return (int)this.i1;
        }

        public boolean equals(Object object) {
            if (!(object instanceof DLSID)) {
                return false;
            }
            DLSID dLSID = (DLSID)object;
            return this.i1 == dLSID.i1 && this.s1 == dLSID.s1 && this.s2 == dLSID.s2 && this.x1 == dLSID.x1 && this.x2 == dLSID.x2 && this.x3 == dLSID.x3 && this.x4 == dLSID.x4 && this.x5 == dLSID.x5 && this.x6 == dLSID.x6 && this.x7 == dLSID.x7 && this.x8 == dLSID.x8;
        }
    }
}

