/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.Children;
import org.openide.nodes.EntrySupport;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeOp;

final class ChildrenArray
extends NodeAdapter {
    public EntrySupport.Default entrySupport;
    private Node[] nodes;
    private Map<EntrySupport.Default.Info, Collection<Node>> map;
    private static final Logger LOGGER = Logger.getLogger(ChildrenArray.class.getName());

    public Children getChildren() {
        return this.entrySupport == null ? null : this.entrySupport.children;
    }

    public Node[] nodes() {
        if (this.entrySupport == null) {
            return null;
        }
        if (this.nodes == null) {
            this.nodes = this.entrySupport.justComputeNodes();
            for (int i = 0; i < this.nodes.length; ++i) {
                this.nodes[i].reassignTo(this.entrySupport.children, this);
            }
            this.entrySupport.registerChildrenArray(this, this.nodes.length > 0);
        }
        return this.nodes;
    }

    public void clear() {
        if (this.nodes != null) {
            this.nodes = null;
            this.entrySupport.registerChildrenArray(this, false);
        }
    }

    void remove(EntrySupport.Default.Info info) {
        this.map.remove(info);
    }

    public boolean isInitialized() {
        return this.nodes != null;
    }

    private String logInfo(EntrySupport.Default.Info info) {
        return info.toString() + '[' + Integer.toHexString(System.identityHashCode(info)) + ']';
    }

    public synchronized Collection<Node> nodesFor(EntrySupport.Default.Info info, boolean bl) {
        boolean bl2 = LOGGER.isLoggable(Level.FINE);
        if (bl2) {
            LOGGER.finer("nodesFor(" + this.logInfo(info) + ") on " + Thread.currentThread());
        }
        if (this.map == null) {
            assert (!bl) : "Should be already initialized";
            this.map = new WeakHashMap<EntrySupport.Default.Info, Collection<Node>>(7);
        }
        Collection<Node> collection = this.map.get(info);
        if (bl2) {
            LOGGER.finer("  map size=" + this.map.size() + ", nodes=" + collection);
        }
        if (collection == null) {
            assert (!bl) : "Cannot find nodes for " + info + " in " + this.map;
            try {
                collection = info.entry.nodes(null);
            }
            catch (RuntimeException runtimeException) {
                NodeOp.warning(runtimeException);
                collection = Collections.emptyList();
            }
            if (collection == null) {
                collection = Collections.emptyList();
                LOGGER.warning("Null returned by " + info.entry + " (" + info.entry.getClass().getName() + ")");
            }
            info.length = collection.size();
            this.map.put(info, collection);
            if (bl2) {
                LOGGER.finer("  created nodes=" + collection);
            }
        }
        if (bl2) {
            LOGGER.finer("  leaving nodesFor(" + this.logInfo(info) + ") on " + Thread.currentThread());
        }
        return collection;
    }

    public synchronized void useNodes(EntrySupport.Default.Info info, Collection<Node> collection) {
        if (this.map == null) {
            this.map = new WeakHashMap<EntrySupport.Default.Info, Collection<Node>>(7);
        }
        info.length = collection.size();
        this.map.put(info, collection);
    }

    public String toString() {
        return super.toString() + "  " + this.getChildren();
    }
}

