/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.PropertyEditorSupport;

final class EnumPropertyEditor
extends PropertyEditorSupport {
    private final Class<? extends Enum> c;

    public EnumPropertyEditor(Class<? extends Enum> clazz) {
        this.c = clazz;
    }

    private Object[] getValues() {
        try {
            return (Object[])this.c.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public String[] getTags() {
        Object[] objectArray = this.getValues();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    @Override
    public String getAsText() {
        Object object = this.getValue();
        return object != null ? object.toString() : "";
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if (string.length() > 0) {
            Object[] objectArray = this.getValues();
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = objectArray[i].toString();
                if (!string.equals(string2)) continue;
                this.setValue(objectArray[i]);
                return;
            }
            this.setValue(Enum.valueOf(this.c, string));
        } else {
            this.setValue(null);
        }
    }

    @Override
    public String getJavaInitializationString() {
        Enum enum_ = (Enum)this.getValue();
        return enum_ != null ? this.c.getName().replace('$', '.') + '.' + enum_.name() : "null";
    }
}

