/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import [Ljava.lang.Object;;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.DefaultHeapVisitor;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.SystemDictionaryHelper;
import sun.jvm.hotspot.utilities.soql.Callable;
import sun.jvm.hotspot.utilities.soql.DefaultScriptObject;
import sun.jvm.hotspot.utilities.soql.JSJavaClass;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;
import sun.jvm.hotspot.utilities.soql.JSJavaKlass;
import sun.jvm.hotspot.utilities.soql.JSJavaObject;
import sun.jvm.hotspot.utilities.soql.MethodCallable;

public class JSJavaHeap
extends DefaultScriptObject {
    private static final int FIELD_CAPACITY = 0;
    private static final int FIELD_USED = 1;
    private static final int FIELD_FOR_EACH_OBJECT = 2;
    private static final int FIELD_FOR_EACH_CLASS = 3;
    private static final int FIELD_UNDEFINED = -1;
    private static Map fields = new HashMap();
    private final JSJavaFactory factory;
    private static Method forEachObjectMethod;
    private static Method forEachClassMethod;

    public JSJavaHeap(JSJavaFactory fac) {
        this.factory = fac;
    }

    public Object get(String name) {
        int fieldID = JSJavaHeap.getFieldID(name);
        switch (fieldID) {
            case 0: {
                return new Long(this.getCapacity());
            }
            case 1: {
                return new Long(this.getUsed());
            }
            case 2: {
                return new MethodCallable(this, forEachObjectMethod);
            }
            case 3: {
                return new MethodCallable(this, forEachClassMethod);
            }
        }
        return super.get(name);
    }

    public Object[] getIds() {
        Object[] superIds = super.getIds();
        Object[] tmp = fields.keySet().toArray();
        Object[] res = new Object[superIds.length + tmp.length];
        System.arraycopy(tmp, 0, res, 0, tmp.length);
        System.arraycopy(superIds, 0, res, tmp.length, superIds.length);
        return res;
    }

    public boolean has(String name) {
        if (JSJavaHeap.getFieldID(name) != -1) {
            return true;
        }
        return super.has(name);
    }

    public void put(String name, Object value) {
        if (JSJavaHeap.getFieldID(name) == -1) {
            super.put(name, value);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void forEachObject(Object[] args) {
        subtypes = true;
        kls = null;
        func = null;
        switch (args.length) {
            case 3: {
                b = args[2];
                if (b != null && b instanceof Boolean) {
                    subtypes = (Boolean)b;
                }
            }
            case 2: {
                k = args[1];
                if (k == null) {
                    return;
                }
                if (!(k instanceof JSJavaKlass)) ** GOTO lbl16
                kls = ((JSJavaKlass)k).getKlass();
                ** GOTO lbl18
lbl16:
                // 1 sources

                if (k instanceof String && (kls = SystemDictionaryHelper.findInstanceKlass((String)k)) == null) {
                    return;
                }
            }
lbl18:
            // 4 sources

            case 1: {
                f = args[0];
                if (f != null && f instanceof Callable) {
                    func = (Callable)f;
                    break;
                }
                return;
            }
            default: {
                return;
            }
        }
        finalFunc = func;
        visitor = new DefaultHeapVisitor(){

            public boolean doObj(Oop oop) {
                JSJavaObject jo = JSJavaHeap.this.factory.newJSJavaObject(oop);
                if (jo != null) {
                    try {
                        finalFunc.call(new Object[]{jo});
                    }
                    catch (ScriptException exp) {
                        throw new RuntimeException(exp);
                    }
                }
                return false;
            }
        };
        heap = VM.getVM().getObjectHeap();
        if (kls == null) {
            kls = SystemDictionaryHelper.findInstanceKlass("java.lang.Object");
        }
        heap.iterateObjectsOfKlass(visitor, kls, subtypes);
    }

    public void forEachClass(Object[] args) {
        boolean withLoader = false;
        Callable func = null;
        switch (args.length) {
            case 2: {
                Object b = args[1];
                if (b instanceof Boolean) {
                    withLoader = (Boolean)b;
                }
            }
            case 1: {
                Object f = args[0];
                if (f instanceof Callable) {
                    func = (Callable)f;
                    break;
                }
                return;
            }
            default: {
                return;
            }
        }
        final Callable finalFunc = func;
        SystemDictionary sysDict = VM.getVM().getSystemDictionary();
        if (withLoader) {
            sysDict.classesDo(new SystemDictionary.ClassAndLoaderVisitor(){

                public void visit(Klass kls, Oop loader) {
                    JSJavaKlass jk = JSJavaHeap.this.factory.newJSJavaKlass(kls);
                    if (jk == null) {
                        return;
                    }
                    JSJavaClass k = jk.getJSJavaClass();
                    JSJavaObject l = JSJavaHeap.this.factory.newJSJavaObject(loader);
                    if (k != null && k != null) {
                        try {
                            finalFunc.call(new Object[]{k, l});
                        }
                        catch (ScriptException exp) {
                            throw new RuntimeException(exp);
                        }
                    }
                }
            });
        } else {
            sysDict.classesDo(new SystemDictionary.ClassVisitor(){

                public void visit(Klass kls) {
                    JSJavaKlass jk = JSJavaHeap.this.factory.newJSJavaKlass(kls);
                    if (jk == null) {
                        return;
                    }
                    JSJavaClass k = jk.getJSJavaClass();
                    if (k != null && k != null) {
                        try {
                            finalFunc.call(new Object[]{k});
                        }
                        catch (ScriptException exp) {
                            throw new RuntimeException(exp);
                        }
                    }
                }
            });
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Java Heap (capacity=");
        buf.append(this.getCapacity());
        buf.append(", used=");
        buf.append(this.getUsed());
        buf.append(")");
        return buf.toString();
    }

    private static void addField(String name, int fieldId) {
        fields.put(name, new Integer(fieldId));
    }

    private static int getFieldID(String name) {
        Integer res = (Integer)fields.get(name);
        return res != null ? res : -1;
    }

    private long getCapacity() {
        return VM.getVM().getUniverse().heap().capacity();
    }

    private long getUsed() {
        return VM.getVM().getUniverse().heap().used();
    }

    static {
        JSJavaHeap.addField("capacity", 0);
        JSJavaHeap.addField("used", 1);
        JSJavaHeap.addField("forEachObject", 2);
        JSJavaHeap.addField("forEachClass", 3);
        try {
            Class myClass = JSJavaHeap.class;
            forEachObjectMethod = myClass.getMethod("forEachObject", Object;.class);
            forEachClassMethod = myClass.getMethod("forEachClass", Object;.class);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }
}

