/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui.classbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.ui.HistoryComboBox;
import sun.jvm.hotspot.ui.SAEditorPane;
import sun.jvm.hotspot.ui.classbrowser.HTMLGenerator;

public class CodeViewerPanel
extends JPanel {
    protected SAEditorPane contentEditor;
    protected HistoryComboBox address;
    protected HTMLGenerator htmlGen = new HTMLGenerator();
    protected JScrollPane scrollPane;

    public CodeViewerPanel() {
        this.contentEditor = new SAEditorPane();
        HyperlinkListener hyperListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String item;
                    String description = e.getDescription();
                    int equalToIndex = description.indexOf(61);
                    if (equalToIndex != -1 && ((item = description.substring(0, equalToIndex)).equals("pc") || item.equals("klass") || item.equals("method"))) {
                        CodeViewerPanel.this.address.setText(description.substring(equalToIndex + 1));
                    }
                    CodeViewerPanel.this.contentEditor.setText(CodeViewerPanel.this.htmlGen.genHTMLForHyperlink(description));
                }
            }
        };
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)new JLabel("Enter PC or methodOop/klassOop Address: "), "West");
        this.address = new HistoryComboBox();
        topPanel.add((Component)this.address, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridLayout(1, 1));
        this.contentEditor = new SAEditorPane();
        this.contentEditor.addHyperlinkListener(hyperListener);
        this.scrollPane = new JScrollPane(this.contentEditor);
        bottomPanel.add(this.scrollPane);
        this.add((Component)topPanel, "North");
        this.add((Component)bottomPanel, "Center");
        this.address.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CodeViewerPanel.this.viewAddress();
            }
        });
    }

    private void viewAddress() {
        if (this.address.getText() != null && !this.address.getText().equals("")) {
            this.contentEditor.setText(this.htmlGen.genHTMLForAddress(this.address.getText()));
        }
    }

    public void viewAddress(Address addr) {
        this.address.setText(addr.toString());
        this.viewAddress();
    }
}

