/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.shared;

import java.io.PrintStream;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public abstract class ImmutableSpace
extends VMObject {
    private static AddressField bottomField;
    private static AddressField endField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("ImmutableSpace");
        bottomField = type.getAddressField("_bottom");
        endField = type.getAddressField("_end");
    }

    public ImmutableSpace(Address addr) {
        super(addr);
    }

    public Address bottom() {
        return bottomField.getValue(this.addr);
    }

    public Address end() {
        return endField.getValue(this.addr);
    }

    public MemRegion usedRegion() {
        return new MemRegion(this.bottom(), this.end());
    }

    public OopHandle bottomAsOopHandle() {
        return bottomField.getOopHandle(this.addr);
    }

    public abstract List getLiveRegions();

    public long capacity() {
        return this.end().minus(this.bottom());
    }

    public abstract long used();

    public boolean contains(Address p) {
        return this.bottom().lessThanOrEqual(p) && this.end().greaterThan(p);
    }

    public void print() {
        this.printOn(System.out);
    }

    public abstract void printOn(PrintStream var1);

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                ImmutableSpace.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

