/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.ui.components.JExtendedRadioButton;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class NewCustomConfiguration
extends JPanel
implements ChangeListener,
ListSelectionListener,
DocumentListener {
    private static final String MONITOR_STRING = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_MonitorString");
    private static final String CPU_STRING = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_CpuString");
    private static final String MEMORY_STRING = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_MemoryString");
    private static final String NEW_CONFIG_DIALOG_CAPTION = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_NewConfigDialogCaption");
    private static final String DUPLICATE_CONFIG_DIALOG_CAPTION = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_DuplicateConfigDialogCaption");
    private static final String RENAME_CONFIG_DIALOG_CAPTION = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_RenameConfigDialogCaption");
    private static final String NEW_CONFIG_STRING = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_NewConfigString");
    private static final String NEW_MONITOR_STRING = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_NewMonitorString");
    private static final String NEW_CPU_STRING = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_NewCpuString");
    private static final String NEW_MEMORY_STRING = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_NewMemoryString");
    private static final String TYPE_LABEL_TEXT = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_TypeLabelText");
    private static final String NAME_LABEL_TEXT = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_NameLabelText");
    private static final String NAME_LABEL_ACCESS_DESCR = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_NameLabelAccessDescr");
    private static final String INIT_SETTINGS_LABEL_TEXT = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_InitSettingsLabelText");
    private static final String DEFAULT_RADIO_TEXT = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_DefaultRadioText");
    private static final String DEFAULT_RADIO_ACCESS_DESCR = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_DefaultRadioAccessDescr");
    private static final String EXISTING_RADIO_TEXT = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_ExistingRadioText");
    private static final String EXISTING_RADIO_ACCESS_DESCR = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_ExistingRadioAccessDescr");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(NewCustomConfiguration.class, (String)"NewCustomConfiguration_OkButtonText");
    private static final int MODE_NEW_ANY = 0;
    private static final int MODE_NEW_TYPE = 1;
    private static final int MODE_DUPLICATE = 2;
    private static final int MODE_RENAME = 4;
    private static NewCustomConfiguration defaultInstance;
    private static final Icon ICON_MONITOR;
    private static final Icon ICON_CPU;
    private static final Icon ICON_MEMORY;
    private DefaultListModel existingSettingsListModel;
    private JButton okButton;
    private JLabel nameLabel;
    private JLabel settingsLabel;
    private JLabel typeLabel;
    private JList existingSettingsList;
    private JPanel bottomRenameSpacer;
    private JRadioButton cpuTypeRadio;
    private JRadioButton defaultSettingsRadio;
    private JRadioButton existingSettingsRadio;
    private JRadioButton memoryTypeRadio;
    private JRadioButton monitorTypeRadio;
    private JScrollPane existingSettingsScrollPane;
    private JTextField nameTextfield;
    private ProfilingSettings originalSettings = null;
    private ProfilingSettings[] availableSettings;
    private int mode;

    private NewCustomConfiguration() {
        this.initComponents();
    }

    public static ProfilingSettings createDuplicateConfiguration(ProfilingSettings profilingSettings, ProfilingSettings[] profilingSettingsArray) {
        NewCustomConfiguration newCustomConfiguration = NewCustomConfiguration.getDefault();
        newCustomConfiguration.setupDuplicateConfiguration(profilingSettings, profilingSettingsArray);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newCustomConfiguration, MessageFormat.format(DUPLICATE_CONFIG_DIALOG_CAPTION, profilingSettings.getSettingsName()));
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        ProfilingSettings profilingSettings2 = null;
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            profilingSettings2 = newCustomConfiguration.getProfilingSettings();
        }
        return profilingSettings2;
    }

    public static ProfilingSettings createNewConfiguration(ProfilingSettings[] profilingSettingsArray) {
        NewCustomConfiguration newCustomConfiguration = NewCustomConfiguration.getDefault();
        newCustomConfiguration.setupUniversalConfiguration(profilingSettingsArray);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newCustomConfiguration, NEW_CONFIG_DIALOG_CAPTION);
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        ProfilingSettings profilingSettings = null;
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            profilingSettings = newCustomConfiguration.getProfilingSettings();
        }
        return profilingSettings;
    }

    public static ProfilingSettings createNewConfiguration(int n, ProfilingSettings[] profilingSettingsArray) {
        NewCustomConfiguration newCustomConfiguration = NewCustomConfiguration.getDefault();
        newCustomConfiguration.setupTypeConfiguration(n, profilingSettingsArray);
        String string = "";
        if (Utils.isMonitorSettings(n)) {
            string = " (" + MONITOR_STRING + ")";
        } else if (Utils.isCPUSettings(n)) {
            string = " (" + CPU_STRING + ")";
        } else if (Utils.isMemorySettings(n)) {
            string = " (" + MEMORY_STRING + ")";
        }
        string = string.replace("&", "");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newCustomConfiguration, NEW_CONFIG_DIALOG_CAPTION + string, true, new Object[]{newCustomConfiguration.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)newCustomConfiguration.okButton, 0, null, null);
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        ProfilingSettings profilingSettings = null;
        if (dialogDescriptor.getValue() == newCustomConfiguration.okButton) {
            profilingSettings = newCustomConfiguration.getProfilingSettings();
        }
        return profilingSettings;
    }

    public static ProfilingSettings renameConfiguration(ProfilingSettings profilingSettings, ProfilingSettings[] profilingSettingsArray) {
        NewCustomConfiguration newCustomConfiguration = NewCustomConfiguration.getDefault();
        newCustomConfiguration.setupRenameConfiguration(profilingSettings, profilingSettingsArray);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newCustomConfiguration, MessageFormat.format(RENAME_CONFIG_DIALOG_CAPTION, profilingSettings.getSettingsName()));
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        ProfilingSettings profilingSettings2 = null;
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            profilingSettings2 = newCustomConfiguration.getProfilingSettings();
        }
        return profilingSettings2;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateOKButton();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateOKButton();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateOKButton();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.existingSettingsList.setEnabled(this.existingSettingsRadio.isSelected());
        if (this.existingSettingsRadio.isEnabled() && this.defaultSettingsRadio.isSelected()) {
            this.existingSettingsList.clearSelection();
        }
        this.updateOKButton();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateOKButton();
    }

    private static NewCustomConfiguration getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new NewCustomConfiguration();
        }
        return defaultInstance;
    }

    private ProfilingSettings getProfilingSettings() {
        ProfilingSettings profilingSettings = null;
        if (this.mode == 4) {
            profilingSettings = this.originalSettings;
        } else if (this.mode == 2 || (this.mode == 0 || this.mode == 1) && this.existingSettingsRadio.isSelected()) {
            profilingSettings = new ProfilingSettings();
            this.availableSettings[this.existingSettingsList.getSelectedIndex()].copySettingsInto(profilingSettings);
        } else if (this.monitorTypeRadio.isSelected()) {
            profilingSettings = ProfilingSettingsPresets.createMonitorPreset();
            profilingSettings.setIsPreset(false);
        } else if (this.cpuTypeRadio.isSelected()) {
            profilingSettings = ProfilingSettingsPresets.createCPUPreset();
            profilingSettings.setIsPreset(false);
        } else if (this.memoryTypeRadio.isSelected()) {
            profilingSettings = ProfilingSettingsPresets.createMemoryPreset();
            profilingSettings.setIsPreset(false);
        }
        profilingSettings.setSettingsName(this.nameTextfield.getText().trim());
        return profilingSettings;
    }

    private String createSettingsName(ProfilingSettings[] profilingSettingsArray) {
        String string = NEW_CONFIG_STRING;
        if (this.monitorTypeRadio.isSelected()) {
            string = NEW_MONITOR_STRING;
        } else if (this.cpuTypeRadio.isSelected()) {
            string = NEW_CPU_STRING;
        } else if (this.memoryTypeRadio.isSelected()) {
            string = NEW_MEMORY_STRING;
        }
        ArrayList<String> arrayList = new ArrayList<String>(profilingSettingsArray.length);
        for (ProfilingSettings profilingSettings : profilingSettingsArray) {
            arrayList.add(profilingSettings.getSettingsName());
        }
        int n = 0;
        String string2 = "";
        while (arrayList.contains(string + string2)) {
            string2 = " " + Integer.toString(++n);
        }
        return string + string2;
    }

    private void showTypeSettings() {
        this.typeLabel.setVisible(true);
        this.monitorTypeRadio.setVisible(true);
        this.cpuTypeRadio.setVisible(true);
        this.memoryTypeRadio.setVisible(true);
    }

    private void hideTypeSettings() {
        this.typeLabel.setVisible(false);
        this.monitorTypeRadio.setVisible(false);
        this.cpuTypeRadio.setVisible(false);
        this.memoryTypeRadio.setVisible(false);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.typeLabel = new JLabel(TYPE_LABEL_TEXT);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 0, 0);
        this.add((Component)this.typeLabel, gridBagConstraints);
        this.monitorTypeRadio = new JExtendedRadioButton(MONITOR_STRING, ICON_MONITOR);
        Mnemonics.setLocalizedText((AbstractButton)this.monitorTypeRadio, (String)MONITOR_STRING);
        buttonGroup.add(this.monitorTypeRadio);
        this.monitorTypeRadio.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 5, 0, 0);
        this.add((Component)this.monitorTypeRadio, gridBagConstraints);
        this.cpuTypeRadio = new JExtendedRadioButton(CPU_STRING, ICON_CPU);
        Mnemonics.setLocalizedText((AbstractButton)this.cpuTypeRadio, (String)CPU_STRING);
        buttonGroup.add(this.cpuTypeRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 5, 0, 0);
        this.add((Component)this.cpuTypeRadio, gridBagConstraints);
        this.memoryTypeRadio = new JExtendedRadioButton(MEMORY_STRING, ICON_MEMORY);
        Mnemonics.setLocalizedText((AbstractButton)this.memoryTypeRadio, (String)MEMORY_STRING);
        buttonGroup.add(this.memoryTypeRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 5, 0, 10);
        this.add((Component)this.memoryTypeRadio, gridBagConstraints);
        this.nameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NAME_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextfield = new JTextField();
        this.nameTextfield.getDocument().addDocumentListener(this);
        this.nameTextfield.setPreferredSize(new Dimension(250, this.nameTextfield.getPreferredSize().height));
        this.nameTextfield.getAccessibleContext().setAccessibleDescription(NAME_LABEL_ACCESS_DESCR);
        this.nameLabel.setLabelFor(this.nameTextfield);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 0, 10);
        this.add((Component)this.nameTextfield, gridBagConstraints);
        this.settingsLabel = new JLabel(INIT_SETTINGS_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.settingsLabel, gridBagConstraints);
        this.defaultSettingsRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.defaultSettingsRadio, (String)DEFAULT_RADIO_TEXT);
        buttonGroup2.add(this.defaultSettingsRadio);
        this.defaultSettingsRadio.getAccessibleContext().setAccessibleDescription(DEFAULT_RADIO_ACCESS_DESCR);
        this.defaultSettingsRadio.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.add((Component)this.defaultSettingsRadio, gridBagConstraints);
        this.existingSettingsRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.existingSettingsRadio, (String)EXISTING_RADIO_TEXT);
        buttonGroup2.add(this.existingSettingsRadio);
        this.existingSettingsRadio.getAccessibleContext().setAccessibleDescription(EXISTING_RADIO_ACCESS_DESCR);
        this.existingSettingsRadio.setSelected(true);
        this.existingSettingsRadio.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 0, 10);
        this.add((Component)this.existingSettingsRadio, gridBagConstraints);
        this.existingSettingsListModel = new DefaultListModel();
        this.existingSettingsList = new JList(this.existingSettingsListModel);
        this.existingSettingsList.setVisibleRowCount(5);
        this.existingSettingsList.addListSelectionListener(this);
        this.existingSettingsScrollPane = new JScrollPane(this.existingSettingsList, 20, 31);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 5, 15, 10);
        this.add((Component)this.existingSettingsScrollPane, gridBagConstraints);
        this.bottomRenameSpacer = Utils.createFillerPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.bottomRenameSpacer, gridBagConstraints);
        this.okButton = new JButton(OK_BUTTON_TEXT);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && NewCustomConfiguration.this.isShowing()) {
                    NewCustomConfiguration.this.nameTextfield.requestFocusInWindow();
                    NewCustomConfiguration.this.nameTextfield.selectAll();
                }
            }
        });
    }

    private void setupDuplicateConfiguration(ProfilingSettings profilingSettings, ProfilingSettings[] profilingSettingsArray) {
        this.mode = 2;
        this.originalSettings = profilingSettings;
        this.availableSettings = profilingSettingsArray;
        this.monitorTypeRadio.setEnabled(Utils.isMonitorSettings(this.originalSettings));
        this.monitorTypeRadio.setSelected(this.monitorTypeRadio.isEnabled());
        this.cpuTypeRadio.setEnabled(Utils.isCPUSettings(this.originalSettings));
        this.cpuTypeRadio.setSelected(this.cpuTypeRadio.isEnabled());
        this.memoryTypeRadio.setEnabled(Utils.isMemorySettings(this.originalSettings));
        this.memoryTypeRadio.setSelected(this.memoryTypeRadio.isEnabled());
        this.hideTypeSettings();
        this.settingsLabel.setVisible(true);
        this.defaultSettingsRadio.setVisible(true);
        this.existingSettingsRadio.setVisible(true);
        this.existingSettingsScrollPane.setVisible(true);
        this.bottomRenameSpacer.setVisible(false);
        this.defaultSettingsRadio.setEnabled(false);
        this.existingSettingsRadio.setEnabled(false);
        this.existingSettingsRadio.setSelected(true);
        this.existingSettingsList.setEnabled(false);
        this.nameTextfield.setText(this.createSettingsName(profilingSettingsArray));
        this.updateAvailableSettings();
        for (int i = 0; i < profilingSettingsArray.length; ++i) {
            if (this.originalSettings != profilingSettingsArray[i]) continue;
            this.existingSettingsList.setSelectedIndex(i);
            return;
        }
        this.updateOKButton();
    }

    private void setupRenameConfiguration(ProfilingSettings profilingSettings, ProfilingSettings[] profilingSettingsArray) {
        this.mode = 4;
        this.originalSettings = profilingSettings;
        this.availableSettings = profilingSettingsArray;
        this.monitorTypeRadio.setEnabled(Utils.isMonitorSettings(this.originalSettings));
        this.monitorTypeRadio.setSelected(this.monitorTypeRadio.isEnabled());
        this.cpuTypeRadio.setEnabled(Utils.isCPUSettings(this.originalSettings));
        this.cpuTypeRadio.setSelected(this.cpuTypeRadio.isEnabled());
        this.memoryTypeRadio.setEnabled(Utils.isMemorySettings(this.originalSettings));
        this.memoryTypeRadio.setSelected(this.memoryTypeRadio.isEnabled());
        this.hideTypeSettings();
        this.settingsLabel.setVisible(false);
        this.defaultSettingsRadio.setVisible(false);
        this.existingSettingsRadio.setVisible(false);
        this.existingSettingsScrollPane.setVisible(false);
        this.bottomRenameSpacer.setVisible(true);
        this.nameTextfield.setText(profilingSettings.getSettingsName());
        this.updateAvailableSettings();
        this.updateOKButton();
    }

    private void setupTypeConfiguration(int n, ProfilingSettings[] profilingSettingsArray) {
        this.mode = 1;
        this.originalSettings = null;
        this.availableSettings = profilingSettingsArray;
        this.monitorTypeRadio.setEnabled(Utils.isMonitorSettings(n));
        this.monitorTypeRadio.setSelected(this.monitorTypeRadio.isEnabled());
        this.cpuTypeRadio.setEnabled(Utils.isCPUSettings(n));
        this.cpuTypeRadio.setSelected(this.cpuTypeRadio.isEnabled());
        this.memoryTypeRadio.setEnabled(Utils.isMemorySettings(n));
        this.memoryTypeRadio.setSelected(this.memoryTypeRadio.isEnabled());
        this.hideTypeSettings();
        this.settingsLabel.setVisible(true);
        this.defaultSettingsRadio.setVisible(true);
        this.existingSettingsRadio.setVisible(true);
        this.existingSettingsScrollPane.setVisible(true);
        this.bottomRenameSpacer.setVisible(false);
        this.defaultSettingsRadio.setEnabled(true);
        this.defaultSettingsRadio.setSelected(true);
        this.existingSettingsRadio.setEnabled(true);
        this.nameTextfield.setText(this.createSettingsName(profilingSettingsArray));
        this.updateAvailableSettings();
        this.updateOKButton();
    }

    private void setupUniversalConfiguration(ProfilingSettings[] profilingSettingsArray) {
        this.mode = 0;
        this.originalSettings = null;
        this.availableSettings = profilingSettingsArray;
        this.monitorTypeRadio.setEnabled(true);
        this.cpuTypeRadio.setEnabled(true);
        this.cpuTypeRadio.setSelected(true);
        this.memoryTypeRadio.setEnabled(true);
        this.showTypeSettings();
        this.settingsLabel.setVisible(true);
        this.defaultSettingsRadio.setVisible(true);
        this.existingSettingsRadio.setVisible(true);
        this.existingSettingsScrollPane.setVisible(true);
        this.bottomRenameSpacer.setVisible(false);
        this.defaultSettingsRadio.setEnabled(true);
        this.defaultSettingsRadio.setSelected(true);
        this.existingSettingsRadio.setEnabled(true);
        this.nameTextfield.setText(this.createSettingsName(profilingSettingsArray));
        this.updateAvailableSettings();
        this.updateOKButton();
    }

    private void updateAvailableSettings() {
        this.existingSettingsListModel.removeAllElements();
        for (ProfilingSettings profilingSettings : this.availableSettings) {
            this.existingSettingsListModel.addElement(profilingSettings.getSettingsName());
        }
    }

    private void updateOKButton() {
        this.okButton.setEnabled(this.nameTextfield.getText().trim().length() > 0 && (this.defaultSettingsRadio.isSelected() || this.existingSettingsList.getSelectedIndex() != -1));
    }

    static {
        ICON_MONITOR = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/telemetryWindow.png", (boolean)false);
        ICON_CPU = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/cpu.png", (boolean)false);
        ICON_MEMORY = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/memory.png", (boolean)false);
    }
}

