/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.naming;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.FolderName;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.util.CharSequences;

public class FileName
implements FileNaming {
    private final CharSequence name;
    private final FileNaming parent;
    private final Integer id;
    private CharSequence currentName;

    protected FileName(FileNaming fileNaming, File file) {
        this.parent = fileNaming;
        this.name = CharSequences.create((CharSequence)FileName.parseName(fileNaming, file));
        this.id = NamingFactory.createID(file);
        this.currentName = this.name;
    }

    private static String parseName(FileNaming fileNaming, File file) {
        return fileNaming == null ? file.getPath() : file.getName();
    }

    @Override
    public FileNaming rename(String string, ProvidedExtensions.IOHandler iOHandler) throws IOException {
        boolean bl = false;
        File file = this.getFile();
        if (FileChangedManager.getInstance().exists(file)) {
            File file2 = new File(file.getParentFile(), string);
            if (iOHandler != null) {
                iOHandler.handle();
                bl = true;
            } else {
                bl = file.renameTo(file2);
            }
            if (bl) {
                FolderName.freeCaches();
                return NamingFactory.fromFile(this.getParent(), file2, true);
            }
        }
        return this;
    }

    @Override
    public final boolean isRoot() {
        return this.getParent() == null;
    }

    @Override
    public File getFile() {
        FileNaming fileNaming = this.getParent();
        return fileNaming != null ? new File(fileNaming.getFile(), this.getName()) : new File(this.getName());
    }

    @Override
    public final String getName() {
        return ((Object)this.currentName).toString();
    }

    @Override
    public FileNaming getParent() {
        return this.parent;
    }

    @Override
    public final Integer getId() {
        return this.id;
    }

    public final boolean equals(Object object) {
        if (object instanceof FileName) {
            FileName fileName = (FileName)object;
            if (object.hashCode() != this.hashCode()) {
                return false;
            }
            if (!this.name.equals(fileName.name)) {
                return false;
            }
            if (this.parent == null || fileName.parent == null) {
                return this.parent == null && fileName.parent == null;
            }
            return this.parent.equals(fileName.parent);
        }
        return object instanceof FileNaming && object.hashCode() == this.hashCode();
    }

    public final String toString() {
        return this.getFile().getAbsolutePath();
    }

    public final int hashCode() {
        return this.id;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return !this.isFile();
    }

    void updateCase(String string) {
        assert (String.CASE_INSENSITIVE_ORDER.compare(string, ((Object)this.name).toString()) == 0) : "Only case can be changed. Was: " + this.name + " name: " + string;
        this.currentName = CharSequences.create((CharSequence)string);
    }
}

