/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class LocaleVariants
implements Stamps.Updater {
    private static final Logger err = Util.err;
    private static final Map<File, List<FileWithSuffix>> map;
    private static Locale mapLocale;
    private static LocaleVariants UPDATER;
    private static String[] suffixes;
    private static Locale lastLocale;
    private static String lastBranding;

    private LocaleVariants() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushCaches(DataOutputStream dataOutputStream) throws IOException {
        Map<File, List<FileWithSuffix>> map = LocaleVariants.map;
        synchronized (map) {
            dataOutputStream.writeUTF(mapLocale.toString());
            for (Map.Entry<File, List<FileWithSuffix>> entry : LocaleVariants.map.entrySet()) {
                dataOutputStream.writeUTF(entry.getKey().getPath());
                for (FileWithSuffix fileWithSuffix : entry.getValue()) {
                    fileWithSuffix.write(dataOutputStream);
                }
                dataOutputStream.writeUTF("");
            }
            dataOutputStream.writeUTF("");
        }
    }

    @Override
    public void cacheReady() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCaches() {
        Map<File, List<FileWithSuffix>> map = LocaleVariants.map;
        synchronized (map) {
            LocaleVariants.map.clear();
        }
    }

    static List<File> findLocaleVariantsOf(File file) {
        List<FileWithSuffix> list = LocaleVariants.findLocaleVariantsWithSuffixesOf(file);
        ArrayList<File> arrayList = new ArrayList<File>(list.size());
        for (FileWithSuffix fileWithSuffix : list) {
            arrayList.add(fileWithSuffix.file);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<FileWithSuffix> findLocaleVariantsWithSuffixesOf(File file) {
        Object object;
        Object object2 = map;
        synchronized (object2) {
            if (mapLocale != Locale.getDefault()) {
                map.clear();
                mapLocale = Locale.getDefault();
            }
            if ((object = map.get(file)) != null) {
                return object;
            }
        }
        if (!file.isFile()) {
            object = Collections.emptyList();
        } else {
            String string;
            String string2;
            object2 = null;
            Object object3 = LocaleVariants.findLogicalPath(file);
            if (object3 != null) {
                int n = ((String)object3).lastIndexOf(47);
                object2 = n != -1 ? ((String)object3).substring(0, n + 1) + "locale/" : "locale/";
            }
            object3 = new ArrayList(7);
            String string3 = file.getName();
            int n = string3.lastIndexOf(46);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n);
            } else {
                string2 = string3;
                string = "";
            }
            if (object2 != null) {
                for (String string4 : LocaleVariants.getLocalizingSuffixesFast()) {
                    String string5 = (String)object2 + string2 + string4 + string;
                    File file2 = InstalledFileLocator.getDefault().locate(string5, null, false);
                    if (file2 == null) continue;
                    object3.add(new FileWithSuffix(file2, string4));
                }
            } else {
                File file3 = new File(file.getParentFile(), "locale");
                if (file3.exists()) {
                    for (String string6 : LocaleVariants.getLocalizingSuffixesFast()) {
                        File file4 = new File(file3, string2 + string6 + string);
                        if (!file4.isFile()) continue;
                        object3.add(new FileWithSuffix(file4, string6));
                    }
                }
            }
            object = object3;
        }
        object2 = map;
        synchronized (object2) {
            map.put(file, (List<FileWithSuffix>)object);
        }
        if (UPDATER == null) {
            UPDATER = new LocaleVariants();
            Stamps.getModulesJARs().scheduleSave(UPDATER, "localeVariants", false);
        }
        return object;
    }

    static synchronized String[] getLocalizingSuffixesFast() {
        if (suffixes == null || Locale.getDefault() != lastLocale || !Utilities.compareObjects((Object)NbBundle.getBranding(), (Object)lastBranding)) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = NbBundle.getLocalizingSuffixes();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            suffixes = arrayList.toArray(new String[arrayList.size()]);
            lastLocale = Locale.getDefault();
            lastBranding = NbBundle.getBranding();
        }
        return suffixes;
    }

    private static String findLogicalPath(File file) {
        InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
        String string = file.getName();
        for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
            File file3 = installedFileLocator.locate(string, null, false);
            if (file.equals(file3)) {
                return string;
            }
            string = file2.getName() + '/' + string;
        }
        return null;
    }

    static {
        InputStream inputStream = Stamps.getModulesJARs().asStream("localeVariants");
        HashMap<File, List<FileWithSuffix>> hashMap = new HashMap<File, List<FileWithSuffix>>();
        if (inputStream != null) {
            try {
                String string;
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                String string2 = dataInputStream.readUTF();
                Locale locale = mapLocale = Locale.getDefault().toString().equals(string2) ? Locale.getDefault() : null;
                while ((string = dataInputStream.readUTF()).length() != 0) {
                    FileWithSuffix fileWithSuffix;
                    ArrayList<FileWithSuffix> arrayList = new ArrayList<FileWithSuffix>();
                    while ((fileWithSuffix = FileWithSuffix.read(dataInputStream)) != null) {
                        arrayList.add(fileWithSuffix);
                    }
                    hashMap.put(new File(string), arrayList);
                }
                dataInputStream.close();
            }
            catch (IOException iOException) {
                err.log(Level.WARNING, "Cannot read localeVariants cache", iOException);
                hashMap.clear();
            }
        }
        map = hashMap;
        suffixes = null;
        lastLocale = null;
        lastBranding = null;
    }

    static final class FileWithSuffix {
        public final File file;
        public final String suffix;

        FileWithSuffix(File file, String string) {
            this.file = file;
            this.suffix = string;
        }

        static FileWithSuffix read(DataInputStream dataInputStream) throws IOException {
            String string = dataInputStream.readUTF();
            if (string.length() == 0) {
                return null;
            }
            String string2 = dataInputStream.readUTF();
            return new FileWithSuffix(new File(string), string2);
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeUTF(this.file.getPath());
            dataOutputStream.writeUTF(this.suffix);
        }
    }
}

