/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.win32;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.DebugEvent;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.debugger.cdbg.ProcessControl;
import sun.jvm.hotspot.debugger.cdbg.basic.x86.X86CFrame;
import sun.jvm.hotspot.debugger.win32.Win32Debugger;
import sun.jvm.hotspot.debugger.x86.X86ThreadContext;
import sun.jvm.hotspot.utilities.AddressOps;

class Win32CDebugger
implements CDebugger,
ProcessControl {
    private Win32Debugger dbg;

    Win32CDebugger(Win32Debugger dbg) {
        this.dbg = dbg;
    }

    public List getThreadList() throws DebuggerException {
        return this.dbg.getThreadList();
    }

    public List getLoadObjectList() throws DebuggerException {
        return this.dbg.getLoadObjectList();
    }

    public LoadObject loadObjectContainingPC(Address pc) throws DebuggerException {
        if (pc == null) {
            return null;
        }
        List objs = this.getLoadObjectList();
        Iterator iter = objs.iterator();
        while (iter.hasNext()) {
            LoadObject obj = (LoadObject)iter.next();
            if (!AddressOps.lte(obj.getBase(), pc) || pc.minus(obj.getBase()) >= obj.getSize()) continue;
            return obj;
        }
        return null;
    }

    public CFrame topFrameForThread(ThreadProxy thread) throws DebuggerException {
        X86ThreadContext context = (X86ThreadContext)thread.getContext();
        Address ebp = context.getRegisterAsAddress(6);
        if (ebp == null) {
            return null;
        }
        Address pc = context.getRegisterAsAddress(14);
        if (pc == null) {
            return null;
        }
        return new X86CFrame(this, ebp, pc);
    }

    public String getNameOfFile(String fileName) {
        return new File(fileName).getName();
    }

    public ProcessControl getProcessControl() throws DebuggerException {
        return this;
    }

    public boolean canDemangle() {
        return false;
    }

    public String demangle(String sym) {
        throw new UnsupportedOperationException();
    }

    public void suspend() throws DebuggerException {
        this.dbg.suspend();
    }

    public void resume() throws DebuggerException {
        this.dbg.resume();
    }

    public boolean isSuspended() throws DebuggerException {
        return this.dbg.isSuspended();
    }

    public void setBreakpoint(Address addr) throws DebuggerException {
        this.dbg.setBreakpoint(addr);
    }

    public void clearBreakpoint(Address addr) throws DebuggerException {
        this.dbg.clearBreakpoint(addr);
    }

    public boolean isBreakpointSet(Address addr) throws DebuggerException {
        return this.dbg.isBreakpointSet(addr);
    }

    public DebugEvent debugEventPoll() throws DebuggerException {
        return this.dbg.debugEventPoll();
    }

    public void debugEventContinue() throws DebuggerException {
        this.dbg.debugEventContinue();
    }
}

