/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.compiler;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.CompressedWriteStream;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class OopMap
extends VMObject {
    private static CIntegerField pcOffsetField;
    private static CIntegerField omvCountField;
    private static CIntegerField omvDataSizeField;
    private static AddressField omvDataField;
    private static AddressField compressedWriteStreamField;
    private static AddressField compressedStreamBufferField;

    private static void initialize(TypeDataBase db) {
        Type type = db.lookupType("OopMap");
        pcOffsetField = type.getCIntegerField("_pc_offset");
        omvCountField = type.getCIntegerField("_omv_count");
        omvDataSizeField = type.getCIntegerField("_omv_data_size");
        omvDataField = type.getAddressField("_omv_data");
        compressedWriteStreamField = type.getAddressField("_write_stream");
        type = db.lookupType("CompressedStream");
        compressedStreamBufferField = type.getAddressField("_buffer");
    }

    public OopMap(Address addr) {
        super(addr);
    }

    public long getOffset() {
        return pcOffsetField.getValue(this.addr);
    }

    Address getOMVData() {
        return omvDataField.getValue(this.addr);
    }

    long getOMVDataSize() {
        return omvDataSizeField.getValue(this.addr);
    }

    long getOMVCount() {
        return omvCountField.getValue(this.addr);
    }

    CompressedWriteStream getWriteStream() {
        Address wsAddr = compressedWriteStreamField.getValue(this.addr);
        if (wsAddr == null) {
            return null;
        }
        Address bufferAddr = compressedStreamBufferField.getValue(wsAddr);
        if (bufferAddr == null) {
            return null;
        }
        return new CompressedWriteStream(bufferAddr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                OopMap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

