/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.sparc.InstructionDecoder;
import sun.jvm.hotspot.asm.sparc.RegisterDecoder;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisterIndirectAddress;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;
import sun.jvm.hotspot.asm.sparc.SPARCV9InstructionFactory;

abstract class MemoryInstructionDecoder
extends InstructionDecoder {
    final int op3;
    final String name;
    final int dataType;

    SPARCRegisterIndirectAddress newRegisterIndirectAddress(SPARCRegister rs1, SPARCRegister rs2) {
        return new SPARCRegisterIndirectAddress(rs1, rs2);
    }

    SPARCRegisterIndirectAddress newRegisterIndirectAddress(SPARCRegister rs1, int offset) {
        return new SPARCRegisterIndirectAddress(rs1, offset);
    }

    static void setAddressSpace(int instruction, SPARCRegisterIndirectAddress addr) {
        int asi = (instruction & 0x1FE0) >>> 5;
        addr.setAddressSpace(asi);
    }

    SPARCRegisterIndirectAddress getRegisterIndirectAddress(int instruction) {
        SPARCRegister rs1 = SPARCRegisters.getRegister(MemoryInstructionDecoder.getSourceRegister1(instruction));
        boolean iBit = MemoryInstructionDecoder.isIBitSet(instruction);
        SPARCRegisterIndirectAddress addr = null;
        if (iBit) {
            int simm13 = MemoryInstructionDecoder.extractSignedIntFromNBits(instruction, 13);
            addr = this.newRegisterIndirectAddress(rs1, simm13);
        } else {
            SPARCRegister rs2 = SPARCRegisters.getRegister(MemoryInstructionDecoder.getSourceRegister2(instruction));
            addr = this.newRegisterIndirectAddress(rs1, rs2);
        }
        return addr;
    }

    MemoryInstructionDecoder(int op3, String name, int dataType) {
        this.op3 = op3;
        this.name = name;
        this.dataType = dataType;
    }

    Instruction decode(int instruction, SPARCInstructionFactory factory) {
        SPARCRegisterIndirectAddress addr = this.getRegisterIndirectAddress(instruction);
        SPARCRegister rd = this.getDestination(instruction);
        boolean isV9Okay = factory instanceof SPARCV9InstructionFactory;
        if (rd == null || !isV9Okay && rd.isV9Only()) {
            return factory.newIllegalInstruction(instruction);
        }
        return this.decodeMemoryInstruction(instruction, addr, rd, factory);
    }

    SPARCRegister getDestination(int instruction) {
        int rdNum = MemoryInstructionDecoder.getDestinationRegister(instruction);
        SPARCRegister rd = RegisterDecoder.decode(this.dataType, rdNum);
        return rd;
    }

    abstract Instruction decodeMemoryInstruction(int var1, SPARCRegisterIndirectAddress var2, SPARCRegister var3, SPARCInstructionFactory var4);
}

