/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import org.netbeans.beaninfo.editors.StringCustomEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class StringEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static boolean useRaw = Boolean.getBoolean("netbeans.stringEditor.useRawCharacters");
    private boolean editable = true;
    private String instructions = null;
    private boolean oneline = false;
    private boolean customEd = true;
    private PropertyEnv env;

    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setAsText(String string) {
        if ("null".equals(string) && this.getValue() == null) {
            return;
        }
        this.setValue(string);
    }

    @Override
    public String getJavaInitializationString() {
        String string = (String)this.getValue();
        return "\"" + StringEditor.toAscii(string) + "\"";
    }

    @Override
    public boolean supportsCustomEditor() {
        return this.customEd;
    }

    @Override
    public Component getCustomEditor() {
        Object object = this.getValue();
        String string = "";
        if (object != null) {
            string = object instanceof String ? (String)object : object.toString();
        }
        return new StringCustomEditor(string, this.isEditable(), this.oneline, this.instructions, this, this.env);
    }

    private static String toAscii(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 6);
        char[] cArray = string.toCharArray();
        block9: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c >= ' ' && (useRaw || c <= '\u007f')) {
                        stringBuffer.append(c);
                        continue block9;
                    }
                    stringBuffer.append("\\u");
                    String string2 = Integer.toHexString(c);
                    for (int j = 0; j < 4 - string2.length(); ++j) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        if (featureDescriptor instanceof Node.Property) {
            Node.Property property = (Node.Property)featureDescriptor;
            this.editable = property.canWrite();
            this.instructions = (String)property.getValue("instructions");
            this.oneline = Boolean.TRUE.equals(property.getValue("oneline"));
            this.customEd = !Boolean.TRUE.equals(property.getValue("suppressCustomEditor"));
        }
    }
}

