/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbAsRep;
import sun.security.krb5.KrbAsReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.ccache.Credentials;
import sun.security.krb5.internal.ccache.CredentialsCache;
import sun.security.krb5.internal.tools.KinitOptions;

public class Kinit {
    private KinitOptions options;
    private static final boolean DEBUG = Krb5.DEBUG;

    public static void main(String[] stringArray) {
        try {
            Kinit kinit = new Kinit(stringArray);
        }
        catch (Exception exception) {
            String string = null;
            string = exception instanceof KrbException ? ((KrbException)exception).krbErrorMessage() + " " + ((KrbException)exception).returnCodeMessage() : exception.getMessage();
            if (string != null) {
                System.err.println("Exception: " + string);
            } else {
                System.out.println("Exception: " + exception);
            }
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private Kinit(String[] stringArray) throws IOException, RealmException, KrbException {
        Object object;
        Object object2;
        Config config = Config.getInstance();
        this.options = stringArray == null || stringArray.length == 0 ? new KinitOptions() : new KinitOptions(stringArray);
        String string = null;
        PrincipalName principalName = this.options.getPrincipal();
        if (principalName != null) {
            string = principalName.toString();
        }
        if (DEBUG) {
            System.out.println("Principal is " + principalName);
        }
        char[] cArray = this.options.password;
        EncryptionKey[] encryptionKeyArray = null;
        boolean bl = this.options.useKeytabFile();
        if (!bl) {
            if (string == null) {
                throw new IllegalArgumentException(" Can not obtain principal name");
            }
            if (cArray == null) {
                object2 = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Password for " + string + ":");
                System.out.flush();
                cArray = ((BufferedReader)object2).readLine().toCharArray();
                if (DEBUG) {
                    System.out.println(">>> Kinit console input " + new String(cArray));
                }
            }
        } else {
            if (DEBUG) {
                System.out.println(">>> Kinit using keytab");
            }
            if (string == null) {
                throw new IllegalArgumentException("Principal name must be specified.");
            }
            object2 = this.options.keytabFileName();
            if (object2 != null && DEBUG) {
                System.out.println(">>> Kinit keytab file name: " + (String)object2);
            }
            if ((encryptionKeyArray = EncryptionKey.acquireSecretKeys(principalName, (String)object2)) == null || encryptionKeyArray.length == 0) {
                String string2 = "No supported key found in keytab";
                if (string != null) {
                    string2 = string2 + " for principal " + string;
                }
                throw new KrbException(string2);
            }
        }
        object2 = new KDCOptions();
        Kinit.setOptions(1, this.options.forwardable, (KDCOptions)object2);
        Kinit.setOptions(3, this.options.proxiable, (KDCOptions)object2);
        String string3 = this.options.getKDCRealm();
        if (string3 == null) {
            string3 = config.getDefaultRealm();
        }
        if (DEBUG) {
            System.out.println(">>> Kinit realm name is " + string3);
        }
        PrincipalName principalName2 = new PrincipalName("krbtgt/" + string3);
        principalName2.setRealm(string3);
        if (DEBUG) {
            System.out.println(">>> Creating KrbAsReq");
        }
        KrbAsReq krbAsReq = null;
        HostAddresses hostAddresses = null;
        try {
            if (this.options.getAddressOption()) {
                hostAddresses = HostAddresses.getLocalAddresses();
            }
            krbAsReq = bl ? new KrbAsReq(encryptionKeyArray, (KDCOptions)object2, principalName, principalName2, null, null, null, null, hostAddresses, null) : new KrbAsReq(cArray, (KDCOptions)object2, principalName, principalName2, null, null, null, null, hostAddresses, null);
        }
        catch (KrbException krbException) {
            throw krbException;
        }
        catch (Exception exception) {
            throw new KrbException(exception.toString());
        }
        KrbAsRep krbAsRep = null;
        try {
            krbAsRep = Kinit.sendASRequest(krbAsReq, bl, string3, cArray, encryptionKeyArray);
        }
        catch (KrbException krbException) {
            if (krbException.returnCode() == 24 || krbException.returnCode() == 25) {
                if (DEBUG) {
                    System.out.println("Kinit: PREAUTH FAILED/REQ, re-send AS-REQ");
                }
                object = krbException.getError();
                int n = ((KRBError)object).getEType();
                byte[] byArray = ((KRBError)object).getSalt();
                byte[] byArray2 = ((KRBError)object).getParams();
                krbAsReq = bl ? new KrbAsReq(encryptionKeyArray, true, n, byArray, byArray2, (KDCOptions)object2, principalName, principalName2, null, null, null, null, hostAddresses, null) : new KrbAsReq(cArray, true, n, byArray, byArray2, (KDCOptions)object2, principalName, principalName2, null, null, null, null, hostAddresses, null);
                krbAsRep = Kinit.sendASRequest(krbAsReq, bl, string3, cArray, encryptionKeyArray);
            }
            throw krbException;
        }
        Credentials credentials = krbAsRep.setCredentials();
        object = CredentialsCache.create(principalName, this.options.cachename);
        if (object == null) {
            throw new IOException("Unable to create the cache file " + this.options.cachename);
        }
        ((CredentialsCache)object).update(credentials);
        ((CredentialsCache)object).save();
        if (this.options.password == null) {
            System.out.println("New ticket is stored in cache file " + this.options.cachename);
        } else {
            Arrays.fill(this.options.password, '0');
        }
        if (cArray != null) {
            Arrays.fill(cArray, '0');
        }
        this.options = null;
    }

    private static KrbAsRep sendASRequest(KrbAsReq krbAsReq, boolean bl, String string, char[] cArray, EncryptionKey[] encryptionKeyArray) throws IOException, RealmException, KrbException {
        if (DEBUG) {
            System.out.println(">>> Kinit: sending as_req to realm " + string);
        }
        String string2 = krbAsReq.send(string);
        if (DEBUG) {
            System.out.println(">>> reading response from kdc");
        }
        KrbAsRep krbAsRep = null;
        try {
            krbAsRep = bl ? krbAsReq.getReply(encryptionKeyArray) : krbAsReq.getReply(cArray);
        }
        catch (KrbException krbException) {
            if (krbException.returnCode() == 52) {
                krbAsReq.send(string, string2, true);
                krbAsRep = bl ? krbAsReq.getReply(encryptionKeyArray) : krbAsReq.getReply(cArray);
            }
            throw krbException;
        }
        return krbAsRep;
    }

    private static void setOptions(int n, int n2, KDCOptions kDCOptions) {
        switch (n2) {
            case 0: {
                break;
            }
            case -1: {
                kDCOptions.set(n, false);
                break;
            }
            case 1: {
                kDCOptions.set(n, true);
            }
        }
    }
}

