/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthArrowButton;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthScrollBarUI
extends BasicScrollBarUI
implements PropertyChangeListener,
SynthUI {
    private static final Insets tmpInsets = new Insets(0, 0, 0, 0);
    private SynthStyle style;
    private SynthStyle thumbStyle;
    private SynthStyle trackStyle;
    private int scrollBarWidth;

    SynthScrollBarUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthScrollBarUI();
    }

    protected void installDefaults() {
        this.trackHighlight = 0;
        if (this.scrollbar.getLayout() == null || this.scrollbar.getLayout() instanceof UIResource) {
            this.scrollbar.setLayout(this);
        }
        this.updateStyle(this.scrollbar);
    }

    protected void configureScrollBarColors() {
    }

    private void updateStyle(JScrollBar jScrollBar) {
        SynthStyle synthStyle = this.style;
        SynthContext synthContext = this.getContext((JComponent)jScrollBar, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            Insets insets = jScrollBar.getInsets();
            this.scrollBarWidth = this.style.getInt(synthContext, "ScrollBar.thumbHeight", 14);
            this.minimumThumbSize = new Dimension();
            if (jScrollBar.getOrientation() == 1) {
                this.minimumThumbSize.width = this.scrollBarWidth;
                this.minimumThumbSize.height = 7;
                this.scrollBarWidth += insets.left + insets.right;
            } else {
                this.minimumThumbSize.width = 7;
                this.minimumThumbSize.height = this.scrollBarWidth;
                this.scrollBarWidth += insets.top + insets.bottom;
            }
            this.maximumThumbSize = (Dimension)this.style.get(synthContext, "ScrollBar.maximumThumbSize");
            if (this.maximumThumbSize == null) {
                this.maximumThumbSize = new Dimension(4096, 4097);
            }
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
        synthContext = this.getContext(jScrollBar, Region.SCROLL_BAR_TRACK, 1);
        this.trackStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
        synthContext = this.getContext(jScrollBar, Region.SCROLL_BAR_THUMB, 1);
        this.thumbStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected void installListeners() {
        super.installListeners();
        this.scrollbar.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.scrollbar.removePropertyChangeListener(this);
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.scrollbar, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        synthContext = this.getContext(this.scrollbar, Region.SCROLL_BAR_TRACK, 1);
        this.trackStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.trackStyle = null;
        synthContext = this.getContext(this.scrollbar, Region.SCROLL_BAR_THUMB, 1);
        this.thumbStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.thumbStyle = null;
        super.uninstallDefaults();
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n) {
        SynthStyle synthStyle = this.trackStyle;
        if (region == Region.SCROLL_BAR_THUMB) {
            synthStyle = this.thumbStyle;
        }
        return SynthContext.getContext(SynthContext.class, jComponent, region, synthStyle, n);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        if (region == Region.SCROLL_BAR_THUMB && this.isThumbRollover() && jComponent.isEnabled()) {
            return 2;
        }
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public boolean getSupportsAbsolutePositioning() {
        SynthContext synthContext = this.getContext(this.scrollbar);
        boolean bl = this.style.getBoolean(synthContext, "ScrollBar.allowsAbsolutePositioning", false);
        synthContext.dispose();
        return bl;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintScrollBarBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        SynthContext synthContext2 = this.getContext((JComponent)this.scrollbar, Region.SCROLL_BAR_TRACK);
        this.paintTrack(synthContext2, graphics, this.getTrackBounds());
        synthContext2.dispose();
        synthContext2 = this.getContext((JComponent)this.scrollbar, Region.SCROLL_BAR_THUMB);
        this.paintThumb(synthContext2, graphics, this.getThumbBounds());
        synthContext2.dispose();
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintScrollBarBorder(synthContext, graphics, n, n2, n3, n4);
    }

    protected void paintTrack(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
        synthContext.getPainter().paintScrollBarTrackBackground(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        synthContext.getPainter().paintScrollBarTrackBorder(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void paintThumb(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        int n = this.scrollbar.getOrientation();
        synthContext.getPainter().paintScrollBarThumbBackground(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n);
        synthContext.getPainter().paintScrollBarThumbBorder(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.scrollbar.getOrientation() == 1 ? new Dimension(this.scrollBarWidth, 48) : new Dimension(48, this.scrollBarWidth);
    }

    protected JButton createDecreaseButton(int n) {
        SynthArrowButton synthArrowButton = new SynthArrowButton(n);
        synthArrowButton.setName("ScrollBar.button");
        return synthArrowButton;
    }

    protected JButton createIncreaseButton(int n) {
        SynthArrowButton synthArrowButton = new SynthArrowButton(n);
        synthArrowButton.setName("ScrollBar.button");
        return synthArrowButton;
    }

    protected void setThumbRollover(boolean bl) {
        if (this.isThumbRollover() != bl) {
            this.scrollbar.repaint(this.getThumbBounds());
            super.setThumbRollover(bl);
        }
    }

    private void updateButtonDirections() {
        int n = this.scrollbar.getOrientation();
        if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
            ((SynthArrowButton)this.incrButton).setDirection(n == 0 ? 3 : 5);
            ((SynthArrowButton)this.decrButton).setDirection(n == 0 ? 7 : 1);
        } else {
            ((SynthArrowButton)this.incrButton).setDirection(n == 0 ? 7 : 5);
            ((SynthArrowButton)this.decrButton).setDirection(n == 0 ? 3 : 1);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JScrollBar)propertyChangeEvent.getSource());
        } else if ("orientation" == string) {
            this.updateButtonDirections();
        } else if ("componentOrientation" == string) {
            this.updateButtonDirections();
        }
    }
}

