/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.Deprecated;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.InnerClass;
import com.sun.org.apache.bcel.internal.classfile.InnerClasses;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.StackMap;
import com.sun.org.apache.bcel.internal.classfile.StackMapEntry;
import com.sun.org.apache.bcel.internal.classfile.Synthetic;
import com.sun.org.apache.bcel.internal.classfile.Unknown;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.util.Stack;

public class DescendingVisitor
implements Visitor {
    private JavaClass clazz;
    private Visitor visitor;
    private Stack stack = new Stack();

    public Object predecessor() {
        return this.predecessor(0);
    }

    public Object predecessor(int n) {
        int n2 = this.stack.size();
        if (n2 < 2 || n < 0) {
            return null;
        }
        return this.stack.elementAt(n2 - (n + 2));
    }

    public Object current() {
        return this.stack.peek();
    }

    public DescendingVisitor(JavaClass javaClass, Visitor visitor) {
        this.clazz = javaClass;
        this.visitor = visitor;
    }

    public void visit() {
        this.clazz.accept(this);
    }

    public void visitJavaClass(JavaClass javaClass) {
        this.stack.push(javaClass);
        javaClass.accept(this.visitor);
        Field[] fieldArray = javaClass.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            fieldArray[i].accept(this);
        }
        Method[] methodArray = javaClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            methodArray[i].accept(this);
        }
        Attribute[] attributeArray = javaClass.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            attributeArray[i].accept(this);
        }
        javaClass.getConstantPool().accept(this);
        this.stack.pop();
    }

    public void visitField(Field field) {
        this.stack.push(field);
        field.accept(this.visitor);
        Attribute[] attributeArray = field.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            attributeArray[i].accept(this);
        }
        this.stack.pop();
    }

    public void visitConstantValue(ConstantValue constantValue) {
        this.stack.push(constantValue);
        constantValue.accept(this.visitor);
        this.stack.pop();
    }

    public void visitMethod(Method method) {
        this.stack.push(method);
        method.accept(this.visitor);
        Attribute[] attributeArray = method.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            attributeArray[i].accept(this);
        }
        this.stack.pop();
    }

    public void visitExceptionTable(ExceptionTable exceptionTable) {
        this.stack.push(exceptionTable);
        exceptionTable.accept(this.visitor);
        this.stack.pop();
    }

    public void visitCode(Code code) {
        this.stack.push(code);
        code.accept(this.visitor);
        CodeException[] codeExceptionArray = code.getExceptionTable();
        for (int i = 0; i < codeExceptionArray.length; ++i) {
            codeExceptionArray[i].accept(this);
        }
        Attribute[] attributeArray = code.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            attributeArray[i].accept(this);
        }
        this.stack.pop();
    }

    public void visitCodeException(CodeException codeException) {
        this.stack.push(codeException);
        codeException.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLineNumberTable(LineNumberTable lineNumberTable) {
        this.stack.push(lineNumberTable);
        lineNumberTable.accept(this.visitor);
        LineNumber[] lineNumberArray = lineNumberTable.getLineNumberTable();
        for (int i = 0; i < lineNumberArray.length; ++i) {
            lineNumberArray[i].accept(this);
        }
        this.stack.pop();
    }

    public void visitLineNumber(LineNumber lineNumber) {
        this.stack.push(lineNumber);
        lineNumber.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLocalVariableTable(LocalVariableTable localVariableTable) {
        this.stack.push(localVariableTable);
        localVariableTable.accept(this.visitor);
        LocalVariable[] localVariableArray = localVariableTable.getLocalVariableTable();
        for (int i = 0; i < localVariableArray.length; ++i) {
            localVariableArray[i].accept(this);
        }
        this.stack.pop();
    }

    public void visitStackMap(StackMap stackMap) {
        this.stack.push(stackMap);
        stackMap.accept(this.visitor);
        StackMapEntry[] stackMapEntryArray = stackMap.getStackMap();
        for (int i = 0; i < stackMapEntryArray.length; ++i) {
            stackMapEntryArray[i].accept(this);
        }
        this.stack.pop();
    }

    public void visitStackMapEntry(StackMapEntry stackMapEntry) {
        this.stack.push(stackMapEntry);
        stackMapEntry.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLocalVariable(LocalVariable localVariable) {
        this.stack.push(localVariable);
        localVariable.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantPool(ConstantPool constantPool) {
        this.stack.push(constantPool);
        constantPool.accept(this.visitor);
        Constant[] constantArray = constantPool.getConstantPool();
        for (int i = 1; i < constantArray.length; ++i) {
            if (constantArray[i] == null) continue;
            constantArray[i].accept(this);
        }
        this.stack.pop();
    }

    public void visitConstantClass(ConstantClass constantClass) {
        this.stack.push(constantClass);
        constantClass.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantDouble(ConstantDouble constantDouble) {
        this.stack.push(constantDouble);
        constantDouble.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantFieldref(ConstantFieldref constantFieldref) {
        this.stack.push(constantFieldref);
        constantFieldref.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantFloat(ConstantFloat constantFloat) {
        this.stack.push(constantFloat);
        constantFloat.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantInteger(ConstantInteger constantInteger) {
        this.stack.push(constantInteger);
        constantInteger.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constantInterfaceMethodref) {
        this.stack.push(constantInterfaceMethodref);
        constantInterfaceMethodref.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantLong(ConstantLong constantLong) {
        this.stack.push(constantLong);
        constantLong.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantMethodref(ConstantMethodref constantMethodref) {
        this.stack.push(constantMethodref);
        constantMethodref.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantNameAndType(ConstantNameAndType constantNameAndType) {
        this.stack.push(constantNameAndType);
        constantNameAndType.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantString(ConstantString constantString) {
        this.stack.push(constantString);
        constantString.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantUtf8(ConstantUtf8 constantUtf8) {
        this.stack.push(constantUtf8);
        constantUtf8.accept(this.visitor);
        this.stack.pop();
    }

    public void visitInnerClasses(InnerClasses innerClasses) {
        this.stack.push(innerClasses);
        innerClasses.accept(this.visitor);
        InnerClass[] innerClassArray = innerClasses.getInnerClasses();
        for (int i = 0; i < innerClassArray.length; ++i) {
            innerClassArray[i].accept(this);
        }
        this.stack.pop();
    }

    public void visitInnerClass(InnerClass innerClass) {
        this.stack.push(innerClass);
        innerClass.accept(this.visitor);
        this.stack.pop();
    }

    public void visitDeprecated(Deprecated deprecated) {
        this.stack.push(deprecated);
        deprecated.accept(this.visitor);
        this.stack.pop();
    }

    public void visitSourceFile(SourceFile sourceFile) {
        this.stack.push(sourceFile);
        sourceFile.accept(this.visitor);
        this.stack.pop();
    }

    public void visitSynthetic(Synthetic synthetic) {
        this.stack.push(synthetic);
        synthetic.accept(this.visitor);
        this.stack.pop();
    }

    public void visitUnknown(Unknown unknown) {
        this.stack.push(unknown);
        unknown.accept(this.visitor);
        this.stack.pop();
    }
}

