/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class WindowsProgressBarUI
extends BasicProgressBarUI {
    private Rectangle boxRect;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsProgressBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        if (XPStyle.getXP() != null) {
            LookAndFeel.installProperty(this.progressBar, "opaque", Boolean.FALSE);
            this.progressBar.setBorder(null);
        }
    }

    protected Dimension getPreferredInnerHorizontal() {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            Dimension dimension = xPStyle.getDimension(this.progressBar, TMSchema.Part.PP_BAR, null, TMSchema.Prop.NORMALSIZE);
            if (dimension == null) {
                XPStyle.Skin skin = xPStyle.getSkin(this.progressBar, TMSchema.Part.PP_BAR);
                dimension = new Dimension(super.getPreferredInnerHorizontal().width, skin.getHeight());
            }
            return dimension;
        }
        return super.getPreferredInnerHorizontal();
    }

    protected Dimension getPreferredInnerVertical() {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            Dimension dimension = xPStyle.getDimension(this.progressBar, TMSchema.Part.PP_BARVERT, null, TMSchema.Prop.NORMALSIZE);
            if (dimension == null) {
                XPStyle.Skin skin = xPStyle.getSkin(this.progressBar, TMSchema.Part.PP_BARVERT);
                dimension = new Dimension(skin.getWidth(), super.getPreferredInnerVertical().height);
            }
            return dimension;
        }
        return super.getPreferredInnerVertical();
    }

    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            boolean bl = this.progressBar.getOrientation() == 1;
            boolean bl2 = WindowsGraphicsUtils.isLeftToRight(jComponent);
            int n = this.progressBar.getWidth();
            int n2 = this.progressBar.getHeight() - 1;
            int n3 = this.getAmountFull(null, n, n2);
            this.paintXPBackground(graphics, bl, n, n2);
            if (this.progressBar.isStringPainted()) {
                graphics.setColor(this.progressBar.getForeground());
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(new BasicStroke(bl ? (n -= 2) : (n2 -= 2), 0, 2));
                if (!bl) {
                    if (bl2) {
                        graphics2D.drawLine(2, n2 / 2 + 1, n3 - 2, n2 / 2 + 1);
                    } else {
                        graphics2D.drawLine(2 + n, n2 / 2 + 1, 2 + n - (n3 - 2), n2 / 2 + 1);
                    }
                    this.paintString(graphics, 0, 0, n, n2, n3, null);
                } else {
                    graphics2D.drawLine(n / 2 + 1, n2 + 1, n / 2 + 1, n2 + 1 - n3 + 2);
                    this.paintString(graphics, 2, 2, n, n2, n3, null);
                }
            } else {
                XPStyle.Skin skin = xPStyle.getSkin(this.progressBar, bl ? TMSchema.Part.PP_CHUNKVERT : TMSchema.Part.PP_CHUNK);
                int n4 = bl ? n - 5 : n2 - 5;
                int n5 = xPStyle.getInt(this.progressBar, TMSchema.Part.PP_PROGRESS, null, TMSchema.Prop.PROGRESSCHUNKSIZE, 2);
                int n6 = xPStyle.getInt(this.progressBar, TMSchema.Part.PP_PROGRESS, null, TMSchema.Prop.PROGRESSSPACESIZE, 0);
                int n7 = (n3 - 4) / (n5 + n6);
                if (n6 > 0 && n7 * (n5 + n6) + n5 < n3 - 4) {
                    ++n7;
                }
                for (int i = 0; i < n7; ++i) {
                    if (bl) {
                        skin.paintSkin(graphics, 3, n2 - i * (n5 + n6) - n5 - 2, n4, n5, null);
                        continue;
                    }
                    if (bl2) {
                        skin.paintSkin(graphics, 4 + i * (n5 + n6), 2, n5, n4, null);
                        continue;
                    }
                    skin.paintSkin(graphics, n - (2 + (i + 1) * (n5 + n6)), 2, n5, n4, null);
                }
            }
        } else {
            super.paintDeterminate(graphics, jComponent);
        }
    }

    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            boolean bl = this.progressBar.getOrientation() == 1;
            int n = this.progressBar.getWidth();
            int n2 = this.progressBar.getHeight() - 1;
            this.paintXPBackground(graphics, bl, n, n2);
            this.boxRect = this.getBox(this.boxRect);
            if (this.boxRect != null) {
                graphics.setColor(this.progressBar.getForeground());
                if (!bl) {
                    graphics.fillRect(this.boxRect.x, this.boxRect.y + 2, this.boxRect.width, this.boxRect.height - 4);
                } else {
                    graphics.fillRect(this.boxRect.x + 2, this.boxRect.y, this.boxRect.width - 3, this.boxRect.height);
                }
                if (this.progressBar.isStringPainted()) {
                    if (!bl) {
                        this.paintString(graphics, -1, -1, n, n2, 0, null);
                    } else {
                        this.paintString(graphics, 1, 1, n, n2, 0, null);
                    }
                }
            }
        } else {
            super.paintIndeterminate(graphics, jComponent);
        }
    }

    private void paintXPBackground(Graphics graphics, boolean bl, int n, int n2) {
        XPStyle xPStyle = XPStyle.getXP();
        TMSchema.Part part = bl ? TMSchema.Part.PP_BARVERT : TMSchema.Part.PP_BAR;
        XPStyle.Skin skin = xPStyle.getSkin(this.progressBar, part);
        skin.paintSkin(graphics, 0, 0, n, n2, null);
    }
}

