/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.SunX509KeyManagerImpl;
import com.sun.net.ssl.internal.ssl.X509KeyManagerImpl;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509ExtendedKeyManager;

abstract class KeyManagerFactoryImpl
extends KeyManagerFactorySpi {
    X509ExtendedKeyManager keyManager;
    boolean isInitialized;

    KeyManagerFactoryImpl() {
    }

    protected KeyManager[] engineGetKeyManagers() {
        if (!this.isInitialized) {
            throw new IllegalStateException("KeyManagerFactoryImpl is not initialized");
        }
        return new KeyManager[]{this.keyManager};
    }

    public static final class SunX509
    extends KeyManagerFactoryImpl {
        protected void engineInit(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            this.keyManager = new SunX509KeyManagerImpl(keyStore, cArray);
            this.isInitialized = true;
        }

        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("SunX509KeyManager does not use ManagerFactoryParameters");
        }
    }

    public static final class X509
    extends KeyManagerFactoryImpl {
        protected void engineInit(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            KeyStore.Builder builder = KeyStore.Builder.newInstance(keyStore, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(cArray));
            this.keyManager = new X509KeyManagerImpl(builder);
            this.isInitialized = true;
        }

        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
            if (!(managerFactoryParameters instanceof KeyStoreBuilderParameters)) {
                throw new InvalidAlgorithmParameterException("Parameters must be instance of KeyStoreBuilderParameters");
            }
            List list = ((KeyStoreBuilderParameters)managerFactoryParameters).getParameters();
            this.keyManager = new X509KeyManagerImpl(list);
            this.isInitialized = true;
        }
    }
}

