/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.server;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import sun.plugin2.liveconnect.RemoteJavaObject;
import sun.plugin2.main.server.AppletID;
import sun.plugin2.main.server.JVMInstance;
import sun.plugin2.main.server.Plugin;
import sun.plugin2.message.AppletMessage;
import sun.plugin2.message.Conversation;
import sun.plugin2.util.SystemUtil;

public class JVMManager {
    private static final boolean DEBUG = SystemUtil.isDebug();
    private static final boolean VERBOSE = SystemUtil.isVerbose();
    private static final String JPI_USER_PROFILE = "javaplugin.user.profile";
    private static JVMManager soleInstance = new JVMManager();
    private static final int RETRY_COUNT = 2;
    private static int browserType;
    private String userJPIProfile;
    private Map activeJVMs = new HashMap();
    private int curJVMID;
    private List javaPlatformList = new ArrayList();
    private Map javaParamMap = new IdentityHashMap();
    private int curAppletID;
    private Map appletToJVMMap = new HashMap();
    private Map appletMessageQueue = new HashMap();

    private JVMManager() {
        this.userJPIProfile = SystemUtil.getenv("USER_JPI_PROFILE");
        if (this.userJPIProfile != null) {
            System.setProperty(JPI_USER_PROFILE, this.userJPIProfile);
        }
        this.processJREInfo();
    }

    public static void setBrowserType(int n) {
        browserType = n;
    }

    public static int getBrowserType() {
        return browserType;
    }

    public static JVMManager getManager() {
        return soleInstance;
    }

    public boolean instanceExited(int n) {
        return this.getJVMInstance(n) == null;
    }

    public boolean appletExited(AppletID appletID) {
        Iterator iterator = this.activeJVMs.values().iterator();
        while (iterator.hasNext()) {
            JVMInstance jVMInstance = (JVMInstance)iterator.next();
            if (!jVMInstance.appletRunning(appletID)) continue;
            return false;
        }
        return true;
    }

    public AppletID startApplet(Map map, Plugin plugin, long l, long l2, boolean bl) {
        return this.startApplet(map, plugin, l, l2, bl, (String)map.get("java_version"));
    }

    public AppletID startApplet(Map map, Plugin plugin, long l, long l2, boolean bl, String string) {
        return this.startAppletImpl(map, plugin, l, l2, bl, string, false, this.nextAppletID(), false);
    }

    public AppletID startDummyApplet(Map map, Plugin plugin) {
        return this.startAppletImpl(map, plugin, 0L, 0L, false, (String)map.get("java_version"), true, this.nextAppletID(), false);
    }

    public AppletID relaunchApplet(Map map, Plugin plugin, long l, long l2, boolean bl, String string, int n, boolean bl2) {
        if (bl2) {
            Config.refreshProps();
            this.processJREInfo();
        }
        return this.startAppletImpl(map, plugin, l, l2, bl, string, false, n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppletID startAppletImpl(Map map, Plugin plugin, long l, long l2, boolean bl, String string, boolean bl2, int n, boolean bl3) {
        Object object;
        long l3 = SystemUtils.microTime();
        VersionString versionString = null;
        if (string != null) {
            if (bl3) {
                versionString = new VersionString(string);
            } else {
                object = this.getBestJREInfo(new VersionString(string)).getProduct();
                if (SecurityBaseline.satisfiesSecurityBaseline((String)object)) {
                    versionString = new VersionString(string);
                } else {
                    map.put("__applet_ssv_version", object);
                }
            }
        }
        object = SystemUtil.extractAppletParamsToJVMParameters(map, bl3);
        int n2 = 0;
        boolean bl4 = false;
        String string2 = (String)map.get("separate_jvm");
        if (string2 != null) {
            bl4 = Boolean.valueOf(string2);
        }
        AppletID appletID = new AppletID(n);
        do {
            Map map2;
            JVMInstance jVMInstance = this.getOrCreateBestJVMInstance(l3, (VersionString)(bl3 ? versionString : null), (JVMParameters)object, bl4, bl3 ? appletID : null);
            if (versionString != null && map.get("__applet_ssv_version") == null) {
                map2 = null;
                Iterator iterator = this.javaPlatformList.iterator();
                while (iterator.hasNext()) {
                    JREInfo jREInfo = (JREInfo)iterator.next();
                    if (!versionString.contains(jREInfo.getProductVersion()) || map2 != null && !jREInfo.getProductVersion().isGreaterThan(map2.getProductVersion())) continue;
                    map2 = jREInfo;
                }
                if (map2 != null) {
                    map.put("__applet_ssv_version", map2.getProductVersion().toString());
                }
            }
            if (!jVMInstance.exited() && jVMInstance.startApplet(map, plugin, l, l2, bl, n, bl2, bl3)) {
                this.appletToJVMMap.put(appletID, jVMInstance);
                map2 = this.appletMessageQueue;
                synchronized (map2) {
                    if (null == this.appletMessageQueue.get(appletID)) {
                        this.appletMessageQueue.put(appletID, new ArrayList());
                    }
                }
                if (DEBUG) {
                    System.out.println("JVMManager: applet launch (ID " + appletID + ") succeeded");
                }
                return appletID;
            }
            if (!DEBUG || !jVMInstance.errorOccurred()) continue;
            System.out.println("Error occurred during launch of JVM");
        } while (++n2 < 2);
        return null;
    }

    public void setAppletSize(AppletID appletID, int n, int n2) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        int[] nArray = new int[]{n, n2};
        jVMInstance.setAppletSize(appletID.getID(), n, n2);
    }

    public void sendStopApplet(AppletID appletID) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.sendStopApplet(appletID.getID());
    }

    public boolean receivedStopAcknowledgment(AppletID appletID) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return false;
        }
        return jVMInstance.receivedStopAcknowledgment(appletID.getID());
    }

    public void recycleAppletID(AppletID appletID) {
        JVMInstance jVMInstance = this.removeJVMInstance(appletID);
        if (jVMInstance != null) {
            jVMInstance.recycleAppletID(appletID.getID());
        }
        this.removeAppletMessageQueue(appletID);
    }

    public void sendGetApplet(AppletID appletID, int n) throws IOException {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            throw new IOException("No active JVM instance for applet ID " + appletID);
        }
        jVMInstance.sendGetApplet(appletID.getID(), n);
    }

    public void sendGetNameSpace(AppletID appletID, String string, int n) throws IOException {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            throw new IOException("No active JVM instance for applet ID " + appletID);
        }
        jVMInstance.sendGetNameSpace(appletID.getID(), string, n);
    }

    public void sendRemoteJavaObjectOp(Conversation conversation, RemoteJavaObject remoteJavaObject, String string, int n, Object[] objectArray, int n2) throws IOException {
        JVMInstance jVMInstance = this.getJVMInstance(new AppletID(remoteJavaObject.getAppletID()));
        if (jVMInstance == null) {
            throw new IOException("No active JVM instance for applet ID " + remoteJavaObject.getAppletID() + ", JVM ID " + remoteJavaObject.getJVMID());
        }
        jVMInstance.sendRemoteJavaObjectOp(conversation, remoteJavaObject, string, n, objectArray, n2);
    }

    public void releaseRemoteJavaObject(RemoteJavaObject remoteJavaObject) {
        JVMInstance jVMInstance = this.getJVMInstance(remoteJavaObject.getJVMID());
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.releaseRemoteJavaObject(remoteJavaObject.getObjectID());
    }

    public void synthesizeWindowActivation(AppletID appletID, boolean bl) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return;
        }
        jVMInstance.synthesizeWindowActivation(appletID.getID(), bl);
    }

    public boolean printApplet(AppletID appletID, long l, int n, int n2, int n3, int n4) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null) {
            return false;
        }
        return jVMInstance.printApplet(appletID.getID(), l, n, n2, n3, n4);
    }

    public boolean isMoreRecentJVMAvailable(JREInfo jREInfo) {
        Iterator iterator = this.javaPlatformList.iterator();
        while (iterator.hasNext()) {
            JREInfo jREInfo2 = (JREInfo)iterator.next();
            if (DEBUG) {
                System.out.println("isMoreRecentJVMAvailable considering " + jREInfo2.getProductVersion() + " JVM for relaunch");
            }
            if (!jREInfo2.getProductVersion().isGreaterThan(jREInfo.getProductVersion())) continue;
            if (DEBUG) {
                System.out.println("  isMoreRecentJVMAvailable (chosen)");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean spoolAppletMessage(AppletMessage appletMessage) {
        Map map = this.appletMessageQueue;
        synchronized (map) {
            List list = (List)this.appletMessageQueue.get(new AppletID(appletMessage.getAppletID()));
            if (list != null) {
                if (DEBUG && VERBOSE) {
                    System.out.println("Spool AppletMessage: " + appletMessage);
                }
                list.add(appletMessage);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drainAppletMessages(AppletID appletID) {
        JVMInstance jVMInstance = this.getJVMInstance(appletID);
        if (jVMInstance == null && DEBUG) {
            System.out.println("JVMManager.drainAppletMessages: no JVM instance for applet ID " + appletID);
            return;
        }
        Map map = this.appletMessageQueue;
        synchronized (map) {
            List list = (List)this.appletMessageQueue.remove(appletID);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    try {
                        AppletMessage appletMessage = (AppletMessage)iterator.next();
                        if (DEBUG && VERBOSE) {
                            System.out.println("Drain AppletMessage: " + appletMessage);
                        }
                        jVMInstance.sendMessageDirect(appletMessage);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAppletMessageQueue(AppletID appletID) {
        Map map = this.appletMessageQueue;
        synchronized (map) {
            this.appletMessageQueue.remove(appletID);
        }
    }

    protected synchronized int getJVMIDForApplet(AppletID appletID) {
        JVMInstance jVMInstance = (JVMInstance)this.appletToJVMMap.get(appletID);
        return null != jVMInstance ? jVMInstance.getID() : -1;
    }

    synchronized JVMInstance getJVMInstance(AppletID appletID) {
        return (JVMInstance)this.appletToJVMMap.get(appletID);
    }

    private synchronized JVMInstance getJVMInstance(int n) {
        return (JVMInstance)this.activeJVMs.get(new Integer(n));
    }

    private synchronized JVMInstance removeJVMInstance(AppletID appletID) {
        return (JVMInstance)this.appletToJVMMap.remove(appletID);
    }

    private synchronized int nextJVMID() {
        int n;
        while (this.activeJVMs.get(new Integer(n = ++this.curJVMID)) != null) {
        }
        return n;
    }

    private synchronized void processJREInfo() {
        Vector vector;
        this.javaPlatformList.clear();
        if (DEBUG && VERBOSE) {
            System.out.println("JREInfos (1)");
            JREInfo.printJREs();
        }
        if ((vector = Config.getInstance().getInstalledJREList()) != null) {
            Config.storeInstalledJREList((Vector)vector);
        } else {
            Config.refreshIfNecessary();
        }
        if (DEBUG && VERBOSE) {
            System.out.println("JREInfos (2)");
            JREInfo.printJREs();
        }
        this.javaPlatformList.addAll(Arrays.asList(JREInfo.getAll()));
        JVMManager.filterJavaPlatformList(this.javaPlatformList);
        Collections.sort(this.javaPlatformList, new Comparator(){

            public int compare(Object object, Object object2) {
                VersionID versionID = ((JREInfo)object).getProductVersion();
                VersionID versionID2 = ((JREInfo)object2).getProductVersion();
                return -versionID.compareTo((Object)versionID2);
            }

            public boolean equals(Object object) {
                return false;
            }
        });
        JVMManager.filterDisabledJREs(this.javaPlatformList);
        Iterator iterator = this.javaPlatformList.iterator();
        while (iterator.hasNext()) {
            JREInfo jREInfo = (JREInfo)iterator.next();
            JVMParameters jVMParameters = SystemUtil.getDefaultVmArgs(jREInfo);
            this.javaParamMap.put(jREInfo, jVMParameters);
        }
    }

    synchronized JREInfo getBestJREInfo(VersionString versionString) {
        Object object;
        Object object2;
        boolean bl = false;
        if (versionString == null) {
            return (JREInfo)this.javaPlatformList.get(0);
        }
        while (true) {
            if (bl) {
                Config.refreshProps();
                this.processJREInfo();
            }
            object2 = this.javaPlatformList.iterator();
            while (object2.hasNext()) {
                object = (JREInfo)object2.next();
                if (!versionString.contains(object.getProductVersion())) continue;
                return object;
            }
            if (bl) break;
            bl = true;
        }
        object2 = versionString.getAllVersionIDs();
        object = object2.iterator();
        while (object.hasNext()) {
            VersionID versionID = (VersionID)object.next();
            VersionID versionID2 = versionID.getFamilyVersionID();
            if (versionID2 == null) continue;
            Iterator iterator = this.javaPlatformList.iterator();
            while (iterator.hasNext()) {
                JREInfo jREInfo = (JREInfo)iterator.next();
                if (!versionID2.match(jREInfo.getProductVersion())) continue;
                return jREInfo;
            }
        }
        return (JREInfo)this.javaPlatformList.get(0);
    }

    private synchronized JVMInstance getOrCreateBestJVMInstance(long l, VersionString versionString, JVMParameters jVMParameters, boolean bl, AppletID appletID) {
        Object object;
        JVMInstance jVMInstance = null;
        if (!bl) {
            jVMInstance = this.getBestJVMInstance(versionString, jVMParameters);
            if (jVMInstance != null) {
                if (DEBUG) {
                    System.out.println("JVMManager reusing JVMInstance for product version " + jVMInstance.getProductVersion());
                }
                return jVMInstance;
            }
            object = this.getBestJREInfo(versionString);
            jVMInstance = this.getBestJVMInstance(new VersionString(object.getProductVersion()), jVMParameters);
            if (jVMInstance != null) {
                if (DEBUG) {
                    System.out.println("JVMManager reusing JVMInstance for product version " + jVMInstance.getProductVersion());
                }
                return jVMInstance;
            }
        }
        jVMInstance = this.createJVMInstance(l, versionString, jVMParameters, bl, appletID);
        if (DEBUG) {
            System.out.println("JVMManager starting JVMInstance for product version " + jVMInstance.getProductVersion());
            object = jVMInstance.getParameters().getCommandLineArguments(SystemUtil.isWindowsVista(), false);
            if (object.size() > 0) {
                System.out.println("  Command-line arguments: ");
                for (int i = 0; i < object.size(); ++i) {
                    System.out.println("    Argument " + i + ": " + object.get(i));
                }
            }
        }
        try {
            jVMInstance.start();
            return jVMInstance;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            error.printStackTrace();
            throw error;
        }
    }

    private synchronized JVMInstance getBestJVMInstance(VersionString versionString, JVMParameters jVMParameters) {
        Object object;
        Object object2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Object object3 = this.activeJVMs.values().iterator();
        while (object3.hasNext()) {
            object2 = (JVMInstance)object3.next();
            if (!((JVMInstance)object2).exited()) continue;
            arrayList.add(new Integer(((JVMInstance)object2).getID()));
        }
        object3 = arrayList.iterator();
        while (object3.hasNext()) {
            this.activeJVMs.remove(object3.next());
        }
        if (DEBUG) {
            System.out.println("Seeking suitable JRE version IDs: " + versionString);
            System.out.println(this.activeJVMs.values().size() + " active JVM(s)");
        }
        object3 = null;
        object2 = this.activeJVMs.values().iterator();
        while (object2.hasNext()) {
            object = (JVMInstance)object2.next();
            if (DEBUG) {
                System.out.println("Considering " + ((JVMInstance)object).getProductVersion() + " JVM for reuse");
            }
            if (!(((JVMInstance)object).isTainted() || ((JVMInstance)object).isExclusive() || versionString != null && !versionString.contains(((JVMInstance)object).getProductVersion()) || object3 != null && !((JVMInstance)object).getProductVersion().isGreaterThan(((JVMInstance)object3).getProductVersion()) || !((JVMInstance)object).getParameters().satisfies(jVMParameters))) {
                object3 = object;
                if (!DEBUG) continue;
                System.out.println("  (chosen)");
                continue;
            }
            if (!DEBUG) continue;
            System.out.println("  (rejected)");
        }
        object2 = null;
        object = this.javaPlatformList.iterator();
        while (object.hasNext()) {
            JREInfo jREInfo = (JREInfo)object.next();
            if (DEBUG) {
                System.out.println("Considering " + jREInfo.getProductVersion() + " JVM for launch");
            }
            if ((versionString == null || versionString.contains(jREInfo.getProductVersion())) && (object2 == null || jREInfo.getProductVersion().isGreaterThan(object2.getProductVersion()))) {
                object2 = jREInfo;
                if (!DEBUG) continue;
                System.out.println("  (chosen)");
                continue;
            }
            if (!DEBUG) continue;
            System.out.println("  (rejected)");
        }
        if (object3 != null) {
            if (object2 == null) {
                throw new InternalError("Should not find a running JVM instance but no matching JRE platform");
            }
            if (((JVMInstance)object3).getProductVersion().isGreaterThanOrEqual(object2.getProductVersion())) {
                if (DEBUG) {
                    System.out.println("Reusing JVM instance with product version " + ((JVMInstance)object3).getProductVersion() + "; best available product version " + object2.getProductVersion());
                }
                return object3;
            }
            if (DEBUG) {
                System.out.println("NOT reusing JVM instance with product version " + ((JVMInstance)object3).getProductVersion() + "; best available product version " + object2.getProductVersion());
            }
        } else if (DEBUG) {
            System.out.println("No suitable JVM instance to reuse");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JVMInstance createJVMInstance(long l, VersionString versionString, JVMParameters jVMParameters, boolean bl, AppletID appletID) {
        JREInfo jREInfo = this.getBestJREInfo(versionString);
        JVMParameters jVMParameters2 = SystemUtil.prepareJVMParameter(jVMParameters, jREInfo, (JVMParameters)this.javaParamMap.get(jREInfo));
        if (this.userJPIProfile != null) {
            jVMParameters2.addInternalArgument("-Djavaplugin.user.profile=" + this.userJPIProfile);
        }
        if (DEBUG) {
            System.out.println("JVMManager creating JVMInstance for product version " + jREInfo.getProductVersion());
        }
        int n = this.nextJVMID();
        JVMInstance jVMInstance = new JVMInstance(l, n, jREInfo, jVMParameters2, bl, appletID);
        JVMManager jVMManager = this;
        synchronized (jVMManager) {
            this.activeJVMs.put(new Integer(n), jVMInstance);
        }
        return jVMInstance;
    }

    private synchronized int nextAppletID() {
        return ++this.curAppletID;
    }

    private static void filterJavaPlatformList(List list) {
        VersionID versionID = new VersionID("1.4+");
        VersionID versionID2 = new VersionID("1.5+");
        boolean bl = SystemUtil.getOSType() == 2;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JREInfo jREInfo = (JREInfo)iterator.next();
            if (!versionID.match(jREInfo.getProductVersion()) || bl && !versionID2.match(jREInfo.getProductVersion())) {
                iterator.remove();
                continue;
            }
            if (!jREInfo.isOsInfoMatch(Config.getOSName(), Config.getOSArch())) {
                iterator.remove();
                continue;
            }
            File file = new File(jREInfo.getPath());
            if (file.exists()) continue;
            iterator.remove();
        }
    }

    private static void filterDisabledJREs(List list) {
        String string = SystemUtil.getJavaHome();
        JREInfo jREInfo = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JREInfo jREInfo2 = (JREInfo)iterator.next();
            if (jREInfo2.getJREPath().startsWith(string)) {
                jREInfo = jREInfo2;
            }
            if (jREInfo2.isEnabled()) continue;
            iterator.remove();
        }
        if (list.isEmpty() && jREInfo != null) {
            list.add(jREInfo);
        }
    }

    private void testPrintJVMs() {
        System.out.println("" + this.activeJVMs.size() + " active JVMs:");
        Iterator iterator = this.activeJVMs.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            System.out.println("  JVM " + n + ": Version ID " + ((JVMInstance)this.activeJVMs.get(n)).getProductVersion());
        }
    }

    private void test() {
        for (int i = 0; i < this.javaPlatformList.size(); ++i) {
            System.out.println("Available JRE " + i + ":");
            JREInfo jREInfo = (JREInfo)this.javaPlatformList.get(i);
            System.out.println("  Product: " + jREInfo.getProduct());
            System.out.println("  Version: " + jREInfo.getProductVersion());
            System.out.println("  Path: " + jREInfo.getPath());
        }
        this.createJVMInstance(SystemUtils.microTime(), new VersionString("1.6*"), new JVMParameters(), false, null);
        System.out.println("After creation of 1.6* JVM:");
        this.testPrintJVMs();
        this.createJVMInstance(SystemUtils.microTime(), new VersionString("1.2 1.5+"), new JVMParameters(), false, null);
        System.out.println("After creation of 1.5+ JVM:");
        this.testPrintJVMs();
        this.createJVMInstance(SystemUtils.microTime(), new VersionString("1.2 1.6*"), new JVMParameters(), false, null);
        System.out.println("After creation of another 1.6* JVM:");
        this.testPrintJVMs();
    }

    public static void main(String[] stringArray) {
        JVMManager jVMManager = JVMManager.getManager();
        jVMManager.test();
    }
}

