/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.xml.stream.SecuritySupport;

class FactoryFinder {
    private static final String DEFAULT_PACKAGE = "com.sun.xml.internal.";
    private static boolean debug = false;
    static Properties cacheProps = new Properties();
    static boolean firstTime = true;
    static SecuritySupport ss = new SecuritySupport();

    FactoryFinder() {
    }

    private static void dPrint(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    private static Class getProviderClass(String string, ClassLoader classLoader, boolean bl) throws ClassNotFoundException {
        if (System.getSecurityManager() != null && string != null && string.startsWith(DEFAULT_PACKAGE)) {
            return Class.forName(string, true, FactoryFinder.class.getClassLoader());
        }
        try {
            if (classLoader == null) {
                classLoader = ss.getContextClassLoader();
                if (classLoader == null) {
                    throw new ClassNotFoundException();
                }
                return classLoader.loadClass(string);
            }
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                return Class.forName(string, true, FactoryFinder.class.getClassLoader());
            }
            throw classNotFoundException;
        }
    }

    static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class clazz = FactoryFinder.getProviderClass(string, classLoader, bl);
            Object t = clazz.newInstance();
            if (debug) {
                FactoryFinder.dPrint("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            }
            return t;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String string, String string2) throws ConfigurationError {
        Object object;
        block17: {
            String string3;
            block16: {
                FactoryFinder.dPrint("find factoryId =" + string);
                try {
                    string3 = ss.getSystemProperty(string);
                    if (string3 != null) {
                        FactoryFinder.dPrint("found system property, value=" + string3);
                        return FactoryFinder.newInstance(string3, null, true);
                    }
                }
                catch (SecurityException securityException) {
                    if (!debug) break block16;
                    securityException.printStackTrace();
                }
            }
            string3 = null;
            try {
                object = null;
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            string3 = ss.getSystemProperty("java.home") + File.separator + "lib" + File.separator + "stax.properties";
                            File file = new File(string3);
                            firstTime = false;
                            if (ss.doesFileExist(file)) {
                                FactoryFinder.dPrint("Read properties file " + file);
                                cacheProps.load(ss.getFileInputStream(file));
                            } else {
                                string3 = ss.getSystemProperty("java.home") + File.separator + "lib" + File.separator + "jaxp.properties";
                                file = new File(string3);
                                if (ss.doesFileExist(file)) {
                                    FactoryFinder.dPrint("Read properties file " + file);
                                    cacheProps.load(ss.getFileInputStream(file));
                                }
                            }
                        }
                    }
                }
                if ((object = cacheProps.getProperty(string)) != null) {
                    FactoryFinder.dPrint("found in " + string3 + " value=" + (String)object);
                    return FactoryFinder.newInstance((String)object, null, true);
                }
            }
            catch (Exception exception) {
                if (!debug) break block17;
                exception.printStackTrace();
            }
        }
        if ((object = FactoryFinder.findJarServiceProvider(string)) != null) {
            return object;
        }
        if (string2 == null) {
            throw new ConfigurationError("Provider for " + string + " cannot be found", null);
        }
        FactoryFinder.dPrint("loaded from fallback value: " + string2);
        return FactoryFinder.newInstance(string2, null, true);
    }

    private static Object findJarServiceProvider(String string) throws ConfigurationError {
        BufferedReader bufferedReader;
        String string2 = "META-INF/services/" + string;
        InputStream inputStream = null;
        ClassLoader classLoader = ss.getContextClassLoader();
        if (classLoader != null) {
            inputStream = ss.getResourceAsStream(classLoader, string2);
            if (inputStream == null) {
                classLoader = FactoryFinder.class.getClassLoader();
                inputStream = ss.getResourceAsStream(classLoader, string2);
            }
        } else {
            classLoader = FactoryFinder.class.getClassLoader();
            inputStream = ss.getResourceAsStream(classLoader, string2);
        }
        if (inputStream == null) {
            return null;
        }
        if (debug) {
            FactoryFinder.dPrint("found jar resource=" + string2 + " using ClassLoader: " + classLoader);
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return null;
        }
        if (string3 != null && !"".equals(string3)) {
            FactoryFinder.dPrint("found in resource, value=" + string3);
            return FactoryFinder.newInstance(string3, classLoader, false);
        }
        return null;
    }

    static {
        try {
            String string = ss.getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            debug = false;
        }
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

