/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import sun.text.Utility;

public final class CompactCharArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 5;
    private static final int BLOCKCOUNT = 32;
    private static final int INDEXSHIFT = 11;
    private static final int INDEXCOUNT = 2048;
    private static final int BLOCKMASK = 31;
    private char[] values;
    private char[] indices;
    private int[] hashes;
    private boolean isCompact;
    private char defaultValue;

    public CompactCharArray() {
        this('\u0000');
    }

    public CompactCharArray(char c) {
        int n;
        this.values = new char[65536];
        this.indices = new char[2048];
        this.hashes = new int[2048];
        for (n = 0; n < 65536; ++n) {
            this.values[n] = c;
        }
        for (n = 0; n < 2048; ++n) {
            this.indices[n] = (char)(n << 5);
            this.hashes[n] = 0;
        }
        this.isCompact = false;
        this.defaultValue = c;
    }

    public CompactCharArray(String string, String string2) {
        this(Utility.RLEStringToCharArray(string), Utility.RLEStringToCharArray(string2));
    }

    public CompactCharArray(char[] cArray, char[] cArray2) {
        if (cArray.length != 2048) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        for (int i = 0; i < 2048; ++i) {
            char c = cArray[i];
            if (c >= '\u0000' && c < cArray2.length + 32) continue;
            throw new IllegalArgumentException("Index out of bounds.");
        }
        this.indices = cArray;
        this.values = cArray2;
        this.isCompact = true;
    }

    public char elementAt(char c) {
        return this.values[(this.indices[c >> 5] & 0xFFFF) + (c & 0x1F)];
    }

    public void setElementAt(char c, char c2) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c] = c2;
        this.touchBlock(c >> 5, c2);
    }

    public void setElementAt(char n, char c, char c2) {
        if (this.isCompact) {
            this.expand();
        }
        for (int i = n; i <= c; ++i) {
            this.values[i] = c2;
            this.touchBlock(i >> 5, c2);
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n = 0;
            int n2 = 0;
            int n3 = 65535;
            int n4 = 0;
            while (n4 < this.indices.length) {
                this.indices[n4] = 65535;
                boolean bl = this.blockTouched(n4);
                if (!bl && n3 != 65535) {
                    this.indices[n4] = n3;
                } else {
                    int n5 = 0;
                    int n6 = 0;
                    n6 = 0;
                    while (n6 < n) {
                        if (this.hashes[n4] == this.hashes[n6] && CompactCharArray.arrayRegionMatches(this.values, n2, this.values, n5, 32)) {
                            this.indices[n4] = (char)n5;
                        }
                        ++n6;
                        n5 += 32;
                    }
                    if (this.indices[n4] == '\uffff') {
                        System.arraycopy(this.values, n2, this.values, n5, 32);
                        this.indices[n4] = (char)n5;
                        this.hashes[n6] = this.hashes[n4];
                        ++n;
                        if (!bl) {
                            n3 = (char)n5;
                        }
                    }
                }
                ++n4;
                n2 += 32;
            }
            n4 = n * 32;
            char[] cArray = new char[n4];
            System.arraycopy(this.values, 0, cArray, 0, n4);
            this.values = cArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    static final boolean arrayRegionMatches(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n2 - n;
        for (int i = n; i < n4; ++i) {
            if (cArray[i] == cArray2[i + n5]) continue;
            return false;
        }
        return true;
    }

    private final void touchBlock(int n, int n2) {
        this.hashes[n] = this.hashes[n] + (n2 << 1) | 1;
    }

    private final boolean blockTouched(int n) {
        return this.hashes[n] != 0;
    }

    public char[] getIndexArray() {
        return this.indices;
    }

    public char[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactCharArray compactCharArray = (CompactCharArray)super.clone();
            compactCharArray.values = (char[])this.values.clone();
            compactCharArray.indices = (char[])this.indices.clone();
            if (this.hashes != null) {
                compactCharArray.hashes = (int[])this.hashes.clone();
            }
            return compactCharArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactCharArray compactCharArray = (CompactCharArray)object;
        for (int i = 0; i < 65536; ++i) {
            if (this.elementAt((char)i) == compactCharArray.elementAt((char)i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(3, this.values.length / 16);
        for (int i = 0; i < this.values.length; i += n2) {
            n = n * 37 + this.values[i];
        }
        return n;
    }

    private void expand() {
        if (this.isCompact) {
            int n;
            char[] cArray = new char[65536];
            this.hashes = new int[2048];
            for (n = 0; n < 65536; ++n) {
                char c;
                cArray[n] = c = this.elementAt((char)n);
                this.touchBlock(n >> 5, c);
            }
            for (n = 0; n < 2048; ++n) {
                this.indices[n] = (char)(n << 5);
            }
            this.values = null;
            this.values = cArray;
            this.isCompact = false;
        }
    }

    private char getArrayValue(int n) {
        return this.values[n];
    }

    private char getIndexArrayValue(int n) {
        return this.indices[n];
    }
}

