/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import sun.awt.dnd.SunDragSourceContextPeer;

class BasicDragGestureRecognizer
implements MouseListener,
MouseMotionListener {
    private MouseEvent dndArmedEvent = null;

    BasicDragGestureRecognizer() {
    }

    private static int getMotionThreshold() {
        return DragSource.getDragThreshold();
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        if ((n & 0x400) != 1024) {
            return 0;
        }
        JComponent jComponent = this.getComponent(mouseEvent);
        TransferHandler transferHandler = jComponent.getTransferHandler();
        return SunDragSourceContextPeer.convertModifiersToDropAction(n, transferHandler.getSourceActions(jComponent));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dndArmedEvent = null;
        if (this.isDragPossible(mouseEvent) && this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            this.dndArmedEvent = mouseEvent;
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dndArmedEvent = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dndArmedEvent != null) {
            mouseEvent.consume();
            int n = this.mapDragOperationFromModifiers(mouseEvent);
            if (n == 0) {
                return;
            }
            int n2 = Math.abs(mouseEvent.getX() - this.dndArmedEvent.getX());
            int n3 = Math.abs(mouseEvent.getY() - this.dndArmedEvent.getY());
            if (n2 > BasicDragGestureRecognizer.getMotionThreshold() || n3 > BasicDragGestureRecognizer.getMotionThreshold()) {
                JComponent jComponent = this.getComponent(mouseEvent);
                TransferHandler transferHandler = jComponent.getTransferHandler();
                transferHandler.exportAsDrag(jComponent, this.dndArmedEvent, n);
                this.dndArmedEvent = null;
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private TransferHandler getTransferHandler(MouseEvent mouseEvent) {
        JComponent jComponent = this.getComponent(mouseEvent);
        return jComponent == null ? null : jComponent.getTransferHandler();
    }

    protected boolean isDragPossible(MouseEvent mouseEvent) {
        JComponent jComponent = this.getComponent(mouseEvent);
        return jComponent == null ? true : jComponent.getTransferHandler() != null;
    }

    protected JComponent getComponent(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof JComponent) {
            JComponent jComponent = (JComponent)object;
            return jComponent;
        }
        return null;
    }
}

