/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TimerQueue;
import sun.awt.AppContext;

class SystemEventQueueUtilities {
    private static final Object classLock = new Object();
    private static final Object rootTableKey = new Object();

    SystemEventQueueUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getRootTable() {
        Map map = (Map)AppContext.getAppContext().get(rootTableKey);
        if (map == null) {
            Object object = rootTableKey;
            synchronized (object) {
                map = (Map)AppContext.getAppContext().get(rootTableKey);
                if (map == null) {
                    map = Collections.synchronizedMap(new WeakHashMap(4));
                    AppContext.getAppContext().put(rootTableKey, map);
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void queueComponentWorkRequest(Component component) {
        boolean bl;
        ComponentWorkRequest componentWorkRequest = (ComponentWorkRequest)SystemEventQueueUtilities.getRootTable().get(component);
        boolean bl2 = bl = componentWorkRequest == null;
        if (bl) {
            componentWorkRequest = new ComponentWorkRequest(component);
        }
        ComponentWorkRequest componentWorkRequest2 = componentWorkRequest;
        synchronized (componentWorkRequest2) {
            if (bl) {
                SystemEventQueueUtilities.getRootTable().put(component, componentWorkRequest);
            }
            if (!componentWorkRequest.isPending) {
                SwingUtilities.invokeLater(componentWorkRequest);
                componentWorkRequest.isPending = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addRunnableCanvas(JRootPane jRootPane) {
        Object object = classLock;
        synchronized (object) {
            if (SystemEventQueue.get(jRootPane) != null) {
                return;
            }
            JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
            if (jLayeredPane != null) {
                RunnableCanvas runnableCanvas = new RunnableCanvas(jRootPane);
                jLayeredPane.add(runnableCanvas);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeRunnableCanvas(JRootPane jRootPane) {
        Object object = classLock;
        synchronized (object) {
            JRootPane jRootPane2 = null;
            for (Container container = jRootPane; container != null; container = container.getParent()) {
                if (!(container instanceof Window) && !(container instanceof Applet)) continue;
                jRootPane2 = container;
                break;
            }
            if (jRootPane2 != null) {
                SystemEventQueueUtilities.getRootTable().remove(jRootPane2);
            }
            RunnableCanvas.remove(jRootPane);
        }
    }

    static Exception postRunnable(Runnable runnable, Object object) {
        EventQueue eventQueue = SystemEventQueue.get();
        RunnableEvent runnableEvent = new RunnableEvent(runnable, object);
        if (eventQueue != null) {
            eventQueue.postEvent(runnableEvent);
        } else {
            SystemEventQueueUtilities.postRunnableCanvasEvent(runnableEvent);
        }
        return runnableEvent.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void restartTimerQueueThread() {
        Object object = classLock;
        synchronized (object) {
            if (SystemEventQueue.get() == null) {
                TimerQueueRestart timerQueueRestart = new TimerQueueRestart();
                RunnableEvent runnableEvent = new RunnableEvent(timerQueueRestart, null);
                RunnableCanvas.postRunnableEventToAll(runnableEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processRunnableEvent(RunnableEvent runnableEvent) {
        Object object = runnableEvent.lock;
        if (object == null) {
            runnableEvent.doRun.run();
        } else {
            Object object2 = object;
            synchronized (object2) {
                try {
                    runnableEvent.doRun.run();
                }
                catch (Exception exception) {
                    runnableEvent.exception = exception;
                }
                finally {
                    if (runnableEvent.lock != null) {
                        runnableEvent.lock.notify();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postRunnableCanvasEvent(RunnableEvent runnableEvent) {
        Object object = classLock;
        synchronized (object) {
            RunnableCanvas runnableCanvas = RunnableCanvas.lookup(runnableEvent);
            if (runnableCanvas == null) {
                if (runnableEvent.doRun instanceof ComponentWorkRequest) {
                    ComponentWorkRequest componentWorkRequest;
                    ComponentWorkRequest componentWorkRequest2 = componentWorkRequest = (ComponentWorkRequest)runnableEvent.doRun;
                    synchronized (componentWorkRequest2) {
                        componentWorkRequest.isPending = false;
                    }
                }
                if (runnableEvent.doRun instanceof Timer.DoPostEvent) {
                    ((Timer.DoPostEvent)runnableEvent.doRun).getTimer().cancelEvent();
                }
                if (runnableEvent.lock != null) {
                    runnableEvent.lock.notify();
                }
                return;
            }
            runnableCanvas.addRunnableEvent(runnableEvent);
            runnableCanvas.repaint();
        }
    }

    private static ThreadGroup getThreadGroupSafely() {
        return new Thread().getThreadGroup();
    }

    private static class ComponentWorkRequest
    implements Runnable {
        boolean isPending;
        Component component;

        ComponentWorkRequest(Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RepaintManager repaintManager;
            ComponentWorkRequest componentWorkRequest = this;
            synchronized (componentWorkRequest) {
                repaintManager = RepaintManager.currentManager(this.component);
                this.isPending = false;
            }
            repaintManager.validateInvalidComponents();
            repaintManager.paintDirtyRegions();
        }
    }

    private static class RunnableCanvas
    extends Canvas {
        private static final Graphics nullGraphics = new RunnableCanvasGraphics();
        private static Hashtable runnableCanvasTable = new Hashtable(1);
        private Vector runnableEvents = new Vector(2);
        private boolean isRegistered = false;

        RunnableCanvas(JRootPane jRootPane) {
            this.setBounds(0, 0, 1, 1);
            if (runnableCanvasTable.get(Thread.currentThread()) == null) {
                try {
                    runnableCanvasTable.put(Thread.currentThread(), this);
                    runnableCanvasTable.put(SystemEventQueueUtilities.getThreadGroupSafely(), this);
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.isRegistered = true;
                    }
                }
                catch (Exception exception) {
                    System.err.println("Can't register RunnableCanvas");
                    exception.printStackTrace();
                }
            }
            runnableCanvasTable.put(jRootPane, this);
            this.maybeRegisterEventDispatchThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeRegisterEventDispatchThread() {
            if (!this.isRegistered) {
                RunnableCanvas runnableCanvas = this;
                synchronized (runnableCanvas) {
                    if (!this.isRegistered && SwingUtilities.isEventDispatchThread()) {
                        Thread thread = Thread.currentThread();
                        if (runnableCanvasTable.get(thread) != null) {
                            this.isRegistered = true;
                        } else {
                            runnableCanvasTable.put(thread, this);
                            runnableCanvasTable.put(SystemEventQueueUtilities.getThreadGroupSafely(), this);
                            this.isRegistered = true;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static RunnableCanvas lookup(RunnableEvent runnableEvent) {
            ThreadGroup threadGroup;
            if (runnableEvent.doRun instanceof ComponentWorkRequest) {
                ComponentWorkRequest componentWorkRequest;
                ComponentWorkRequest componentWorkRequest2 = componentWorkRequest = (ComponentWorkRequest)runnableEvent.doRun;
                synchronized (componentWorkRequest2) {
                    JRootPane jRootPane = SwingUtilities.getRootPane(componentWorkRequest.component);
                    if (jRootPane != null) {
                        return (RunnableCanvas)runnableCanvasTable.get(jRootPane);
                    }
                    componentWorkRequest.isPending = false;
                    return null;
                }
            }
            Object v = runnableCanvasTable.get(Thread.currentThread());
            if (v != null) {
                return (RunnableCanvas)v;
            }
            try {
                threadGroup = Thread.currentThread().getThreadGroup();
            }
            catch (SecurityException securityException) {
                return null;
            }
            RunnableCanvas runnableCanvas = (RunnableCanvas)runnableCanvasTable.get(threadGroup);
            if (runnableCanvas == null) {
                Enumeration enumeration = runnableCanvasTable.keys();
                if (enumeration == null) {
                    return null;
                }
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    if (!(k instanceof JRootPane) || !((JRootPane)k).isShowing()) continue;
                    return (RunnableCanvas)runnableCanvasTable.get(k);
                }
            }
            return runnableCanvas;
        }

        static void postRunnableEventToAll(RunnableEvent runnableEvent) {
            ThreadGroup threadGroup;
            try {
                threadGroup = new Thread().getThreadGroup();
            }
            catch (SecurityException securityException) {
                threadGroup = null;
            }
            RunnableCanvas runnableCanvas = threadGroup != null ? (RunnableCanvas)runnableCanvasTable.get(threadGroup) : null;
            Enumeration enumeration = runnableCanvasTable.keys();
            while (enumeration.hasMoreElements()) {
                Object v;
                Object k = enumeration.nextElement();
                if (!(k instanceof JRootPane) || (v = runnableCanvasTable.get(k)) == runnableCanvas) continue;
                RunnableCanvas runnableCanvas2 = (RunnableCanvas)v;
                runnableCanvas2.addRunnableEvent(runnableEvent);
                runnableCanvas2.repaint();
            }
        }

        static void remove(JRootPane jRootPane) {
            RunnableCanvas runnableCanvas = (RunnableCanvas)runnableCanvasTable.get(jRootPane);
            if (runnableCanvas != null) {
                int n;
                Object object;
                RunnableCanvas runnableCanvas2 = null;
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                jLayeredPane.remove(runnableCanvas);
                Enumeration enumeration = runnableCanvasTable.keys();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    Object v = runnableCanvasTable.get(object);
                    if (runnableCanvas == v) {
                        runnableCanvasTable.remove(object);
                        continue;
                    }
                    if (runnableCanvas2 != null) continue;
                    runnableCanvas2 = (RunnableCanvas)v;
                }
                object = runnableCanvas.getRunnableCanvasEvents();
                int n2 = n = object == null ? 0 : ((K)object).length;
                if (n > 0) {
                    if (runnableCanvas2 != null) {
                        for (int i = 0; i < n; ++i) {
                            Object k = object[i];
                            if (!(((RunnableEvent)k).doRun instanceof Timer.DoPostEvent)) continue;
                            runnableCanvas2.addRunnableEvent((RunnableEvent)k);
                        }
                        runnableCanvas2.repaint();
                    } else {
                        for (int i = 0; i < n; ++i) {
                            Object k = object[i];
                            if (!(((RunnableEvent)k).doRun instanceof Timer.DoPostEvent)) continue;
                            ((Timer.DoPostEvent)((RunnableEvent)k).doRun).getTimer().cancelEvent();
                        }
                    }
                }
            }
        }

        public boolean isShowing() {
            return this.runnableEvents.size() > 0;
        }

        public Graphics getGraphics() {
            return nullGraphics;
        }

        public Dimension getPreferredSize() {
            return new Dimension(1, 1);
        }

        synchronized void addRunnableEvent(RunnableEvent runnableEvent) {
            this.runnableEvents.addElement(runnableEvent);
        }

        private synchronized RunnableEvent[] getRunnableCanvasEvents() {
            int n = this.runnableEvents.size();
            if (n == 0) {
                return null;
            }
            RunnableEvent[] runnableEventArray = new RunnableEvent[n];
            for (int i = 0; i < n; ++i) {
                runnableEventArray[i] = (RunnableEvent)this.runnableEvents.elementAt(i);
            }
            this.runnableEvents.removeAllElements();
            return runnableEventArray;
        }

        public void paint(Graphics graphics) {
            this.maybeRegisterEventDispatchThread();
        }

        public void update(Graphics graphics) {
            RunnableEvent[] runnableEventArray = this.getRunnableCanvasEvents();
            if (runnableEventArray != null) {
                for (int i = 0; i < runnableEventArray.length; ++i) {
                    SystemEventQueueUtilities.processRunnableEvent(runnableEventArray[i]);
                }
            }
        }
    }

    private static class RunnableCanvasGraphics
    extends Graphics {
        private RunnableCanvasGraphics() {
        }

        public Graphics create() {
            return this;
        }

        public Rectangle getClipBounds() {
            return new Rectangle(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        }

        public Shape getClip() {
            return this.getClipBounds();
        }

        public void dispose() {
        }

        public void translate(int n, int n2) {
        }

        public Color getColor() {
            return Color.black;
        }

        public void setColor(Color color) {
        }

        public void setPaintMode() {
        }

        public void setXORMode(Color color) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        public void clipRect(int n, int n2, int n3, int n4) {
        }

        public void setClip(int n, int n2, int n3, int n4) {
        }

        public void setClip(Shape shape) {
        }

        public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void drawLine(int n, int n2, int n3, int n4) {
        }

        public void fillRect(int n, int n2, int n3, int n4) {
        }

        public void clearRect(int n, int n2, int n3, int n4) {
        }

        public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void drawOval(int n, int n2, int n3, int n4) {
        }

        public void fillOval(int n, int n2, int n3, int n4) {
        }

        public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        }

        public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        }

        public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        }

        public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        }

        public void drawString(String string, int n, int n2) {
        }

        public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        }

        public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
            return false;
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
            return false;
        }
    }

    private static class RunnableEvent
    extends AWTEvent {
        static final int EVENT_ID = 2999;
        static final Component target = new RunnableTarget();
        final Runnable doRun;
        final Object lock;
        Exception exception;

        RunnableEvent(Runnable runnable, Object object) {
            super(target, 2999);
            this.doRun = runnable;
            this.lock = object;
        }
    }

    private static class RunnableTarget
    extends Component {
        RunnableTarget() {
            this.enableEvents(2999L);
        }

        protected void processEvent(AWTEvent aWTEvent) {
            if (aWTEvent instanceof RunnableEvent) {
                SystemEventQueueUtilities.processRunnableEvent((RunnableEvent)aWTEvent);
            }
        }
    }

    private static class SystemEventQueue {
        private SystemEventQueue() {
        }

        static EventQueue get() {
            EventQueue eventQueue;
            try {
                eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            }
            catch (SecurityException securityException) {
                eventQueue = null;
            }
            return eventQueue;
        }

        static EventQueue get(JRootPane jRootPane) {
            return SystemEventQueue.get();
        }
    }

    private static class TimerQueueRestart
    implements Runnable {
        boolean attemptedStart;

        private TimerQueueRestart() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            if (!this.attemptedStart) {
                TimerQueue timerQueue;
                TimerQueue timerQueue2 = timerQueue = TimerQueue.sharedInstance();
                synchronized (timerQueue2) {
                    if (!timerQueue.running) {
                        timerQueue.start();
                    }
                }
                this.attemptedStart = true;
            }
        }
    }
}

