/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.com;

import java.lang.reflect.Array;
import java.text.NumberFormat;
import java.text.ParseException;
import netscape.javascript.JSObject;
import sun.plugin.com.WrapperJSObject;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.util.Trace;

public class TypeConverter {
    static Object[] convertObjectArray(Class[] classArray, Object[] objectArray) throws IllegalArgumentException {
        if (objectArray == null || objectArray.length == 0) {
            return objectArray;
        }
        if (classArray.length != objectArray.length) {
            throw new IllegalArgumentException(ResourceHandler.getMessage("com.method.argCountInvalid"));
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = TypeConverter.convertObject(classArray[i], objectArray[i]);
        }
        return objectArray2;
    }

    public static Object convertObject(Class clazz, Object object) throws IllegalArgumentException {
        if (object == null) {
            return object;
        }
        Class<?> clazz2 = object.getClass();
        Trace.msgLiveConnectPrintln("com.field.needsConversion", new Object[]{clazz2.getName(), clazz.getName()});
        if (clazz.isAssignableFrom(clazz2)) {
            return object;
        }
        if (clazz.equals(JSObject.class)) {
            return new WrapperJSObject(object);
        }
        if (clazz == String.class) {
            if (object instanceof Number) {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                try {
                    return numberFormat.parse(object.toString()).toString();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return object.toString();
        }
        if (clazz.isArray()) {
            if (clazz2.isArray()) {
                Class<?> clazz3 = clazz.getComponentType();
                int n = Array.getLength(object);
                Object object2 = Array.newInstance(clazz3, n);
                for (int i = 0; i < n; ++i) {
                    Array.set(object2, i, TypeConverter.convertObject(clazz3, Array.get(object, i)));
                }
                return object2;
            }
        } else if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || clazz == Character.class || clazz == Boolean.class) {
            String string = clazz.getName();
            boolean bl = object instanceof Number;
            boolean bl2 = object instanceof String;
            if (string.equals("boolean") || string.equals("java.lang.Boolean")) {
                return new Boolean(object.toString());
            }
            if (string.equals("byte") || string.equals("java.lang.Byte")) {
                if (bl2) {
                    return Byte.valueOf((String)object);
                }
                if (bl) {
                    return new Byte(((Number)object).byteValue());
                }
            } else if (string.equals("short") || string.equals("java.lang.Short")) {
                if (bl2) {
                    return Short.valueOf((String)object);
                }
                if (bl) {
                    return new Short(((Number)object).shortValue());
                }
            } else if (string.equals("int") || string.equals("java.lang.Integer")) {
                if (bl2) {
                    return Integer.valueOf((String)object);
                }
                if (bl) {
                    return new Integer(((Number)object).intValue());
                }
            } else if (string.equals("long") || string.equals("java.lang.Long")) {
                if (bl2) {
                    return Long.valueOf((String)object);
                }
                if (bl) {
                    return new Long(((Number)object).longValue());
                }
            } else if (string.equals("float") || string.equals("java.lang.Float")) {
                if (bl2) {
                    return Float.valueOf((String)object);
                }
                if (bl) {
                    return new Float(((Number)object).floatValue());
                }
            } else if (string.equals("double") || string.equals("java.lang.Double")) {
                if (bl2) {
                    return Double.valueOf((String)object);
                }
                if (bl) {
                    return new Double(((Number)object).doubleValue());
                }
            } else if (string.equals("char") || string.equals("java.lang.Character")) {
                if (bl2) {
                    return new Character((char)Short.decode((String)object).shortValue());
                }
                if (bl) {
                    return new Character((char)((Number)object).shortValue());
                }
            } else {
                return object;
            }
        }
        throw new IllegalArgumentException(clazz2.getName() + ResourceHandler.getMessage("com.field.typeInvalid") + clazz.getName());
    }
}

