/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XMBeanAttributes;
import sun.tools.jconsole.inspector.XPlotter;

public class XPlottingViewer
extends JPanel
implements ActionListener {
    private JButton plotButton;
    private static HashMap<String, XPlottingViewer> plotterCache = new HashMap();
    private static HashMap<String, Timer> timerCache = new HashMap();
    private JPanel bordered;
    private Number value;
    private MBeansTab tab;
    private XMBean mbean;
    private String attributeName;
    private Plotter plotter;
    private String key;
    private JTable table;

    private XPlottingViewer(String string, XMBean xMBean, String string2, Object object, JTable jTable, MBeansTab mBeansTab) {
        this.tab = mBeansTab;
        this.key = string;
        this.mbean = xMBean;
        this.table = jTable;
        this.attributeName = string2;
        this.plotter = this.createPlotter(xMBean, string2, string, jTable);
        this.setupDisplay();
    }

    private Plotter getPlotter() {
        return this.plotter;
    }

    static void dispose(MBeansTab mBeansTab) {
        String string;
        Iterator<String> iterator = plotterCache.keySet().iterator();
        while (iterator.hasNext()) {
            string = iterator.next();
            if (!string.startsWith(String.valueOf(mBeansTab.hashCode()))) continue;
            iterator.remove();
        }
        iterator = timerCache.keySet().iterator();
        while (iterator.hasNext()) {
            string = iterator.next();
            if (!string.startsWith(String.valueOf(mBeansTab.hashCode()))) continue;
            Timer timer = timerCache.get(string);
            timer.cancel();
            iterator.remove();
        }
    }

    public static boolean isViewableValue(Object object) {
        return object instanceof Number;
    }

    public static Component loadPlotting(XMBean xMBean, String string, Object object, JTable jTable, MBeansTab mBeansTab) {
        XPlottingViewer xPlottingViewer = null;
        if (XPlottingViewer.isViewableValue(object)) {
            String string2 = String.valueOf(mBeansTab.hashCode()) + " " + String.valueOf(xMBean.hashCode()) + " " + xMBean.getObjectName().getCanonicalName() + string;
            XPlottingViewer xPlottingViewer2 = plotterCache.get(string2);
            if (xPlottingViewer2 == null) {
                xPlottingViewer2 = new XPlottingViewer(string2, xMBean, string, object, jTable, mBeansTab);
                plotterCache.put(string2, xPlottingViewer2);
            }
            xPlottingViewer = xPlottingViewer2;
        }
        return xPlottingViewer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        plotterCache.remove(this.key);
        Timer timer = timerCache.remove(this.key);
        timer.cancel();
        ((XMBeanAttributes)this.table).collapse(this.attributeName, this);
    }

    public Plotter createPlotter(final XMBean xMBean, final String string, String string2, JTable jTable) {
        final XPlotter xPlotter = new XPlotter(jTable, false){
            Dimension prefSize;
            {
                this.prefSize = new Dimension(400, 170);
            }

            public Dimension getPreferredSize() {
                return this.prefSize;
            }

            public Dimension getMinimumSize() {
                return this.prefSize;
            }
        };
        xPlotter.createSequence(string, string, null, true);
        TimerTask timerTask = new TimerTask(){

            public void run() {
                XPlottingViewer.this.tab.workerAdd(new Runnable(){

                    public void run() {
                        try {
                            Number number = (Number)xMBean.getMBeanServerConnection().getAttribute(xMBean.getObjectName(), string);
                            xPlotter.addValue(string, number.longValue());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        String string3 = "Timer-" + string2;
        Timer timer = new Timer(string3, true);
        timer.schedule(timerTask, 0L, (long)this.tab.getUpdateInterval());
        timerCache.put(string2, timer);
        return xPlotter;
    }

    private void setupDisplay() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.white);
        this.plotButton = new JButton(Resources.getText("Discard chart", new Object[0]));
        this.plotButton.addActionListener(this);
        this.plotButton.setEnabled(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.plotButton, gridBagConstraints);
        this.add(this.plotButton);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 3;
        gridBagLayout.setConstraints(this.plotter, gridBagConstraints2);
        this.add(this.plotter);
        this.repaint();
    }
}

